/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import jakarta.faces.application.Application;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.FacesContextWrapper;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.primefaces.util.LangUtils;
import org.primefaces.util.LocaleUtils;

public class MessageFactory {
    private static final String DEFAULT_BUNDLE_BASENAME = "jakarta.faces.Messages";
    private static final String PRIMEFACES_BUNDLE_BASENAME = "org.primefaces.Messages";
    private static final String DEFAULT_DETAIL_SUFFIX = "_detail";

    private MessageFactory() {
    }

    public static FacesMessage getFacesMessage(String messageId, FacesMessage.Severity severity, Object ... params) {
        FacesMessage facesMessage = MessageFactory.getFacesMessage(LocaleUtils.getCurrentLocale(), messageId, params);
        facesMessage.setSeverity(severity);
        return facesMessage;
    }

    public static FacesMessage getFacesMessage(Locale locale, String messageId, Object ... params) {
        String summary = null;
        String detail = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        String userBundleName = application.getMessageBundle();
        ResourceBundle bundle = null;
        ClassLoader currentClassLoader = LangUtils.getCurrentClassLoader(application.getClass());
        if (userBundleName != null) {
            try {
                bundle = MessageFactory.getBundle(userBundleName, locale, currentClassLoader, facesContext);
                if (bundle.containsKey(messageId)) {
                    summary = bundle.getString(messageId);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (summary == null) {
            try {
                bundle = MessageFactory.getBundle(PRIMEFACES_BUNDLE_BASENAME, locale, currentClassLoader, facesContext);
                if (bundle == null) {
                    throw new NullPointerException();
                }
                if (bundle.containsKey(messageId)) {
                    summary = bundle.getString(messageId);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (summary == null) {
            try {
                bundle = MessageFactory.getBundle(DEFAULT_BUNDLE_BASENAME, locale, currentClassLoader, facesContext);
                if (bundle == null) {
                    throw new NullPointerException();
                }
                if (bundle.containsKey(messageId)) {
                    summary = bundle.getString(messageId);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        summary = MessageFactory.getFormattedText(locale, summary, params);
        if (bundle != null) {
            try {
                String detailMessageId = messageId + DEFAULT_DETAIL_SUFFIX;
                if (bundle.containsKey(detailMessageId)) {
                    detail = MessageFactory.getFormattedText(locale, bundle.getString(detailMessageId), params);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return new FacesMessage(summary, detail);
    }

    public static String getMessage(String messageId, Object ... params) {
        return MessageFactory.getMessage(LocaleUtils.getCurrentLocale(), messageId, params);
    }

    public static String getMessage(Locale locale, String messageId, Object ... params) {
        String summary = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application application = facesContext.getApplication();
        String userBundleName = application.getMessageBundle();
        ResourceBundle bundle = null;
        ClassLoader currentClassLoader = LangUtils.getCurrentClassLoader(application.getClass());
        if (userBundleName != null) {
            try {
                bundle = MessageFactory.getBundle(userBundleName, locale, currentClassLoader, facesContext);
                if (bundle.containsKey(messageId)) {
                    summary = bundle.getString(messageId);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (summary == null) {
            try {
                bundle = MessageFactory.getBundle(PRIMEFACES_BUNDLE_BASENAME, locale, currentClassLoader, facesContext);
                if (bundle == null) {
                    throw new NullPointerException();
                }
                if (bundle.containsKey(messageId)) {
                    summary = bundle.getString(messageId);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (summary == null) {
            try {
                bundle = MessageFactory.getBundle(DEFAULT_BUNDLE_BASENAME, locale, currentClassLoader, facesContext);
                if (bundle == null) {
                    throw new NullPointerException();
                }
                if (bundle.containsKey(messageId)) {
                    summary = bundle.getString(messageId);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        summary = MessageFactory.getFormattedText(locale, summary, params);
        return summary;
    }

    public static String getFormattedText(Locale locale, String message, Object ... params) {
        if (params == null || params.length == 0 || LangUtils.isValueBlank(message)) {
            return message;
        }
        MessageFormat messageFormat = null;
        messageFormat = locale != null ? new MessageFormat(message, locale) : new MessageFormat(message);
        return messageFormat.format(params);
    }

    public static Object getLabel(FacesContext facesContext, UIComponent component) {
        String label = (String)component.getAttributes().get("label");
        if (label == null) {
            label = component.getClientId(facesContext);
        }
        return label;
    }

    private static ResourceBundle getBundle(String baseName, Locale locale, ClassLoader classLoader, FacesContext facesContext) {
        ClassLoader jsfImplClassLoader;
        if (PRIMEFACES_BUNDLE_BASENAME.equals(baseName)) {
            ClassLoader primeFacesClassLoader = MessageFactory.class.getClassLoader();
            if (!primeFacesClassLoader.equals(classLoader)) {
                return ResourceBundle.getBundle(baseName, locale, classLoader, new OSGiFriendlyControl(primeFacesClassLoader));
            }
        } else if (DEFAULT_BUNDLE_BASENAME.equals(baseName) && !(jsfImplClassLoader = MessageFactory.getJSFImplClassLoader(facesContext)).equals(classLoader)) {
            return ResourceBundle.getBundle(baseName, locale, classLoader, new OSGiFriendlyControl(jsfImplClassLoader));
        }
        return ResourceBundle.getBundle(baseName, locale, classLoader);
    }

    private static ClassLoader getJSFImplClassLoader(FacesContext facesContext) {
        facesContext = MessageFactory.unwrapFacesContext(facesContext);
        Class facesContextImplClass = FacesContext.class;
        if (facesContext != null) {
            facesContextImplClass = facesContext.getClass();
        }
        return facesContextImplClass.getClassLoader();
    }

    private static FacesContext unwrapFacesContext(FacesContext facesContext) {
        if (!(facesContext instanceof FacesContextWrapper)) {
            return facesContext;
        }
        FacesContextWrapper wrapper = (FacesContextWrapper)facesContext;
        FacesContext unwrapped = wrapper.getWrapped();
        if (unwrapped == null || FacesContext.class.equals(unwrapped.getClass())) {
            return facesContext;
        }
        return MessageFactory.unwrapFacesContext(unwrapped);
    }

    private static final class OSGiFriendlyControl
    extends ResourceBundle.Control {
        private final ClassLoader osgiBundleClassLoader;

        public OSGiFriendlyControl(ClassLoader osgiBundleClassLoader) {
            this.osgiBundleClassLoader = osgiBundleClassLoader;
        }

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader classLoader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            ResourceBundle resourceBundle = super.newBundle(baseName, locale, format, classLoader, reload);
            if (resourceBundle == null && !this.osgiBundleClassLoader.equals(classLoader)) {
                resourceBundle = super.newBundle(baseName, locale, format, this.osgiBundleClassLoader, reload);
            }
            return resourceBundle;
        }
    }
}

