/*
 * The MIT License
 *
 * Copyright (c) 2009-2021 PrimeTek
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.primefaces.component.chips;

import org.primefaces.component.api.AbstractPrimeHtmlInputText;
import org.primefaces.component.api.InputHolder;
import org.primefaces.component.api.MixedClientBehaviorHolder;
import org.primefaces.component.api.Widget;

public abstract class ChipsBase extends AbstractPrimeHtmlInputText implements Widget, InputHolder, MixedClientBehaviorHolder {

    public static final String COMPONENT_FAMILY = "org.primefaces.component";

    public static final String DEFAULT_RENDERER = "org.primefaces.component.ChipsRenderer";

    public enum PropertyKeys {

        placeholder,
        widgetVar,
        max,
        inputStyle,
        inputStyleClass,
        addOnBlur,
        addOnPaste,
        unique,
        separator
    }

    public ChipsBase() {
        setRendererType(DEFAULT_RENDERER);
    }

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getPlaceholder() {
        return (String) getStateHelper().eval(PropertyKeys.placeholder, null);
    }

    public void setPlaceholder(String placeholder) {
        getStateHelper().put(PropertyKeys.placeholder, placeholder);
    }

    public String getWidgetVar() {
        return (String) getStateHelper().eval(PropertyKeys.widgetVar, null);
    }

    public void setWidgetVar(String widgetVar) {
        getStateHelper().put(PropertyKeys.widgetVar, widgetVar);
    }

    public int getMax() {
        return (Integer) getStateHelper().eval(PropertyKeys.max, Integer.MAX_VALUE);
    }

    public void setMax(int max) {
        getStateHelper().put(PropertyKeys.max, max);
    }

    public String getInputStyle() {
        return (String) getStateHelper().eval(PropertyKeys.inputStyle, null);
    }

    public void setInputStyle(String inputStyle) {
        getStateHelper().put(PropertyKeys.inputStyle, inputStyle);
    }

    public String getInputStyleClass() {
        return (String) getStateHelper().eval(PropertyKeys.inputStyleClass, null);
    }

    public void setInputStyleClass(String inputStyleClass) {
        getStateHelper().put(PropertyKeys.inputStyleClass, inputStyleClass);
    }

    public boolean isAddOnBlur() {
        return (Boolean) getStateHelper().eval(PropertyKeys.addOnBlur, false);
    }

    public void setAddOnBlur(boolean addOnBlur) {
        getStateHelper().put(PropertyKeys.addOnBlur, addOnBlur);
    }

    public boolean isAddOnPaste() {
        return (Boolean) getStateHelper().eval(PropertyKeys.addOnPaste, false);
    }

    public void setAddOnPaste(boolean addOnPaste) {
        getStateHelper().put(PropertyKeys.addOnPaste, addOnPaste);
    }

    public boolean isUnique() {
        return (Boolean) getStateHelper().eval(PropertyKeys.unique, false);
    }

    public void setUnique(boolean unique) {
        getStateHelper().put(PropertyKeys.unique, unique);
    }

    public String getSeparator() {
        return (String) getStateHelper().eval(PropertyKeys.separator, ",");
    }

    public void setSeparator(String separator) {
        getStateHelper().put(PropertyKeys.separator, separator);
    }
}