/*
 * The MIT License
 *
 * Copyright (c) 2009-2021 PrimeTek
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package org.primefaces.component.messages;

import javax.faces.application.ResourceDependency;

@ResourceDependency(library = "primefaces", name = "components.css")
public class Messages extends MessagesBase {

    public static final String COMPONENT_TYPE = "org.primefaces.component.Messages";

    public static final String CONTAINER_CLASS = "ui-messages ui-widget";
    public static final String ICONLESS_CONTAINER_CLASS = "ui-messages ui-messages-noicon ui-widget";
    public static final String CLOSE_LINK_CLASS = "ui-messages-close";
    public static final String CLOSE_ICON_CLASS = "ui-icon ui-icon-close";
    public static final String SEVERITY_PREFIX_CLASS = "ui-messages-";

    public static final String ARIA_CLOSE = "primefaces.messages.aria.CLOSE";
    public static final String ARIA_INFO = "primefaces.messages.aria.INFO";
    public static final String ARIA_ERROR = "primefaces.messages.aria.ERROR";
    public static final String ARIA_WARN = "primefaces.messages.aria.WARN";
    public static final String ARIA_FATAL = "primefaces.messages.aria.FATAL";

}