/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datagrid;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.datagrid.DataGrid;
import org.primefaces.component.datagrid.DataGridState;
import org.primefaces.renderkit.DataRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.GridLayoutUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class DataGridRenderer
extends DataRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DataGrid grid = (DataGrid)component;
        if (grid.isPaginationRequest(context)) {
            grid.updatePaginationData(context);
            if (grid.isLazy()) {
                grid.loadLazyData();
            }
            this.encodeContent(context, grid);
            if (grid.isMultiViewState()) {
                DataGridState gs = grid.getMultiViewState(true);
                gs.setFirst(grid.getFirst());
                gs.setRows(grid.getRows());
            }
        } else {
            if (grid.isMultiViewState()) {
                grid.restoreMultiViewState();
            }
            this.encodeMarkup(context, grid);
            this.encodeScript(context, grid);
        }
    }

    protected void encodeScript(FacesContext context, DataGrid grid) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("DataGrid", grid);
        if (grid.isPaginator()) {
            this.encodePaginatorConfig(context, grid, wb);
        }
        this.encodeClientBehaviors(context, grid);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, DataGrid grid) throws IOException {
        String contentClass;
        if (grid.isLazy()) {
            grid.loadLazyData();
        }
        ResponseWriter writer = context.getResponseWriter();
        String clientId = grid.getClientId(context);
        boolean hasPaginator = grid.isPaginator();
        boolean empty = grid.getRowCount() == 0;
        String layout = grid.getLayout();
        String paginatorPosition = grid.getPaginatorPosition();
        boolean flex = ComponentUtils.isFlex(context, grid);
        String gridContentClass = flex ? "ui-datagrid-content ui-widget-content p-grid" : "ui-datagrid-content ui-widget-content ui-grid ui-grid-responsive";
        String style = grid.getStyle();
        String styleClass = grid.getStyleClass() == null ? "ui-datagrid ui-widget" : "ui-datagrid ui-widget " + grid.getStyleClass();
        String layoutClass = "tabular".equals(layout) ? "ui-datagrid-content ui-widget-content" : gridContentClass;
        String string = contentClass = empty ? "ui-datagrid-content ui-datagrid-content-empty ui-widget-content" : layoutClass;
        if (hasPaginator) {
            grid.calculateFirst();
        }
        writer.startElement("div", (UIComponent)grid);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        this.encodeFacet(context, grid, "header", "ui-datagrid-header ui-widget-header ui-corner-top");
        if (hasPaginator && !"bottom".equalsIgnoreCase(paginatorPosition)) {
            this.encodePaginatorMarkup(context, grid, "top");
        }
        writer.startElement("div", (UIComponent)grid);
        writer.writeAttribute("id", (Object)(clientId + "_content"), null);
        writer.writeAttribute("class", (Object)contentClass, null);
        if (empty) {
            UIComponent emptyFacet = grid.getFacet("emptyMessage");
            if (ComponentUtils.shouldRenderFacet(emptyFacet)) {
                emptyFacet.encodeAll(context);
            } else {
                writer.writeText((Object)grid.getEmptyMessage(), "emptyMessage");
            }
        } else {
            this.encodeContent(context, grid);
        }
        writer.endElement("div");
        if (hasPaginator && !"top".equalsIgnoreCase(paginatorPosition)) {
            this.encodePaginatorMarkup(context, grid, "bottom");
        }
        this.encodeFacet(context, grid, "footer", "ui-datagrid-footer ui-widget-header ui-corner-bottom");
        writer.endElement("div");
    }

    protected void encodeContent(FacesContext context, DataGrid grid) throws IOException {
        String layout = grid.getLayout();
        if ("tabular".equals(layout)) {
            this.encodeTable(context, grid);
        } else if ("grid".equals(layout)) {
            this.encodeGrid(context, grid);
        } else {
            throw new FacesException(layout + " is not a valid value for DataGrid layout. Possible values are 'tabular' and 'grid'.");
        }
    }

    protected void encodeGrid(FacesContext context, DataGrid grid) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int columns = grid.getColumns();
        int rowIndex = grid.getFirst();
        int rows = grid.getRows();
        int itemsToRender = rows != 0 ? rows : grid.getRowCount();
        int numberOfRowsToRender = (itemsToRender + columns - 1) / columns;
        int displayedItemsToRender = rowIndex + itemsToRender;
        String columnInlineStyle = grid.getRowStyle();
        boolean flex = ComponentUtils.isFlex(context, grid);
        String columnClass = this.getStyleClassBuilder(context).add("ui-datagrid-column").add(flex, GridLayoutUtils.getFlexColumnClass(columns), GridLayoutUtils.getColumnClass(columns)).add(grid.getRowStyleClass()).build();
        writer.startElement("div", null);
        if (flex) {
            writer.writeAttribute("class", (Object)"p-grid", null);
        } else {
            writer.writeAttribute("class", (Object)"ui-g", null);
        }
        block0: for (int i = 0; i < numberOfRowsToRender; ++i) {
            grid.setRowIndex(rowIndex);
            if (!grid.isRowAvailable()) break;
            for (int j = 0; j < columns; ++j) {
                writer.startElement("div", null);
                writer.writeAttribute("class", (Object)columnClass, null);
                if (!LangUtils.isEmpty(columnInlineStyle)) {
                    writer.writeAttribute("style", (Object)columnInlineStyle, null);
                }
                grid.setRowIndex(rowIndex);
                if (grid.isRowAvailable()) {
                    this.renderChildren(context, (UIComponent)grid);
                }
                writer.endElement("div");
                if (++rowIndex >= displayedItemsToRender) continue block0;
            }
        }
        writer.endElement("div");
        grid.setRowIndex(-1);
    }

    protected void encodeTable(FacesContext context, DataGrid grid) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int columns = grid.getColumns();
        int rowIndex = grid.getFirst();
        int rows = grid.getRows();
        int itemsToRender = rows != 0 ? rows : grid.getRowCount();
        int numberOfRowsToRender = (itemsToRender + columns - 1) / columns;
        writer.startElement("table", (UIComponent)grid);
        writer.writeAttribute("class", (Object)"ui-datagrid-data", null);
        writer.startElement("tbody", null);
        for (int i = 0; i < numberOfRowsToRender; ++i) {
            grid.setRowIndex(rowIndex);
            if (!grid.isRowAvailable()) break;
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)"ui-datagrid-row", null);
            for (int j = 0; j < columns; ++j) {
                writer.startElement("td", null);
                writer.writeAttribute("class", (Object)"ui-datagrid-column", null);
                grid.setRowIndex(rowIndex);
                if (grid.isRowAvailable()) {
                    this.renderChildren(context, (UIComponent)grid);
                }
                ++rowIndex;
                writer.endElement("td");
            }
            writer.endElement("tr");
        }
        grid.setRowIndex(-1);
        writer.endElement("tbody");
        writer.endElement("table");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

