/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.el.ELContext;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.primefaces.PrimeFaces;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.DataTableState;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.component.datatable.feature.SortFeature;
import org.primefaces.event.data.PostFilterEvent;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.MatchMode;
import org.primefaces.model.filter.ContainsFilterConstraint;
import org.primefaces.model.filter.EndsWithFilterConstraint;
import org.primefaces.model.filter.EqualsFilterConstraint;
import org.primefaces.model.filter.ExactFilterConstraint;
import org.primefaces.model.filter.FilterConstraint;
import org.primefaces.model.filter.FunctionFilterConstraint;
import org.primefaces.model.filter.GlobalFilterConstraint;
import org.primefaces.model.filter.GreaterThanEqualsFilterConstraint;
import org.primefaces.model.filter.GreaterThanFilterConstraint;
import org.primefaces.model.filter.InFilterConstraint;
import org.primefaces.model.filter.LessThanEqualsFilterConstraint;
import org.primefaces.model.filter.LessThanFilterConstraint;
import org.primefaces.model.filter.NegationFilterConstraintWrapper;
import org.primefaces.model.filter.RangeFilterConstraint;
import org.primefaces.model.filter.StartsWithFilterConstraint;
import org.primefaces.util.MapBuilder;

public class FilterFeature
implements DataTableFeature {
    public static final Map<MatchMode, FilterConstraint> FILTER_CONSTRAINTS = MapBuilder.builder().put(MatchMode.STARTS_WITH, new StartsWithFilterConstraint()).put(MatchMode.NOT_STARTS_WITH, (StartsWithFilterConstraint)((Object)new NegationFilterConstraintWrapper(new StartsWithFilterConstraint()))).put(MatchMode.ENDS_WITH, (StartsWithFilterConstraint)((Object)new EndsWithFilterConstraint())).put(MatchMode.NOT_ENDS_WITH, (StartsWithFilterConstraint)((Object)new NegationFilterConstraintWrapper(new EndsWithFilterConstraint()))).put(MatchMode.CONTAINS, (StartsWithFilterConstraint)((Object)new ContainsFilterConstraint())).put(MatchMode.NOT_CONTAINS, (StartsWithFilterConstraint)((Object)new NegationFilterConstraintWrapper(new ContainsFilterConstraint()))).put(MatchMode.EXACT, (StartsWithFilterConstraint)((Object)new ExactFilterConstraint())).put(MatchMode.NOT_EXACT, (StartsWithFilterConstraint)((Object)new NegationFilterConstraintWrapper(new ExactFilterConstraint()))).put(MatchMode.LESS_THAN, (StartsWithFilterConstraint)((Object)new LessThanFilterConstraint())).put(MatchMode.LESS_THAN_EQUALS, (StartsWithFilterConstraint)((Object)new LessThanEqualsFilterConstraint())).put(MatchMode.GREATER_THAN, (StartsWithFilterConstraint)((Object)new GreaterThanFilterConstraint())).put(MatchMode.GREATER_THAN_EQUALS, (StartsWithFilterConstraint)((Object)new GreaterThanEqualsFilterConstraint())).put(MatchMode.EQUALS, (StartsWithFilterConstraint)((Object)new EqualsFilterConstraint())).put(MatchMode.NOT_EQUALS, (StartsWithFilterConstraint)((Object)new NegationFilterConstraintWrapper(new EqualsFilterConstraint()))).put(MatchMode.IN, (StartsWithFilterConstraint)((Object)new InFilterConstraint())).put(MatchMode.NOT_IN, (StartsWithFilterConstraint)((Object)new NegationFilterConstraintWrapper(new InFilterConstraint()))).put(MatchMode.GLOBAL, (StartsWithFilterConstraint)((Object)new GlobalFilterConstraint())).put(MatchMode.RANGE, (StartsWithFilterConstraint)((Object)new RangeFilterConstraint())).put(MatchMode.BETWEEN, (StartsWithFilterConstraint)((Object)new RangeFilterConstraint())).put(MatchMode.NOT_BETWEEN, (StartsWithFilterConstraint)((Object)new NegationFilterConstraintWrapper(new RangeFilterConstraint()))).build();
    private static final FilterFeature INSTANCE = new FilterFeature();

    private FilterFeature() {
    }

    public static FilterFeature getInstance() {
        return INSTANCE;
    }

    private boolean isFilterRequest(FacesContext context, DataTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_filtering");
    }

    @Override
    public boolean shouldDecode(FacesContext context, DataTable table) {
        return context.getCurrentPhaseId() == PhaseId.PROCESS_VALIDATIONS && this.isFilterRequest(context, table);
    }

    @Override
    public boolean shouldEncode(FacesContext context, DataTable table) {
        return this.isFilterRequest(context, table);
    }

    @Override
    public void decode(FacesContext context, DataTable table) {
        Map<String, FilterMeta> filterBy = table.getFilterByAsMap();
        table.updateFilterByValuesWithFilterRequest(context, filterBy);
        table.setFirst(0);
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = table.getClientId(context);
        String rppValue = (String)params.get(clientId + "_rppDD");
        if (rppValue != null && !"*".equals(rppValue)) {
            table.setRows(Integer.parseInt(rppValue));
        }
        if (table.isMultiViewState()) {
            DataTableState ts = table.getMultiViewState(true);
            ts.setFilterBy(filterBy);
            if (table.isPaginator()) {
                ts.setFirst(table.getFirst());
                ts.setRows(table.getRows());
            }
        }
    }

    @Override
    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        if (table.isLazy()) {
            if (table.isLiveScroll()) {
                table.loadLazyScrollData(0, table.getScrollRows());
            } else if (table.isVirtualScroll()) {
                int rows = table.getRows();
                int scrollRows = table.getScrollRows();
                int virtualScrollRows = scrollRows * 2;
                scrollRows = rows == 0 ? virtualScrollRows : Math.min(virtualScrollRows, rows);
                table.loadLazyScrollData(0, scrollRows);
            } else {
                table.loadLazyData();
            }
        } else {
            this.filter(context, table);
            if (table.isSortingCurrentlyActive()) {
                SortFeature.getInstance().sort(context, table);
            }
        }
        context.getApplication().publishEvent(context, PostFilterEvent.class, (Object)table);
        if (!table.isFullUpdateRequest(context)) {
            renderer.encodeTbody(context, table, true);
        }
    }

    public void filter(FacesContext context, DataTable table) {
        ArrayList<Object> filtered = new ArrayList<Object>();
        Locale filterLocale = table.resolveDataLocale();
        ELContext elContext = context.getELContext();
        Map<String, FilterMeta> filterBy = table.getFilterByAsMap();
        FilterMeta globalFilter = filterBy.get("globalFilter");
        boolean hasGlobalFilterFunction = globalFilter != null && globalFilter.getConstraint() instanceof FunctionFilterConstraint;
        table.setValue(null);
        AtomicBoolean localMatch = new AtomicBoolean();
        AtomicBoolean globalMatch = new AtomicBoolean();
        for (int i = 0; i < table.getRowCount(); ++i) {
            table.setRowIndex(i);
            Object rowData = table.getRowData();
            localMatch.set(true);
            globalMatch.set(false);
            if (hasGlobalFilterFunction) {
                globalMatch.set(globalFilter.getConstraint().isMatching(context, rowData, globalFilter.getFilterValue(), filterLocale));
            }
            int rowIndex = i;
            table.forEachColumn(column -> {
                Object filterValue;
                FilterConstraint constraint;
                FilterMeta filter = (FilterMeta)filterBy.get(column.getColumnKey((UIComponent)table, rowIndex));
                if (filter == null || filter.isGlobalFilter()) {
                    return true;
                }
                Object columnValue = filter.getLocalValue(elContext, (UIColumn)column);
                if (globalFilter != null && globalFilter.isActive() && !globalMatch.get() && !hasGlobalFilterFunction) {
                    constraint = globalFilter.getConstraint();
                    filterValue = globalFilter.getFilterValue();
                    globalMatch.set(constraint.isMatching(context, columnValue, filterValue, filterLocale));
                }
                if (!filter.isActive()) {
                    return true;
                }
                constraint = filter.getConstraint();
                filterValue = filter.getFilterValue();
                localMatch.set(constraint.isMatching(context, columnValue, filterValue, filterLocale));
                return localMatch.get();
            });
            boolean matches = localMatch.get();
            if (globalFilter != null && globalFilter.isActive()) {
                boolean bl = matches = matches && globalMatch.get();
            }
            if (!matches) continue;
            filtered.add(rowData);
        }
        if (table.isPaginator() || table.isVirtualScroll()) {
            PrimeFaces.current().ajax().addCallbackParam("totalRecords", filtered.size());
        }
        table.updateFilteredValue(context, filtered);
        table.setValue(filtered);
        table.setRowIndex(-1);
    }
}

