/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.el.MethodExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.api.UITable;
import org.primefaces.component.export.Exporter;
import org.primefaces.model.ColumnMeta;
import org.primefaces.util.LangUtils;

public abstract class TableExporter<T extends UIComponent>
extends Exporter<T> {
    private Map<UITable, List<UIColumn>> exportableColumns = new HashMap<UITable, List<UIColumn>>();

    protected void exportColumn(FacesContext context, T table, UIColumn column, List<UIComponent> components, boolean joinComponents, Consumer<String> callback) {
        if (LangUtils.isNotBlank(column.getExportValue())) {
            callback.accept(column.getExportValue());
        } else if (column.getExportFunction() != null) {
            MethodExpression exportFunction = column.getExportFunction();
            callback.accept((String)exportFunction.invoke(context.getELContext(), new Object[]{column}));
        } else if (LangUtils.isNotBlank(column.getField())) {
            String value = ((UITable)table).getConvertedFieldValue(context, column);
            callback.accept(Objects.toString(value, ""));
        } else {
            StringBuilder sb = null;
            for (UIComponent component : components) {
                if (!component.isRendered()) continue;
                String value = this.exportValue(context, component);
                if (joinComponents) {
                    if (value == null) continue;
                    if (sb == null) {
                        sb = new StringBuilder();
                    }
                    sb.append(value);
                    continue;
                }
                callback.accept(value);
            }
            if (joinComponents) {
                callback.accept(sb == null ? null : sb.toString());
            }
        }
    }

    protected List<UIColumn> getExportableColumns(UITable table) {
        if (this.exportableColumns.containsKey(table)) {
            return this.exportableColumns.get(table);
        }
        List<UIColumn> allColumns = table.getColumns();
        ArrayList<UIColumn> exportcolumns = new ArrayList<UIColumn>(allColumns.size());
        Map<String, ColumnMeta> columnMetadata = table.getColumnMeta();
        if (columnMetadata == null || columnMetadata.isEmpty()) {
            for (UIColumn col : allColumns) {
                if (col instanceof DynamicColumn) {
                    ((DynamicColumn)col).applyStatelessModel();
                }
                if (!col.isRendered() || !col.isExportable()) continue;
                exportcolumns.add(col);
            }
        } else {
            Comparator sortIntegersNaturallyWithNullsLast = Comparator.nullsLast(Comparator.naturalOrder());
            List columnMetas = columnMetadata.values().stream().sorted(Comparator.comparing(ColumnMeta::getDisplayPriority, sortIntegersNaturallyWithNullsLast)).collect(Collectors.toList());
            block1: for (ColumnMeta meta : columnMetas) {
                String columnKey = meta.getColumnKey();
                for (UIColumn col : allColumns) {
                    if (col instanceof DynamicColumn) {
                        ((DynamicColumn)col).applyStatelessModel();
                    }
                    if (!col.getColumnKey().equals(columnKey)) continue;
                    if (!col.isRendered() || !col.isExportable()) continue block1;
                    exportcolumns.add(col);
                    continue block1;
                }
            }
        }
        this.exportableColumns.put(table, exportcolumns);
        return exportcolumns;
    }
}

