/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.treetable.export;

import java.awt.Color;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.primefaces.component.export.ExporterOptions;
import org.primefaces.component.treetable.export.TreeTableExcelExporter;

public class TreeTableExcelXExporter
extends TreeTableExcelExporter {
    @Override
    protected Workbook createWorkBook() {
        return new XSSFWorkbook();
    }

    @Override
    protected RichTextString createRichTextString(String value) {
        return new XSSFRichTextString(value);
    }

    @Override
    public String getContentType() {
        return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
    }

    @Override
    public String getFileExtension() {
        return ".xlsx";
    }

    @Override
    protected void applyFacetOptions(Workbook wb, ExporterOptions options, CellStyle facetStyle) {
        Font facetFont = this.getFont(wb, options);
        if (options != null) {
            String facetFontSize;
            String facetFontColor;
            String facetBackground;
            String facetFontStyle = options.getFacetFontStyle();
            if (facetFontStyle != null) {
                if ("BOLD".equalsIgnoreCase(facetFontStyle)) {
                    facetFont.setBold(true);
                }
                if ("ITALIC".equalsIgnoreCase(facetFontStyle)) {
                    facetFont.setItalic(true);
                }
            }
            if ((facetBackground = options.getFacetBgColor()) != null) {
                XSSFColor backgroundColor = new XSSFColor(Color.decode(facetBackground), (IndexedColorMap)new DefaultIndexedColorMap());
                ((XSSFCellStyle)facetStyle).setFillForegroundColor(backgroundColor);
                facetStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
            if ((facetFontColor = options.getFacetFontColor()) != null) {
                XSSFColor facetColor = new XSSFColor(Color.decode(facetFontColor), (IndexedColorMap)new DefaultIndexedColorMap());
                ((XSSFFont)facetFont).setColor(facetColor);
            }
            if ((facetFontSize = options.getFacetFontSize()) != null) {
                facetFont.setFontHeightInPoints(Short.valueOf(facetFontSize).shortValue());
            }
        }
        facetStyle.setFont(facetFont);
    }

    @Override
    protected void applyCellOptions(Workbook wb, ExporterOptions options, CellStyle cellStyle) {
        Font cellFont = this.getFont(wb, options);
        if (options != null) {
            String cellFontStyle;
            String cellFontSize;
            String cellFontColor = options.getCellFontColor();
            if (cellFontColor != null) {
                XSSFColor cellColor = new XSSFColor(Color.decode(cellFontColor), (IndexedColorMap)new DefaultIndexedColorMap());
                ((XSSFFont)cellFont).setColor(cellColor);
            }
            if ((cellFontSize = options.getCellFontSize()) != null) {
                cellFont.setFontHeightInPoints(Short.valueOf(cellFontSize).shortValue());
            }
            if ((cellFontStyle = options.getCellFontStyle()) != null) {
                if ("BOLD".equalsIgnoreCase(cellFontStyle)) {
                    cellFont.setBold(true);
                }
                if ("ITALIC".equalsIgnoreCase(cellFontStyle)) {
                    cellFont.setItalic(true);
                }
            }
        }
        cellStyle.setFont(cellFont);
    }
}

