/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.treetable.feature;

import java.io.IOException;
import java.text.Collator;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.primefaces.PrimeFaces;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.component.treetable.TreeTableRenderer;
import org.primefaces.component.treetable.TreeTableState;
import org.primefaces.component.treetable.feature.TreeTableFeature;
import org.primefaces.event.data.PostSortEvent;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;
import org.primefaces.model.TreeNode;
import org.primefaces.model.TreeNodeList;

public class SortFeature
implements TreeTableFeature {
    private static final SortFeature INSTANCE = new SortFeature();

    private SortFeature() {
    }

    public static SortFeature getInstance() {
        return INSTANCE;
    }

    private boolean isSortRequest(FacesContext context, TreeTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_sorting");
    }

    @Override
    public boolean shouldDecode(FacesContext context, TreeTable table) {
        return this.isSortRequest(context, table);
    }

    @Override
    public boolean shouldEncode(FacesContext context, TreeTable table) {
        return this.isSortRequest(context, table);
    }

    @Override
    public void decode(FacesContext context, TreeTable table) {
        String[] sortOrders;
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = table.getClientId(context);
        String sortKey = (String)params.get(clientId + "_sortKey");
        String sortDir = (String)params.get(clientId + "_sortDir");
        String[] sortKeys = sortKey.split(",");
        if (sortKeys.length != (sortOrders = sortDir.split(",")).length) {
            throw new FacesException("sortKeys != sortDirs");
        }
        Map<String, SortMeta> sortByMap = table.getSortByAsMap();
        Map<String, Integer> sortKeysIndexes = IntStream.range(0, sortKeys.length).boxed().collect(Collectors.toMap(i -> sortKeys[i], i -> i));
        for (Map.Entry<String, SortMeta> entry : sortByMap.entrySet()) {
            SortMeta sortMeta = entry.getValue();
            if (sortMeta.isHeaderRow()) continue;
            Integer index = sortKeysIndexes.get(entry.getKey());
            if (index != null) {
                sortMeta.setOrder(SortOrder.of(sortOrders[index]));
                sortMeta.setPriority(index);
                continue;
            }
            sortMeta.setOrder(SortOrder.UNSORTED);
            sortMeta.setPriority(SortMeta.MIN_PRIORITY);
        }
    }

    @Override
    public void encode(FacesContext context, TreeTableRenderer renderer, TreeTable table) throws IOException {
        this.sort(context, table);
        context.getApplication().publishEvent(context, PostSortEvent.class, (Object)table);
        renderer.encodeTbody(context, table, table.getValue(), true);
        String selectedRowKeys = table.getSelectedRowKeysAsString();
        if (selectedRowKeys != null) {
            PrimeFaces.current().ajax().addCallbackParam("selection", selectedRowKeys);
        }
        if (table.isPaginator()) {
            PrimeFaces.current().ajax().addCallbackParam("totalRecords", table.getRowCount());
        }
        if (table.isMultiViewState()) {
            Map<String, SortMeta> sortMeta = table.getSortByAsMap();
            TreeTableState ts = table.getMultiViewState(true);
            ts.setSortBy(sortMeta);
            if (table.isPaginator()) {
                ts.setFirst(table.getFirst());
                ts.setRows(table.getRows());
            }
        }
    }

    public void sort(FacesContext context, TreeTable table) {
        TreeNode root = table.getValue();
        if (root == null) {
            return;
        }
        Map sortBy = table.getActiveSortMeta();
        if (sortBy.isEmpty()) {
            return;
        }
        AtomicInteger comparisonResult = new AtomicInteger();
        String var = table.getVar();
        Locale locale = table.resolveDataLocale();
        Collator collator = Collator.getInstance(locale);
        Object varBackup = context.getExternalContext().getRequestMap().get(var);
        this.sortNode(table, sortBy, comparisonResult, root, context, var, locale, collator);
        if (varBackup == null) {
            context.getExternalContext().getRequestMap().remove(var);
        } else {
            context.getExternalContext().getRequestMap().put(var, varBackup);
        }
    }

    protected void sortNode(TreeTable table, Map<String, SortMeta> sortBy, AtomicInteger comparisonResult, TreeNode<?> node, FacesContext context, String var, Locale locale, Collator collator) {
        TreeNodeList children = (TreeNodeList)node.getChildren();
        if (children != null && !children.isEmpty()) {
            int i;
            Object[] childrenArray = children.toArray();
            Arrays.sort(childrenArray, (o1, o2) -> {
                for (SortMeta sortMeta : sortBy.values()) {
                    comparisonResult.set(0);
                    table.invokeOnColumn(sortMeta.getColumnKey(), column -> {
                        if (column instanceof DynamicColumn) {
                            ((DynamicColumn)column).applyStatelessModel();
                        }
                        int result = table.compare(context, var, sortMeta, ((TreeNode)o1).getData(), ((TreeNode)o2).getData(), collator, locale);
                        comparisonResult.set(result);
                    });
                    if (comparisonResult.get() == 0) continue;
                    return comparisonResult.get();
                }
                return 0;
            });
            for (i = 0; i < childrenArray.length; ++i) {
                children.setSibling(i, (TreeNode)childrenArray[i]);
            }
            for (i = 0; i < children.size(); ++i) {
                this.sortNode(table, sortBy, comparisonResult, (TreeNode)children.get(i), context, var, locale, collator);
            }
        }
    }
}

