/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public class CurrencyValidator
implements Serializable {
    private static final long serialVersionUID = -4201640771171486514L;
    private static final CurrencyValidator VALIDATOR = new CurrencyValidator();
    private static final char CURRENCY_SYMBOL = '\u00a4';
    private static final String CURRENCY_SYMBOL_STR = Character.toString('\u00a4');
    private static final char NON_BREAKING_SPACE = '\u00a0';
    private static final String NON_BREAKING_SPACE_STR = Character.toString('\u00a0');

    public static CurrencyValidator getInstance() {
        return VALIDATOR;
    }

    public BigDecimal validate(String value, Locale locale) {
        return (BigDecimal)this.parse(value, locale);
    }

    protected Object parse(String value, DecimalFormat formatter) {
        Object parsedValue;
        if (value.indexOf(164) >= 0) {
            value = value.replace(CURRENCY_SYMBOL_STR, formatter.getDecimalFormatSymbols().getCurrencySymbol());
        }
        if (formatter.getPositivePrefix().indexOf(160) >= 0) {
            value = value.replaceAll(" ", NON_BREAKING_SPACE_STR);
        }
        if ((parsedValue = this.parseFormat(value, formatter)) != null || !(formatter instanceof DecimalFormat)) {
            return parsedValue;
        }
        String pattern = formatter.toPattern();
        if (pattern.indexOf(164) >= 0) {
            StringBuilder buffer = new StringBuilder(pattern.length());
            for (int i = 0; i < pattern.length(); ++i) {
                if (pattern.charAt(i) == '\u00a4') continue;
                buffer.append(pattern.charAt(i));
            }
            formatter.applyPattern(buffer.toString());
            parsedValue = this.parseFormat(value, formatter);
        }
        return parsedValue;
    }

    protected Object parseFormat(String value, DecimalFormat formatter) {
        ParsePosition pos = new ParsePosition(0);
        Number parsedValue = formatter.parse(value, pos);
        if (pos.getErrorIndex() > -1) {
            return null;
        }
        if (pos.getIndex() < value.length()) {
            return null;
        }
        if (parsedValue != null) {
            if (Double.isInfinite(parsedValue.doubleValue())) {
                return null;
            }
            parsedValue = this.processParsedValue(parsedValue, formatter);
        }
        return parsedValue;
    }

    protected BigDecimal processParsedValue(Number value, DecimalFormat formatter) {
        BigDecimal decimal = null;
        decimal = value instanceof Long ? BigDecimal.valueOf((Long)value) : new BigDecimal(value.toString());
        int scale = this.determineScale(formatter);
        if (scale >= 0) {
            decimal = decimal.setScale(scale, RoundingMode.DOWN);
        }
        return decimal;
    }

    protected int determineScale(NumberFormat format) {
        int maximumFraction;
        int minimumFraction = format.getMinimumFractionDigits();
        if (minimumFraction != (maximumFraction = format.getMaximumFractionDigits())) {
            return -1;
        }
        int scale = minimumFraction;
        if (format instanceof DecimalFormat) {
            int multiplier = ((DecimalFormat)format).getMultiplier();
            if (multiplier == 100) {
                scale += 2;
            } else if (multiplier == 1000) {
                scale += 3;
            }
        }
        return scale;
    }

    public DecimalFormat getFormat(Locale locale) {
        return (DecimalFormat)DecimalFormat.getCurrencyInstance(locale);
    }

    public String getPattern(Locale locale) {
        DecimalFormat format = this.getFormat(locale);
        String pattern = format.toLocalizedPattern();
        pattern = pattern.replace(CURRENCY_SYMBOL_STR, format.getDecimalFormatSymbols().getCurrencySymbol());
        String[] patterns = pattern.split(";");
        return patterns[0];
    }

    protected Object parse(String value, Locale locale) {
        String string = value = value == null ? null : value.trim();
        if (value == null || value.isEmpty()) {
            return null;
        }
        DecimalFormat formatter = this.getFormat(locale);
        return this.parse(value, formatter);
    }
}

