// ================================================================================
// NOTE: All the documentation and TypeScript declarations are in 0-galleria.d.ts
// ================================================================================

/**
 * Prime Item Widget For Galleria
 */
 (function (factory) {
    if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
        define(['jquery'], factory);
    } else if (typeof module === 'object' && module.exports) {
        // Node/CommonJS
        module.exports = function (root, jQuery) {
            factory(jQuery);
            return jQuery;
        };
    } else {
        // Browser globals
        factory(jQuery);
    }
}(function ($) {

    $.widget("prime.galleriaItem", {

        options: {
            id: null,
            circular: false,
            isVertical: false,
            showCaption: false,
            showIndicators: false,
            showItemNavigators: false,
            changeItemOnIndicatorHover: false,
            autoPlay: false,
            slideShowActive: false,
            activeIndex: 0,
            onActiveIndexChange: null,
            stopSlideShow: null
        },

        _create: function () {
            this.container = this.element;
            this.captionContainer = this.container.nextAll('.ui-galleria-caption-items');
            this.indicatorContainer = this.container.nextAll('.ui-galleria-indicators');
            this.indicators = this.indicatorContainer.children('.ui-galleria-indicator');
            this.items = this.container.children('.ui-galleria-item');

            this._setInitValues();
            this._render();

            this.wrapper = this.container.closest('.ui-galleria-item-wrapper');
            this.containerInWrapper = this.wrapper.children('.ui-galleria-item-container');
            this.navBackwardBtn = this.containerInWrapper.children('.ui-galleria-item-prev');
            this.navForwardBtn = this.containerInWrapper.children('.ui-galleria-item-next');
            
            if (this.indicatorContainer.length === 0) {
                this.indicators = this.wrapper.find('> .ui-galleria-indicators > .ui-galleria-indicator');
            }

            this._bindEvents();
            this.mounted();
        },

        _setInitValues: function () {
            this.prevOptions = this.options;
        },

        next: function () {
            var nextItemIndex = this.options.activeIndex + 1;
    
            this.options.onActiveIndexChange({
                index: this.options.circular && (this.items.length - 1) === this.options.activeIndex ? 0 : nextItemIndex
            });
        },
    
        prev: function () {
            var prevItemIndex = this.options.activeIndex !== 0 ? this.options.activeIndex - 1 : 0;
    
            this.options.onActiveIndexChange({
                index: this.options.circular && this.options.activeIndex === 0 ? this.items.length - 1 : prevItemIndex
            });
        },
    
        stopSlideShow: function () {
            if (this.options.slideShowActive && this.options.stopSlideShow) {
                this.options.stopSlideShow();
            }
        },
    
        navBackward: function (e) {
            this.stopSlideShow();
            this.prev();
    
            e.preventDefault();
        },
    
        navForward: function (e) {
            this.stopSlideShow();
            this.next();
    
            e.preventDefault();
        },
    
        onIndicatorClick: function (e) {
            var index = $(e.currentTarget).index();

            this.stopSlideShow();
            this.options.onActiveIndexChange({
                index: index
            });
        },
    
        onIndicatorMouseEnter: function (e) {
            if (this.options.changeItemOnIndicatorHover) {
                var index = $(e.currentTarget).index();

                this.stopSlideShow();
                this.options.onActiveIndexChange({
                    index: index
                });
            }
        },
    
        onIndicatorKeyDown: function (e) {
            if (event.which === 13) {
                var index = $(e.currentTarget).index();

                this.stopSlideShow();
                this.options.onActiveIndexChange({
                    index: index
                });
            }
        },

        mounted: function () {
            this._updateUI();
        },

        updated: function (prevOptions) {
            if (prevOptions.activeIndex !== this.options.activeIndex) {
                this._updateUI();
            }
        },

        _setOption: function (key, value) {
            this._super(key, value);
            this.updated(this.prevOptions);
        },

        _setOptions: function (options) {
            var $this = this;
            this.prevOptions = Object.assign({}, this.options);
            
            $.each(options, function (key, value) {
                $this._setOption(key, value);
            });

            this.prevOptions = options;
        },

        _updateUI: function () {
            var transform = this.options.isVertical ? 'translate3d(0, ' + (this.options.activeIndex * -100) + '%, 0)' : 'translate3d(' + (this.options.activeIndex * -100) + '%, 0, 0)';
            var transition = 'transform 500ms ease 0s';
            this.container.css({ 'transform': transform, 'transition': transition });
            this.captionContainer.css({ 'transform': transform, 'transition': transition });

            if (this.options.showItemNavigators) {
                var isNavBackwardBtnDisabled = !this.options.circular && this.options.activeIndex === 0;
                var isNavForwardBtnDisabled = !this.options.circular && this.options.activeIndex === (this.items.length - 1);
                var toggleDisabled = function (el, disabled) {
                    if (disabled)
                        el.attr('disabled', 'disabled').addClass('ui-state-disabled');
                    else
                        el.removeAttr('disabled').removeClass('ui-state-disabled');
                };

                toggleDisabled(this.navBackwardBtn, isNavBackwardBtnDisabled);
                toggleDisabled(this.navForwardBtn, isNavForwardBtnDisabled);
            }

            if (this.options.showIndicators) {
                this.indicators.removeClass('ui-state-highlight');

                for (var index = 0; index < this.indicators.length; index++) {
                    if (this.options.activeIndex === index) {
                        this.indicators.eq(index).addClass('ui-state-highlight');

                        break;
                    }
                }
            }
        },

        _bindEvents: function () {
            var $this = this;

            if (this.options.showItemNavigators) {
                this.navBackwardBtn.off('click.galleria-item-nav').on('click.galleria-item-nav', this.navBackward.bind($this));
                this.navForwardBtn.off('click.galleria-item-nav').on('click.galleria-item-nav', this.navForward.bind($this));
            }

            this.indicators.off('click.galleria-indicator mouseenter.galleria-indicator keydown.galleria-indicator')
                .on('click.galleria-indicator', this.onIndicatorClick.bind($this))
                .on('mouseenter.galleria-indicator', this.onIndicatorMouseEnter.bind($this))
                .on('keydown.galleria-indicator', this.onIndicatorKeyDown.bind($this));
        },

        _renderBackwardNavigator: function () {
            if (this.options.showItemNavigators) {
                return (
                    '<button type="button" class="ui-galleria-item-prev ui-galleria-item-nav ui-corner-all ui-galleria-link">' +
                        '<span class="ui-galleria-item-prev-icon ui-icon ui-icon-circle-triangle-w"></span>' +
                    '</button>'
                );
            }

            return '';
        },

        _renderForwardNavigator: function () {
            if (this.options.showItemNavigators) {
                return (
                    '<button type="button" class="ui-galleria-item-next ui-galleria-item-nav ui-corner-all ui-galleria-link">' +
                        '<span class="ui-galleria-item-next-icon ui-icon ui-icon-circle-triangle-e"></span>' +
                    '</button>'
                );
            }

            return '';
        },

        _renderCaption: function () {
            if (!this.options.showCaption) {
                this.captionContainer.hide();
            }

            return this.captionContainer;
        },

        _renderIndicator: function () {
            return (
                '<li class="ui-galleria-indicator" tabindex="0">' +
                    '<button type="button" tabindex="-1" class="ui-galleria-link"></button>' +
                '</li>'
            );
        },

        _renderIndicators: function () {
            if (this.options.showIndicators) {
                var indicators = '';

                for (var i = 0; i < this.items.length; i++) {
                    indicators += this._renderIndicator();
                }

                return (
                    '<ul class="ui-galleria-indicators">' +
                        indicators +
                    '</ul>'
                );
            }

            return '';
        },

        _render: function () {
            var backwardNavigator = this._renderBackwardNavigator();
            var forwardNavigator = this._renderForwardNavigator();
            var caption = this._renderCaption();
            var indicators = this.indicatorContainer.length ? this.indicatorContainer : this._renderIndicators();

            this.container.wrap(
                '<div class="ui-galleria-item-wrapper">' +
                    '<div class="ui-galleria-item-container">' +
                    '</div>' +
                '</div>'
            );

            this.container.before(backwardNavigator);
            this.container.after(forwardNavigator, caption);
            this.container.parent().after(indicators);
        }
    });

}));


// ================================================================================
// NOTE: All the documentation and TypeScript declarations are in 0-galleria.d.ts
// ================================================================================

/**
 * Prime Thumbnail Widget For Galleria
 */
 (function (factory) {
    if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
        define(['jquery'], factory);
    } else if (typeof module === 'object' && module.exports) {
        // Node/CommonJS
        module.exports = function (root, jQuery) {
            factory(jQuery);
            return jQuery;
        };
    } else {
        // Browser globals
        factory(jQuery);
    }
}(function ($) {

    $.widget("prime.galleriaThumbnail", {

        options: {
            id: null,
            selector: null,
            showThumbnails: true,
            numVisible: 3,
            responsiveOptions: null,
            circular: false,
            isVertical: false,
            showThumbnailNavigators: true,
            slideShowActive: false,
            activeIndex: 0,
            onActiveIndexChange: null,
            stopSlideShow: null
        },

        _create: function () {
            this.container = this.element;

            if (this.options.showThumbnails) {
                this.thumbnailItems = this.container.children('.ui-galleria-thumbnail-item');

                this._setInitValues();
                this._render();

                this.wrapper = this.container.closest('.ui-galleria-thumbnail-wrapper');
                this.containerInWrapper = this.wrapper.children('.ui-galleria-thumbnail-container');
                this.navBackwardBtn = this.containerInWrapper.children('.ui-galleria-thumbnail-prev');
                this.navForwardBtn = this.containerInWrapper.children('.ui-galleria-thumbnail-next');

                this._bindEvents();
                this.mounted();
            }
            else {
                this.container.hide();
            }
        },

        _setInitValues: function () {
            this.state = {
                numVisible: this.options.numVisible,
                totalShiftedItems: 0
            };

            this.prevState = Object.assign({}, this.state);
            this.prevOptions = this.options;
        },
        
        setState: function (newState, callback) {
            var $this = this;
            var isUpdated = false;
            
            Object.keys(newState).forEach(function (key) {
                if ($this.state[key] !== newState[key]) {
                    $this.prevState[key] = $this.state[key];
                    $this.state[key] = newState[key];
                    
                    isUpdated = true;
                }
            });

            if (isUpdated) {
                this.updated(this.options, this.prevState);
                callback && callback();
            }
        },

        step: function (dir) {
            var totalShiftedItems = this.state.totalShiftedItems + dir;
    
            if (dir < 0 && (-1 * totalShiftedItems) + this.state.numVisible > (this.thumbnailItems.length - 1)) {
                totalShiftedItems = this.state.numVisible - this.thumbnailItems.length;
            }
            else if (dir > 0 && totalShiftedItems > 0) {
                totalShiftedItems = 0;
            }
    
            if (this.options.circular) {
                if (dir < 0 && this.thumbnailItems.length - 1 === this.options.activeIndex) {
                    totalShiftedItems = 0;
                }
                else if (dir > 0 && this.options.activeIndex === 0) {
                    totalShiftedItems = this.state.numVisible - this.thumbnailItems.length;
                }
            }
    
            if (this.container) {
                var transform = this.options.isVertical ? 'translate3d(0,' + (totalShiftedItems * (100/ this.state.numVisible)) + '%, 0)' : 'translate3d(' + (totalShiftedItems * (100/ this.state.numVisible)) + '%, 0, 0)';
                var transition = 'transform 500ms ease 0s';

                this.container.removeClass('ui-items-hidden').css({ 'transform': transform, 'transition': transition });
            }

            this.setState({
                totalShiftedItems: totalShiftedItems
            });
        },
    
        stopSlideShow: function () {
            if (this.options.slideShowActive && this.options.stopSlideShow) {
                this.options.stopSlideShow();
            }
        },
    
        getMedianIndex: function () {
            var index = Math.floor(this.state.numVisible / 2);
    
            return (this.state.numVisible % 2) ? index : index - 1;
        },
    
        navBackward: function (e) {
            this.stopSlideShow();
    
            var prevItemIndex = this.options.activeIndex !== 0 ? this.options.activeIndex - 1 : 0;
            var diff = prevItemIndex + this.state.totalShiftedItems;
            if ((this.state.numVisible - diff - 1) > this.getMedianIndex() && ((-1 * this.state.totalShiftedItems) !== 0 || this.options.circular)) {
                this.step(1);
            }
    
            this.options.onActiveIndexChange({
                index: this.options.circular && this.options.activeIndex === 0 ? this.thumbnailItems.length - 1 : prevItemIndex
            });
    
            e.preventDefault();
        },
    
        navForward: function (e) {
            this.stopSlideShow();
    
            var nextItemIndex = this.options.activeIndex + 1;
            if (nextItemIndex + this.state.totalShiftedItems > this.getMedianIndex() && ((-1 * this.state.totalShiftedItems) < this.getTotalPageNumber() - 1 || this.options.circular)) {
                this.step(-1);
            }
    
            this.options.onActiveIndexChange({
                index: this.options.circular && (this.thumbnailItems.length - 1) === this.options.activeIndex ? 0 : nextItemIndex
            });
    
            e.preventDefault();
        },
    
        onItemClick: function (event) {
            this.stopSlideShow();
    
            var selectedItemIndex = $(event.currentTarget).index();
            if (selectedItemIndex !== this.options.activeIndex) {
                var diff = selectedItemIndex + this.state.totalShiftedItems;
                var dir = 0;
                if (selectedItemIndex < this.options.activeIndex) {
                    dir = (this.state.numVisible - diff - 1) - this.getMedianIndex();
                    if (dir > 0 && (-1 * this.state.totalShiftedItems) !== 0) {
                        this.step(dir);
                    }
                }
                else {
                    dir = this.getMedianIndex() - diff;
                    if (dir < 0 && (-1 * this.state.totalShiftedItems) < this.getTotalPageNumber() - 1) {
                        this.step(dir);
                    }
                }
    
                this.options.onActiveIndexChange({
                    index: selectedItemIndex
                });
            }
        },
    
        onTransitionEnd: function (e) {
            if (this.container && e.originalEvent && e.originalEvent.propertyName === 'transform') {
                this.container.addClass('ui-items-hidden').css('transition', '');
            }
        },
    
        onTouchStart: function (e) {
            var touchobj = e.changedTouches[0];
    
            this.startPos = {
                x: touchobj.pageX,
                y: touchobj.pageY
            };
        },
    
        onTouchMove: function (e) {
            e.preventDefault();
        },
    
        onTouchEnd: function (e) {
            var touchobj = e.changedTouches[0];
    
            if (this.options.isVertical) {
                this.changePageOnTouch(e, (touchobj.pageY - this.startPos.y));
            }
            else {
                this.changePageOnTouch(e, (touchobj.pageX - this.startPos.x));
            }
        },
    
        changePageOnTouch: function (e, diff) {
            if (diff < 0) {           // left
                this.navForward(e);
            }
            else {                    // right
                this.navBackward(e);
            }
        },
    
        getTotalPageNumber: function () {
            return this.thumbnailItems.length > this.state.numVisible ? (this.thumbnailItems.length - this.state.numVisible) + 1 : 0;
        },
    
        createStyle: function () {
            if (!this.thumbnailsStyle) {
                this.thumbnailsStyle = document.createElement('style');
                document.body.appendChild(this.thumbnailsStyle);
            }
    
            var galleriaSelector = this.options.selector ? this.options.selector : '#' + this.options.id;
            var innerHTML =  galleriaSelector + ' .ui-galleria-thumbnail-items .ui-galleria-thumbnail-item { flex: 1 0 ' + (100/ this.state.numVisible) + '%; }';
    
            if (this.options.responsiveOptions) {
                this.responsiveOptions = Array.from(this.options.responsiveOptions);
                this.responsiveOptions.sort(function (data1, data2) {
                    var value1 = data1.breakpoint;
                    var value2 = data2.breakpoint;
                    var result = null;
    
                    if (value1 == null && value2 != null)
                        result = -1;
                    else if (value1 != null && value2 == null)
                        result = 1;
                    else if (value1 == null && value2 == null)
                        result = 0;
                    else if (typeof value1 === 'string' && typeof value2 === 'string')
                        result = value1.localeCompare(value2, undefined, { numeric: true });
                    else
                        result = (value1 < value2) ? -1 : (value1 > value2) ? 1 : 0;
    
                    return -1 * result;
                });
    
                for (var i = 0; i < this.responsiveOptions.length; i++) {
                    var res = this.responsiveOptions[i];
    
                    innerHTML += '@media screen and (max-width:' + res.breakpoint + ') { ' + galleriaSelector + ' .ui-galleria-thumbnail-items .ui-galleria-thumbnail-item { flex: 1 0 ' + (100/ res.numVisible) + '%; }}';
                }
            }
    
            this.thumbnailsStyle.innerHTML = innerHTML;
        },
    
        calculatePosition: function () {
            if (this.container && this.responsiveOptions) {
                var windowWidth = window.innerWidth;
                var matchedResponsiveData = {
                    numVisible: this.options.numVisible
                };
    
                for (var i = 0; i < this.responsiveOptions.length; i++) {
                    var res = this.responsiveOptions[i];
    
                    if (parseInt(res.breakpoint, 10) >= windowWidth) {
                        matchedResponsiveData = res;
                    }
                }
    
                if (this.state.numVisible !== matchedResponsiveData.numVisible) {
                    this.setState({
                        numVisible: matchedResponsiveData.numVisible
                    });
                }
            }
        },
    
        bindDocumentListeners: function () {
            if (!this.documentResizeListener) {
                var $this = this;
                this.documentResizeListener = function () {
                    $this.calculatePosition();
                };
    
                window.addEventListener('resize', this.documentResizeListener);
            }
        },
    
        unbindDocumentListeners: function () {
            if(this.documentResizeListener) {
                window.removeEventListener('resize', this.documentResizeListener);
                this.documentResizeListener = null;
            }
        },
    
        mounted: function () {    
            this.createStyle();
            this.calculatePosition();
    
            if (this.options.responsiveOptions) {
                this.bindDocumentListeners();
            }

            this._updateUI();
        },
    
        updated: function (prevOptions, prevState) {
            var totalShiftedItems = this.state.totalShiftedItems;

            if (prevState.numVisible !== this.state.numVisible || prevOptions.activeIndex !== this.options.activeIndex) {
                if (this.options.activeIndex <= this.getMedianIndex()) {
                    totalShiftedItems = 0;
                }
                else if (this.thumbnailItems.length - this.state.numVisible + this.getMedianIndex() < this.options.activeIndex) {
                    totalShiftedItems = this.state.numVisible - this.thumbnailItems.length;
                }
                else if (this.thumbnailItems.length - this.state.numVisible < this.options.activeIndex && this.state.numVisible % 2 === 0) {
                    totalShiftedItems = (this.options.activeIndex * -1) + this.getMedianIndex() + 1;
                }
                else {
                    totalShiftedItems = (this.options.activeIndex * -1) + this.getMedianIndex();
                }
    
                if (totalShiftedItems !== this.state.totalShiftedItems) {
                    this.setState({
                        totalShiftedItems: totalShiftedItems
                    });
                }
    
                var transform = this.options.isVertical ? 'translate3d(0, ' + (totalShiftedItems * (100/ this.state.numVisible)) + '%, 0)' : 'translate3d(' + (totalShiftedItems * (100/ this.state.numVisible)) + '%, 0, 0)';
                this.container.css('transform', transform);
    
                if (prevOptions.activeIndex !== this.options.activeIndex) {
                    this.container.removeClass('ui-items-hidden').css('transition', 'transform 500ms ease 0s');
                }

                this._updateUI();
            }
        },

        _setOption: function (key, value) {
            this._super(key, value);
            this.updated(this.prevOptions, this.state);
        },

        _setOptions: function (options) {
            if (this.options.showThumbnails) {
                var $this = this;
                this.prevOptions = Object.assign({}, this.options);
                
                $.each(options, function (key, value) {
                    $this._setOption(key, value);
                });

                this.prevOptions = options;
            }
        },

        _updateUI: function () {
            var firstIndex = this.state.totalShiftedItems * -1;
            var lastIndex = firstIndex + this.state.numVisible - 1;

            this.thumbnailItems.removeClass('ui-galleria-thumbnail-item-current ui-galleria-thumbnail-item-active ui-galleria-thumbnail-item-start ui-galleria-thumbnail-item-end');
            
            for (var index = 0; index < this.thumbnailItems.length; index++) {
                var item = this.thumbnailItems.eq(index);
                var active = firstIndex <= index && lastIndex >= index;
                var start = firstIndex === index;
                var end = lastIndex === index;
                var current = this.options.activeIndex === index;

                var itemClass = PrimeFaces.utils.styleClass({
                    'ui-galleria-thumbnail-item-current': current,
                    'ui-galleria-thumbnail-item-active': active,
                    'ui-galleria-thumbnail-item-start': start,
                    'ui-galleria-thumbnail-item-end': end
                });

                item.addClass(itemClass).children('.ui-galleria-thumbnail-item-content').attr('tabindex', (active ? '0' : ''));
            }
            
            if (this.options.showThumbnailNavigators) {
                var isNavBackwardBtnDisabled = (!this.options.circular && this.options.activeIndex === 0) || (this.thumbnailItems.length <= this.state.numVisible);
                var isNavForwardBtnDisabled = (!this.options.circular && this.options.activeIndex === (this.thumbnailItems.length - 1)) || (this.thumbnailItems.length <= this.state.numVisible);
                var toggleDisabled = function (el, disabled) {
                    if (disabled)
                        el.attr('disabled', 'disabled').addClass('ui-state-disabled');
                    else
                        el.removeAttr('disabled').removeClass('ui-state-disabled');
                };

                toggleDisabled(this.navBackwardBtn, isNavBackwardBtnDisabled);
                toggleDisabled(this.navForwardBtn, isNavForwardBtnDisabled);
            }
        },
    
        _destroy: function() {
            if (this.options.responsiveOptions) {
                this.unbindDocumentListeners();
            }
        },

        _bindEvents: function() {
            var $this = this;

            if (this.options.showThumbnailNavigators) {
                this.navBackwardBtn.off('click.galleria-thumbnail-nav').on('click.galleria-thumbnail-nav', this.navBackward.bind($this));
                this.navForwardBtn.off('click.galleria-thumbnail-nav').on('click.galleria-thumbnail-nav', this.navForward.bind($this));
            }

            this.container.off('transitionend.galleria-thumbnail touchstart.galleria-thumbnail touchmove.galleria-thumbnail touchend.galleria-thumbnail')
                .on('transitionend.galleria-thumbnail', this.onTransitionEnd.bind($this))
                .on('touchstart.galleria-thumbnail', this.onTouchStart.bind($this))
                .on('touchmove.galleria-thumbnail', this.onTouchMove.bind($this))
                .on('touchend.galleria-thumbnail', this.onTouchEnd.bind($this));
            
            this.container.children().off('click.galleria-thumbnail-item keydown.galleria-thumbnail-item')
                .on('click.galleria-thumbnail-item', this.onItemClick.bind($this))
                .on('keydown.galleria-thumbnail-item', function (e) {
                    if (e.which === 13) {
                        $this.onItemClick(e);
                    }
                });
        },
    
        _renderBackwardNavigator: function () {
            if (this.options.showThumbnailNavigators) {
                var iconStyleClass = PrimeFaces.utils.styleClass('ui-galleria-thumbnail-prev-icon ui-icon', {
                    'ui-icon-circle-triangle-w': !this.options.isVertical,
                    'ui-icon-circle-triangle-n': this.options.isVertical
                });
    
                return (
                    '<button type="button" class="ui-galleria-thumbnail-prev ui-corner-all ui-galleria-link">' +
                        '<span class="' + iconStyleClass + '"></span>' +
                    '</button>'
                );
            }
    
            return '';
        },
    
        _renderForwardNavigator: function () {
            if (this.options.showThumbnailNavigators) {
                var iconStyleClass = PrimeFaces.utils.styleClass('ui-galleria-thumbnail-next-icon ui-icon', {
                    'ui-icon-circle-triangle-e': !this.options.isVertical,
                    'ui-icon-circle-triangle-s': this.options.isVertical
                });
    
                return (
                    '<button type="button" class="ui-galleria-thumbnail-next ui-corner-all ui-galleria-link">' +
                        '<span class="' + iconStyleClass + '"></span>' +
                    '</button>'
                );
            }
    
            return '';
        },

        _renderContent: function () {
            var backwardNavigator = this._renderBackwardNavigator();
            var forwardNavigator = this._renderForwardNavigator();

            this.container.wrap(
                '<div class="ui-galleria-thumbnail-container">' +
                    '<div class="ui-galleria-thumbnail-items-container">' +
                    '</div>' +
                '</div>'
            );

            this.container.parent().before(backwardNavigator).after(forwardNavigator);

            return this.container.closest('.ui-galleria-thumbnail-container');
        },

        _render: function () {
            var content = this._renderContent();

            content.wrap('<div class="ui-galleria-thumbnail-wrapper"></div>');
        }
    });

}));
// ================================================================================
// NOTE: All the documentation and TypeScript declarations are in 0-galleria.d.ts
// ================================================================================

/**
 * Prime Galleria Widget
 */
 (function (factory) {
    if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
        define(['jquery'], factory);
    } else if (typeof module === 'object' && module.exports) {
        // Node/CommonJS
        module.exports = function (root, jQuery) {
            factory(jQuery);
            return jQuery;
        };
    } else {
        // Browser globals
        factory(jQuery);
    }
}(function ($) {

    $.widget("prime.galleria", {

        options: {
            id: null,
            selector: null,
            value: null,
            style: null,
            styleClass: null,
            activeIndex: 0,
            fullScreen: false,
            closeIcon: 'pi pi-times',
            numVisible: 3,
            responsiveOptions: null,
            showThumbnails: true,
            showIndicators: false,
            showIndicatorsOnItem: false,
            showCaption: false,
            showItemNavigators: false,
            showThumbnailNavigators: true,
            showItemNavigatorsOnHover: false,
            changeItemOnIndicatorHover: false,
            circular: false,
            autoPlay: false,
            transitionInterval: 4000,
            thumbnailsPosition: "bottom",
            verticalViewPortHeight: "450px",
            indicatorsPosition: "bottom",
            onItemChange: null,
            onShow: null,
            onHide: null
        },

        _create: function () {
            this.container = this.element;
            this.content = this.container.children('.ui-galleria-content');
            this.itemsContainer = this.content.children('.ui-galleria-items');
            this.captionContainer = this.content.children('.ui-galleria-caption-items');
            this.thumbnailContainer = this.content.children('.ui-galleria-thumbnail-items');
            this.items = this.itemsContainer.children('.ui-galleria-item');
            
            if (this.options.fullScreen) {
                this.container.css('display', 'none');
            }

            if (this.items.length > 0) {
                this._setInitValues();
                this._render();

                this.mask = this.container.parent('.ui-galleria-mask');
                this.itemWidget = this.itemsContainer.data('prime-galleriaItem');
                this.thumbnailWidget = this.thumbnailContainer.data('prime-galleriaThumbnail');
                
                this.transition = PrimeFaces.utils.registerCSSTransition(this.container, 'ui-galleria');

                this._bindEvents();
                this.mounted();
            }
        },

        _setInitValues: function () {
            this.state = {
                visible: false,
                slideShowActive: false,
                activeIndex: this.options.activeIndex
            };

            this.prevState = Object.assign({}, this.state);
            this.prevOptions = this.options;
        },

        setState: function (newState, callback) {
            var $this = this;
            var isUpdated = false;
            
            Object.keys(newState).forEach(function (key) {
                if ($this.state[key] !== newState[key]) {
                    $this.prevState[key] = $this.state[key];
                    $this.state[key] = newState[key];
                    
                    isUpdated = true;
                }
            });

            if (isUpdated) {
                this.updated();
                callback && callback();
            }
        },

        onActiveIndexChange: function (event) {
            var $this = this;
            
            this.setState({
                activeIndex: event.index
            }, function() {
                if ($this.options.onItemChange) {
                    $this.options.onItemChange(event);
                }
            });
        },
    
        show: function () {
            var $this = this;
            
            this.setState({ visible: true }, function () {
                if ($this.transition) {
                    $this.transition.show({
                        onEnter: function () {
                            $(document.body).addClass('ui-overflow-hidden');
                        },
                        onEntering: function () {
                            $this.mask.addClass('ui-widget-overlay').css('z-index', PrimeFaces.nextZindex());
                        },
                        onEntered: function () {
                            if ($this.options.onShow) {
                                $this.options.onShow();
                            }
                        }
                    });
                }
            });
        },
    
        hide: function () {
            var $this = this;
            
            this.setState({ visible: false }, function () {
                if ($this.transition) {
                    $this.transition.hide({
                        onExit: function () {
                            $(document.body).removeClass('ui-overflow-hidden');
                            $this.mask.addClass('ui-galleria-mask-leave');
                        },
                        onExited: function () {
                            $this.mask.removeClass('ui-galleria-mask-leave ui-widget-overlay').css('z-index', '');
                            
                            if ($this.options.onHide) {
                                $this.options.onHide();
                            }
                        }
                    });
                }
            });
        },
        
        next: function () {
            var nextActiveIndex = (this.state.activeIndex === this.items.length - 1) ? 
                (this.options.circular ? 0 : this.state.activeIndex) : this.state.activeIndex + 1;
                
            this.setState({
                activeIndex: nextActiveIndex
            });
        },
        
        prev: function () {
            var prevActiveIndex = (this.state.activeIndex === 0) ? 
                (this.options.circular ? this.items.length - 1 : this.state.activeIndex) : this.state.activeIndex - 1;
                
            this.setState({
                activeIndex: prevActiveIndex
            });
        },
    
        isAutoPlayActive: function () {
            return this.state.slideShowActive;
        },
    
        startSlideShow: function () {
            var $this = this;
            this.interval = setInterval(function () {
                var activeIndex = ($this.options.circular && ($this.items.length - 1) === $this.state.activeIndex) ? 0 : ($this.state.activeIndex + 1);
                $this.onActiveIndexChange({ index: activeIndex });
            }, this.options.transitionInterval);
    
            this.setState({ slideShowActive: true });
        },
    
        stopSlideShow: function () {
            if (this.interval) {
                clearInterval(this.interval);
            }
    
            this.setState({ slideShowActive: false });
        },

        getPositionStyleClass: function (preClassName, position) {
            var positions = ['top', 'left', 'bottom', 'right'];
            var pos = positions.filter(function(item) { return item === position; })[0];
    
            return pos ? preClassName + '-' + pos : '';
        },

        isVertical: function() {
            return this.options.thumbnailsPosition === 'left' || this.options.thumbnailsPosition === 'right';
        },

        mounted: function () {
            if (this.isVertical()) {
                this.content.css('height', this.options.verticalViewPortHeight);
            }
            
            if (this.options.autoPlay) {
                this.startSlideShow();
            }
        },

        updated: function () {
            this.itemWidget.option(this.state);

            if (this.thumbnailWidget) {
                this.thumbnailWidget.option(this.state);
            }

            if (this.state.visible) 
                this.mask.addClass('ui-galleria-visible');
            else
                this.mask.removeClass('ui-galleria-visible');
        },

        _destroy: function () {
            $(document.body).removeClass('ui-overflow-hidden');
            
            if (this.state.slideShowActive) {
                this.stopSlideShow();
            }
        },

        _bindEvents: function () {
            var $this = this;

            this.container.children('.ui-galleria-close').off('click.galleria').on('click.galleria', this.hide.bind($this));
        },

        _renderCloseButton: function () {
            if (this.options.fullScreen) {
                return (
                    '<button type="button" class="ui-galleria-close ui-corner-all ui-galleria-link">' +
                        '<span class="ui-button-icon-left ui-galleria-close-icon ' + this.options.closeIcon + '"></span>' +
                    '</button>'
                );
            }
        },

        _renderItems: function() {
            this.itemsContainer.galleriaItem({ 
                circular: this.options.circular,
                isVertical: this.isVertical(),
                showCaption: this.options.showCaption,
                showIndicators: this.options.showIndicators,
                showItemNavigators: this.options.showItemNavigators,
                changeItemOnIndicatorHover: this.options.changeItemOnIndicatorHover,
                autoPlay: this.options.autoPlay,
                slideShowActive: this.state.slideShowActive,
                activeIndex: this.state.activeIndex,
                onActiveIndexChange: this.onActiveIndexChange.bind(this),
                stopSlideShow: this.stopSlideShow.bind(this)
            });
        },

        _renderThumbnails: function () {
            this.thumbnailContainer.galleriaThumbnail({
                id: this.options.id,
                selector: this.options.selector,
                showThumbnails: this.options.showThumbnails,
                numVisible: this.options.numVisible,
                responsiveOptions: this.options.responsiveOptions,
                circular: this.options.circular,
                isVertical: this.isVertical(),
                showThumbnailNavigators: this.options.showThumbnailNavigators,
                slideShowActive: this.state.slideShowActive,
                activeIndex: this.state.activeIndex,
                onActiveIndexChange: this.onActiveIndexChange.bind(this),
                stopSlideShow: this.stopSlideShow.bind(this)
            });
        },

        _renderElement: function() {
            var thumbnailsPosStyleClass = this.options.showThumbnails && this.getPositionStyleClass('ui-galleria-thumbnails', this.options.thumbnailsPosition);
            var indicatorPosStyleClass = this.options.showIndicators && this.getPositionStyleClass('ui-galleria-indicators', this.options.indicatorsPosition);
            var galleriaStyleClass = PrimeFaces.utils.styleClass(this.options.styleClass, {
                'ui-galleria-fullscreen': this.options.fullScreen,
                'ui-galleria-indicator-onitem': this.options.showIndicatorsOnItem,
                'ui-galleria-item-nav-onhover': this.options.showItemNavigatorsOnHover && !this.options.fullScreen
            }, thumbnailsPosStyleClass, indicatorPosStyleClass);

            this.container.addClass(galleriaStyleClass);
            if (this.options.style) this.container.attr('style', this.options.style);

            this.closeButton = this._renderCloseButton();

            this.container.prepend(this.closeButton);
            this._renderThumbnails();
            this._renderItems();

            return this.container;
        },

        _render: function () {
            var element = this._renderElement();

            if (this.options.fullScreen) {
                element.unwrap('.ui-galleria-mask').wrap('<div class="ui-galleria-mask"></div>');
            }
        }
    });

}));
/**
 * __PrimeFaces Galleria Widget__
 *
 * Galleria is a content gallery component.
 *
 * @prop {JQuery} primeGalleriaWidget The DOM element for the caption below the image.
 *
 * @interface {PrimeFaces.widget.GalleriaCfg} cfg The configuration for the {@link  Galleria| Galleria widget}.
 * You can access this configuration via {@link PrimeFaces.widget.BaseWidget.cfg|BaseWidget.cfg}. Please note that this
 * configuration is usually meant to be read-only and should not be modified.
 * @extends {PrimeFaces.widget.DeferredWidgetCfg} cfg
 *
 * @prop {number} cfg.activeIndex Index of the first item.
 * @prop {boolean} cfg.fullScreen Whether to display the component on fullscreen.
 * @prop {string} cfg.closeIcon Close icon on fullscreen mode.
 * @prop {number} cfg.numVisible Number of items per page.
 * @prop {boolean} cfg.showThumbnails Whether to display thumbnail container.
 * @prop {boolean} cfg.showIndicators Whether to display indicator container.
 * @prop {boolean} cfg.showIndicatorsOnItem When enabled, indicator container is displayed on item container.
 * @prop {boolean} cfg.showCaption Whether to display caption container.
 * @prop {boolean} cfg.showItemNavigators Whether to display navigation buttons in item container.
 * @prop {boolean} cfg.showThumbnailNavigators Whether to display navigation buttons in thumbnail container.
 * @prop {boolean} cfg.showItemNavigatorsOnHover Whether to display navigation buttons on item container's hover.
 * @prop {boolean} cfg.changeItemOnIndicatorHover When enabled, item is changed on indicator item's hover.
 * @prop {boolean} cfg.circular Defines if scrolling would be infinite.
 * @prop {boolean} cfg.autoPlay Items are displayed with a slideshow in autoPlay mode.
 * @prop {number} cfg.transitionInterval Time in milliseconds to scroll items.
 * @prop {string} cfg.thumbnailsPosition Position of thumbnails. Valid values are "bottom", "top", "left" and "right".
 * @prop {string} cfg.verticalViewPortHeight Height of the viewport in vertical layout.
 * @prop {string} cfg.indicatorsPosition Position of indicators. Valid values are "bottom", "top", "left" and "right".
 * @prop {{breakpoint:string, numVisible:number}[]} cfg.responsiveOptions A model of options for responsive design.
 */
PrimeFaces.widget.Galleria = PrimeFaces.widget.DeferredWidget.extend({

    /**
     * @override
     * @inheritdoc
     * @param {PrimeFaces.PartialWidgetCfg<TCfg>} cfg
     */
    init: function(cfg) {
        this._super(cfg);
        
        this.cfg.selector = this.jqId;

        this.renderDeferred();
    },

    /**
     * @include
     * @override
     * @protected
     * @inheritdoc
     */
    _render: function() {
        this.primeGalleriaWidget = this.jq.galleria(this.cfg).data('prime-galleria');
    },
    
    /**
     * @override
     * @inheritdoc
     * @param {PrimeFaces.PartialWidgetCfg<TCfg>} cfg
     */
    refresh: function(cfg) {
        if(this.primeGalleriaWidget) {
            this.primeGalleriaWidget.destroy();
        }

        this._super(cfg);
    },

    /**
     * @override
     * @inheritdoc
     */
    destroy: function() {
        this._super();

        if (this.primeGalleriaWidget) {
            this.primeGalleriaWidget.destroy();
        }
    },
    
    /**
     * Shows content on fullscreen mode.
     */
    show: function() {
        this.primeGalleriaWidget.show();
    },
    
    /**
     * Moves to the next content that comes after the currently shown content.
     */
    next: function() {
        this.primeGalleriaWidget.next();
    },

    /**
     * Moves to the previous content that comes before the currently shown content.
     */
    prev: function() {
        this.primeGalleriaWidget.prev();
    }
});
