/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.behavior.printer;

import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import org.primefaces.behavior.base.AbstractBehavior;
import org.primefaces.behavior.base.BehaviorAttribute;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.LangUtils;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="printer/printer.css"), @ResourceDependency(library="primefaces", name="printer/printer.js"), @ResourceDependency(library="primefaces", name="core.js")})
public class PrinterBehavior
extends AbstractBehavior {
    public String getScript(ClientBehaviorContext behaviorContext) {
        FacesContext context = behaviorContext.getFacesContext();
        String component = SearchExpressionFacade.resolveClientId(context, behaviorContext.getComponent(), this.getTarget());
        String title = this.getTitle();
        title = LangUtils.isNotBlank(title) ? "'" + EscapeUtils.forJavaScriptAttribute(title) + "'" : "document.title";
        return String.format("printJS({ printable: '%s', type: 'html', documentTitle: %s});return false;", component, title);
    }

    @Override
    protected BehaviorAttribute[] getAllAttributes() {
        return PropertyKeys.values();
    }

    public String getTarget() {
        return this.eval(PropertyKeys.target, null);
    }

    public void setTarget(String target) {
        this.put(PropertyKeys.target, (Object)target);
    }

    public String getTitle() {
        return this.eval(PropertyKeys.title, null);
    }

    public void setTitle(String title) {
        this.put(PropertyKeys.title, (Object)title);
    }

    public static enum PropertyKeys implements BehaviorAttribute
    {
        target(String.class),
        title(String.class);

        private final Class<?> expectedType;

        private PropertyKeys(Class<?> expectedType) {
            this.expectedType = expectedType;
        }

        @Override
        public Class<?> getExpectedType() {
            return this.expectedType;
        }
    }
}

