/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableBase;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.DataTableState;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.util.LangUtils;

public class SelectionFeature
implements DataTableFeature {
    private static final String ALL_SELECTOR = "@all";
    private static final SelectionFeature INSTANCE = new SelectionFeature();

    private SelectionFeature() {
    }

    public static SelectionFeature getInstance() {
        return INSTANCE;
    }

    @Override
    public void decode(FacesContext context, DataTable table) {
        String clientId = table.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        Object originalValue = table.getValue();
        boolean isFiltered = table.isFilteringCurrentlyActive();
        String selection = (String)params.get(clientId + "_selection");
        Set<String> rowKeys = Collections.emptySet();
        if (LangUtils.isNotBlank(selection)) {
            rowKeys = LangUtils.newLinkedHashSet(selection.split(","));
        }
        if (isFiltered) {
            table.setValue(null);
        }
        this.decodeSelection(context, table, rowKeys);
        if (isFiltered) {
            table.setValue(originalValue);
        }
        if (table.isMultiViewState()) {
            DataTableState ts = table.getMultiViewState(true);
            ts.setSelectedRowKeys(table.getSelectedRowKeys());
        }
    }

    public void decodeSelection(FacesContext context, DataTable table, Set<String> rowKeys) {
        table.setSelection(null);
        table.setSelectedRowKeys(null);
        if (table.isSingleSelectionMode()) {
            this.decodeSingleSelection(context, table, rowKeys);
        } else {
            this.decodeMultipleSelection(context, table, rowKeys);
        }
    }

    public void decodeSelectionRowKeys(FacesContext context, DataTable table) {
        Object selection;
        HashSet<String> rowKeys = null;
        ValueExpression selectionByVE = table.getValueExpression(DataTableBase.PropertyKeys.selection.name());
        if (selectionByVE != null && (selection = selectionByVE.getValue(context.getELContext())) != null) {
            rowKeys = new HashSet<String>();
            if (table.isSingleSelectionMode()) {
                rowKeys.add(table.getRowKey(selection));
            } else {
                boolean isArray;
                Class<?> clazz = selection.getClass();
                boolean bl = isArray = clazz != null && clazz.isArray();
                if (clazz != null && !isArray && !List.class.isAssignableFrom(clazz)) {
                    throw new FacesException("Multiple selection reference must be an Array or a List for datatable " + table.getClientId());
                }
                List<Object> selectionTmp = isArray ? Arrays.asList((Object[])selection) : (List<Object>)selection;
                for (int i = 0; i < selectionTmp.size(); ++i) {
                    Object o = selectionTmp.get(i);
                    rowKeys.add(table.getRowKey(o));
                }
            }
        }
        table.setSelectedRowKeys(rowKeys);
    }

    protected void decodeSingleSelection(FacesContext context, DataTable table, Set<String> rowKeys) {
        if (rowKeys.size() > 1) {
            throw new IllegalArgumentException("DataTable '" + table.getClientId(context) + "' is configured for single selection while multiple rows have been selected");
        }
        if (rowKeys.isEmpty()) {
            this.setSelection(context, table, false, Collections.emptyList(), Collections.emptySet());
        } else {
            String rowKey = rowKeys.iterator().next();
            Object o = table.getRowData(rowKey);
            if (o != null) {
                Map requestMap = context.getExternalContext().getRequestMap();
                String var = table.getVar();
                Set<String> rowKeysTmp = Collections.emptySet();
                if (this.isSelectable(table, var, requestMap, o)) {
                    rowKeysTmp = Collections.singleton(rowKey);
                }
                this.setSelection(context, table, false, Collections.singletonList(o), rowKeysTmp);
            } else {
                this.setSelection(context, table, false, Collections.emptyList(), Collections.emptySet());
            }
        }
    }

    protected void decodeMultipleSelection(FacesContext context, DataTable table, Set<String> rowKeys) {
        if (rowKeys.isEmpty()) {
            this.setSelection(context, table, true, Collections.emptyList(), Collections.emptySet());
        } else {
            Map requestMap = context.getExternalContext().getRequestMap();
            String var = table.getVar();
            ArrayList<Object> selection = new ArrayList<Object>();
            HashSet<String> rowKeysTmp = new HashSet<String>();
            if (!rowKeys.isEmpty() && ALL_SELECTOR.equals(rowKeys.iterator().next())) {
                for (int i = 0; i < table.getRowCount(); ++i) {
                    table.setRowIndex(i);
                    Object rowData = table.getRowData();
                    String rowKey = table.getRowKey(rowData);
                    if (rowKey == null) continue;
                    rowKeysTmp.add(rowKey);
                    if (rowData == null || !this.isSelectable(table, var, requestMap, rowData)) continue;
                    selection.add(rowData);
                }
            } else {
                for (String rowKey : rowKeys) {
                    Object rowData = table.getRowData(rowKey);
                    if (rowData == null) continue;
                    rowKeysTmp.add(rowKey);
                    if (!this.isSelectable(table, var, requestMap, rowData)) continue;
                    selection.add(rowData);
                }
            }
            this.setSelection(context, table, true, selection, rowKeysTmp);
        }
    }

    @Override
    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        throw new FacesException("SelectFeature should not encode.");
    }

    @Override
    public boolean shouldDecode(FacesContext context, DataTable table) {
        return table.isSelectionEnabled();
    }

    @Override
    public boolean shouldEncode(FacesContext context, DataTable table) {
        return false;
    }

    protected boolean isSelectable(DataTable table, String var, Map<String, Object> requestMap, Object o) {
        boolean selectable;
        boolean containsVar = requestMap.containsKey(var);
        if (!containsVar) {
            requestMap.put(var, o);
        }
        boolean bl = selectable = !table.isDisabledSelection();
        if (!containsVar) {
            requestMap.remove(var);
        }
        return selectable;
    }

    protected void setSelection(FacesContext context, DataTable table, boolean multiple, List<Object> selected, Set<String> rowKeys) {
        Object selection;
        boolean isArray;
        ValueExpression selectionVE = table.getValueExpression(DataTableBase.PropertyKeys.selection.toString());
        Class clazz = selectionVE == null ? null : selectionVE.getType(context.getELContext());
        boolean bl = isArray = clazz != null && clazz.isArray();
        if (multiple && clazz != null && !isArray && !List.class.isAssignableFrom(clazz)) {
            throw new FacesException("Multiple selection reference must be an Array or a List for DataTable " + table.getClientId());
        }
        if (selected.isEmpty()) {
            selection = multiple ? (isArray ? Array.newInstance(clazz.getComponentType(), 0) : Collections.emptyList()) : null;
        } else if (multiple) {
            if (isArray) {
                Object arr = Array.newInstance(clazz.getComponentType(), selected.size());
                selection = selected.toArray((Object[])arr);
            } else {
                selection = selected;
            }
        } else {
            selection = selected.get(0);
        }
        table.setSelectedRowKeys(rowKeys);
        if (selectionVE != null) {
            selectionVE.setValue(context.getELContext(), selection);
        } else {
            table.setSelection(selection);
        }
    }
}

