/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datepicker;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.api.UICalendar;
import org.primefaces.component.calendar.BaseCalendarRenderer;
import org.primefaces.component.datepicker.DatePicker;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.model.datepicker.DateMetadata;
import org.primefaces.model.datepicker.DateMetadataModel;
import org.primefaces.model.datepicker.LazyDateMetadataModel;
import org.primefaces.shaded.json.JSONObject;
import org.primefaces.util.CalendarUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class DatePickerRenderer
extends BaseCalendarRenderer {
    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Class<?> type;
        String pattern;
        DatePicker datePicker = (DatePicker)component;
        if (datePicker.getModel() instanceof LazyDateMetadataModel && ComponentUtils.isRequestSource((UIComponent)datePicker, context, "viewChange")) {
            this.encodeDateMetadata(context, datePicker);
            return;
        }
        String string = pattern = datePicker.getPattern() == null ? datePicker.calculatePattern() : datePicker.getPattern();
        if (datePicker.isShowTimeWithoutDefault() == null) {
            type = datePicker.getValueType();
            if (type != null) {
                datePicker.setShowTime(LocalDateTime.class.isAssignableFrom(type));
            } else {
                datePicker.setShowTime(CalendarUtils.hasTime(pattern));
            }
        }
        if (datePicker.isTimeOnlyWithoutDefault() == null && (type = datePicker.getValueType()) != null) {
            datePicker.setTimeOnly(LocalTime.class.isAssignableFrom(type));
        }
        if (datePicker.isShowSecondsWithoutDefault() == null) {
            datePicker.setShowSeconds(pattern.contains("s") || pattern.contains("S"));
        }
        if (datePicker.isShowMillisecondsWithoutDefault() == null) {
            datePicker.setShowMilliseconds(pattern.contains("S"));
        }
        super.encodeEnd(context, component);
    }

    protected void encodeDateMetadata(FacesContext context, DatePicker datePicker) throws IOException {
        LazyDateMetadataModel model = (LazyDateMetadataModel)datePicker.getModel();
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = datePicker.getClientId(context);
        int year = Integer.parseInt((String)params.get(clientId + "_year"));
        int month = Integer.parseInt((String)params.get(clientId + "_month")) + 1;
        LocalDate startDate = LocalDate.of(year, month, 1);
        LocalDate endDate = startDate.plusMonths(datePicker.getNumberOfMonths()).minusDays(1L);
        model.clear();
        model.loadDateMetadata(startDate, endDate);
        this.encodeDateMetadataAsJSON(context, datePicker, model);
    }

    protected void encodeDateMetadataAsJSON(FacesContext context, DatePicker datePicker, DateMetadataModel model) throws IOException {
        JSONObject jsonDateMetadata = new JSONObject();
        String pattern = datePicker.calculateWidgetPattern();
        for (Map.Entry<LocalDate, DateMetadata> entry : model.getDateMetadata().entrySet()) {
            String date = CalendarUtils.getValueAsString(context, datePicker, entry.getKey(), pattern);
            DateMetadata metadata = entry.getValue();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("disabled", metadata.isDisabled());
            jsonObject.put("styleClass", metadata.getStyleClass());
            jsonDateMetadata.put(date, jsonObject);
        }
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put("dateMetadata", jsonDateMetadata);
        ResponseWriter writer = context.getResponseWriter();
        writer.write(jsonResponse.toString());
    }

    @Override
    protected void encodeMarkup(FacesContext context, UICalendar uicalendar, String value) throws IOException {
        DatePicker datePicker = (DatePicker)uicalendar;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = datePicker.getClientId(context);
        String styleClass = datePicker.getStyleClass();
        styleClass = styleClass == null ? "ui-calendar" : "ui-calendar " + styleClass;
        styleClass = "p-datepicker " + styleClass;
        String inputId = clientId + "_input";
        boolean inline = datePicker.isInline();
        writer.startElement("span", (UIComponent)datePicker);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (datePicker.getStyle() != null) {
            writer.writeAttribute("style", (Object)datePicker.getStyle(), null);
        }
        this.encodeInput(context, datePicker, inputId, value, !inline);
        writer.endElement("span");
    }

    @Override
    protected void encodeScript(FacesContext context, UICalendar uicalendar, String value) throws IOException {
        String mask;
        String weekCalculator;
        String onYearChange;
        String onMonthChange;
        String beforeShow;
        List<Object> disabledDates;
        DatePicker datePicker = (DatePicker)uicalendar;
        Locale locale = datePicker.calculateLocale(context);
        String pattern = datePicker.calculateWidgetPattern();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("DatePicker", datePicker);
        String defaultDate = null;
        if (datePicker.isConversionFailed()) {
            Class<?> dateType = this.resolveDateType(context, datePicker);
            defaultDate = CalendarUtils.getValueAsString(context, datePicker, CalendarUtils.now(uicalendar, dateType));
        } else if (!this.isValueBlank(value)) {
            defaultDate = value;
        }
        wb.attr("defaultDate", defaultDate, null).attr("inline", datePicker.isInline()).attr("userLocale", locale.toString()).attr("dateFormat", CalendarUtils.convertPattern(pattern)).attr("showIcon", datePicker.isShowIcon(), false).attr("buttonTabindex", datePicker.getButtonTabindex()).attr("focusOnSelect", datePicker.isFocusOnSelect(), false).attr("disabled", datePicker.isDisabled(), false).attr("valid", datePicker.isValid(), true).attr("yearRange", datePicker.getYearRange(), null).attr("minDate", this.getMinMaxDate(context, datePicker, datePicker.getMindate(), false), null).attr("maxDate", this.getMinMaxDate(context, datePicker, datePicker.getMaxdate(), true), null).attr("selectionMode", datePicker.getSelectionMode(), null).attr("showOnFocus", datePicker.isShowOnFocus()).attr("shortYearCutoff", datePicker.getShortYearCutoff(), null).attr("monthNavigator", datePicker.isMonthNavigator(), false).attr("yearNavigator", datePicker.isYearNavigator(), false).attr("showButtonBar", datePicker.isShowButtonBar(), false).attr("panelStyleClass", datePicker.getPanelStyleClass(), null).attr("panelStyle", datePicker.getPanelStyle(), null).attr("keepInvalid", datePicker.isKeepInvalid(), false).attr("maxDateCount", datePicker.getMaxDateCount(), Integer.MAX_VALUE).attr("numberOfMonths", datePicker.getNumberOfMonths(), 1).attr("view", datePicker.getView(), null).attr("autoDetectDisplay", datePicker.isAutoDetectDisplay(), true).attr("touchUI", datePicker.isTouchUI(), false).attr("showWeek", datePicker.isShowWeek(), false).attr("appendTo", SearchExpressionFacade.resolveClientId(context, (UIComponent)datePicker, datePicker.getAppendTo(), SearchExpressionUtils.SET_RESOLVE_CLIENT_SIDE), null).attr("icon", datePicker.getTriggerButtonIcon(), null).attr("rangeSeparator", datePicker.getRangeSeparator(), "-").attr("timeSeparator", datePicker.getTimeSeparator(), ":").attr("fractionSeparator", datePicker.getFractionSeparator(), ".").attr("timeInput", datePicker.isTimeInput()).attr("touchable", ComponentUtils.isTouchable(context, datePicker), true).attr("lazyModel", datePicker.getModel() instanceof LazyDateMetadataModel, false);
        List<Integer> disabledDays = datePicker.getDisabledDays();
        if (disabledDays != null) {
            CalendarUtils.encodeListValue(context, datePicker, "disabledDays", disabledDays, pattern);
        }
        if ((disabledDates = datePicker.getInitialDisabledDates(context)) != null) {
            CalendarUtils.encodeListValue(context, datePicker, "disabledDates", disabledDates, pattern);
        }
        this.encodeScriptDateStyleClasses(wb, datePicker);
        String dateTemplate = datePicker.getDateTemplate();
        if (dateTemplate != null) {
            wb.nativeAttr("dateTemplate", dateTemplate);
        }
        if ((beforeShow = datePicker.getBeforeShow()) != null) {
            wb.nativeAttr("preShow", beforeShow);
        }
        if ((onMonthChange = datePicker.getOnMonthChange()) != null) {
            wb.nativeAttr("onMonthChange", onMonthChange);
        }
        if ((onYearChange = datePicker.getOnYearChange()) != null) {
            wb.nativeAttr("onYearChange", onYearChange);
        }
        if ((weekCalculator = datePicker.getWeekCalculator()) != null) {
            wb.nativeAttr("weekCalculator", weekCalculator);
        }
        if (datePicker.isShowOtherMonths()) {
            wb.attr("showOtherMonths", true).attr("selectOtherMonths", datePicker.isSelectOtherMonths());
        }
        if (datePicker.hasTime()) {
            wb.attr("showTime", datePicker.isShowTime(), false).attr("hourFormat", datePicker.getHourFormat(), null).attr("timeOnly", datePicker.isTimeOnly(), false).attr("showSeconds", datePicker.isShowSeconds(), false).attr("showMilliseconds", datePicker.isShowMilliseconds(), false).attr("stepHour", datePicker.getStepHour(), 1).attr("stepMinute", datePicker.getStepMinute(), 1).attr("stepSecond", datePicker.getStepSecond(), 1).attr("stepMillisecond", datePicker.getStepSecond(), 1).attr("hideOnDateTimeSelect", datePicker.isHideOnDateTimeSelect(), false);
        }
        if ((mask = datePicker.getMask()) != null && !"false".equals(mask)) {
            String patternTemplate = datePicker.calculatePattern();
            String maskTemplate = "true".equals(mask) ? datePicker.convertPattern(patternTemplate) : mask;
            wb.attr("mask", maskTemplate).attr("maskSlotChar", datePicker.getMaskSlotChar(), "_").attr("maskAutoClear", datePicker.isMaskAutoClear(), true);
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)datePicker);
        wb.finish();
    }

    protected void encodeScriptDateStyleClasses(WidgetBuilder wb, DatePicker datePicker) throws IOException {
        if (datePicker.getModel() == null) {
            return;
        }
        JSONObject styleClasses = new JSONObject();
        for (Map.Entry<LocalDate, DateMetadata> entry : datePicker.getModel().getDateMetadata().entrySet()) {
            DateMetadata metadata = entry.getValue();
            if (metadata.getStyleClass() == null) continue;
            styleClasses.put(entry.getKey().toString(), metadata.getStyleClass());
        }
        wb.nativeAttr("dateStyleClasses", styleClasses.toString());
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object value) throws ConverterException {
        String selectionMode;
        DatePicker datePicker = (DatePicker)component;
        String submittedValue = (String)value;
        if (this.isValueBlank(submittedValue)) {
            return null;
        }
        switch (selectionMode = datePicker.getSelectionMode()) {
            case "multiple": {
                String[] parts = submittedValue.split(",");
                ArrayList<Object> multi = new ArrayList<Object>();
                for (String part : parts) {
                    multi.add(super.getConvertedValue(context, component, part));
                }
                return multi;
            }
            case "range": {
                List<String> rangeStr = CalendarUtils.splitRange(submittedValue, datePicker.calculatePattern(), datePicker.getRangeSeparator());
                ArrayList<Object> range = new ArrayList<Object>();
                if (rangeStr.size() == 2) {
                    for (int i = 0; i < rangeStr.size(); ++i) {
                        range.add(super.getConvertedValue(context, component, rangeStr.get(i)));
                    }
                }
                return range;
            }
        }
        return super.getConvertedValue(context, component, value);
    }

    private String getMinMaxDate(FacesContext context, DatePicker datePicker, Object value, boolean max) {
        if (value instanceof LocalDate && datePicker.isShowTime()) {
            LocalDate date = (LocalDate)value;
            value = date.atTime(max ? LocalTime.MAX : LocalTime.MIN);
        }
        return CalendarUtils.getValueAsString(context, datePicker, value);
    }
}

