/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.donutchart;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.charts.ChartRenderer;
import org.primefaces.component.donutchart.DonutChart;
import org.primefaces.model.charts.donut.DonutChartOptions;
import org.primefaces.util.WidgetBuilder;

public class DonutChartRenderer
extends ChartRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        DonutChart chart = (DonutChart)component;
        String clientId = chart.getClientId(context);
        String style = chart.getStyle();
        String styleClass = chart.getStyleClass();
        this.encodeMarkup(context, clientId, style, styleClass);
        this.encodeScript(context, chart);
    }

    protected void encodeScript(FacesContext context, DonutChart chart) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("DonutChart", chart);
        this.encodeConfig(context, chart.getModel());
        this.encodeClientBehaviors(context, chart);
        wb.finish();
    }

    @Override
    protected void encodeOptions(FacesContext context, String type, Object options) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (options == null) {
            return;
        }
        DonutChartOptions donutOptions = (DonutChartOptions)options;
        writer.write(",options:{");
        writer.write("animation:{");
        writer.write("animateRotate:" + donutOptions.isAnimateRotate());
        writer.write(",animateScale:" + donutOptions.isAnimateScale());
        writer.write("}");
        if (donutOptions.getCutoutPercentage() != null) {
            writer.write(",cutoutPercentage:" + donutOptions.getCutoutPercentage());
        }
        if (donutOptions.getRotation() != null) {
            writer.write(",rotation:" + donutOptions.getRotation());
        }
        if (donutOptions.getCircumference() != null) {
            writer.write(",circumference:" + donutOptions.getCircumference());
        }
        this.encodeElements(context, donutOptions.getElements(), true);
        this.encodeAnimation(context, donutOptions.getAnimation(), true);
        this.encodePlugins(context, donutOptions, true);
        writer.write("}");
    }
}

