/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.export;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import java.util.List;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.primefaces.PrimeFaces;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.export.DataTableExporterFactory;
import org.primefaces.component.export.ExportConfiguration;
import org.primefaces.component.export.Exporter;
import org.primefaces.component.export.ExporterOptions;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.component.treetable.export.TreeTableExporterFactory;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.ResourceUtils;

public class DataExporter
implements ActionListener,
StateHolder {
    private ValueExpression target;
    private ValueExpression type;
    private ValueExpression fileName;
    private ValueExpression encoding;
    private ValueExpression pageOnly;
    private ValueExpression selectionOnly;
    private MethodExpression preProcessor;
    private MethodExpression postProcessor;
    private ValueExpression options;
    private MethodExpression onTableRender;
    private ValueExpression exporter;

    public DataExporter() {
        ResourceUtils.addComponentResource(FacesContext.getCurrentInstance(), "filedownload/filedownload.js");
    }

    public DataExporter(ValueExpression target, ValueExpression type, ValueExpression fileName, ValueExpression pageOnly, ValueExpression selectionOnly, ValueExpression encoding, MethodExpression preProcessor, MethodExpression postProcessor, ValueExpression options, MethodExpression onTableRender) {
        this();
        this.target = target;
        this.type = type;
        this.fileName = fileName;
        this.pageOnly = pageOnly;
        this.selectionOnly = selectionOnly;
        this.preProcessor = preProcessor;
        this.postProcessor = postProcessor;
        this.encoding = encoding;
        this.options = options;
        this.onTableRender = onTableRender;
    }

    public void processAction(ActionEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elContext = context.getELContext();
        String tables = (String)this.target.getValue(elContext);
        String exportAs = (String)this.type.getValue(elContext);
        String outputFileName = (String)this.fileName.getValue(elContext);
        String encodingType = "UTF-8";
        if (this.encoding != null) {
            encodingType = (String)this.encoding.getValue(elContext);
        }
        boolean isPageOnly = false;
        if (this.pageOnly != null) {
            isPageOnly = this.pageOnly.isLiteralText() ? Boolean.parseBoolean(this.pageOnly.getValue(context.getELContext()).toString()) : (Boolean)this.pageOnly.getValue(context.getELContext());
        }
        boolean isSelectionOnly = false;
        if (this.selectionOnly != null) {
            isSelectionOnly = this.selectionOnly.isLiteralText() ? Boolean.parseBoolean(this.selectionOnly.getValue(context.getELContext()).toString()) : (Boolean)this.selectionOnly.getValue(context.getELContext());
        }
        ExporterOptions exporterOptions = null;
        if (this.options != null) {
            exporterOptions = (ExporterOptions)this.options.getValue(elContext);
        }
        Object customExporterInstance = null;
        if (this.exporter != null) {
            customExporterInstance = this.exporter.getValue(elContext);
        }
        try {
            OutputStream outputStream;
            List<UIComponent> components = SearchExpressionFacade.resolveComponents(context, event.getComponent(), tables);
            Class<? extends UIComponent> targetClass = this.guessTargetClass(components);
            Exporter exporterInstance = this.getExporter(exportAs, exporterOptions, customExporterInstance, targetClass);
            ExportConfiguration config = new ExportConfiguration().setOutputFileName(outputFileName).setEncodingType(encodingType).setPageOnly(isPageOnly).setSelectionOnly(isSelectionOnly).setOptions(exporterOptions).setPreProcessor(this.preProcessor).setPostProcessor(this.postProcessor).setOnTableRender(this.onTableRender);
            ExternalContext externalContext = context.getExternalContext();
            String filenameWithExtension = config.getOutputFileName() + exporterInstance.getFileExtension();
            String contentType = exporterInstance.getContentType();
            if (contentType.startsWith("text/") && LangUtils.isNotBlank(config.getEncodingType())) {
                contentType = contentType + "; charset=" + config.getEncodingType();
            }
            if (PrimeFaces.current().isAjaxRequest()) {
                outputStream = new ByteArrayOutputStream();
            } else {
                outputStream = context.getExternalContext().getResponseOutputStream();
                externalContext.setResponseContentType(contentType);
                this.setResponseHeader(externalContext, ComponentUtils.createContentDisposition("attachment", filenameWithExtension));
                this.addResponseCookie(context);
            }
            exporterInstance.export(context, components, outputStream, config);
            if (PrimeFaces.current().isAjaxRequest()) {
                this.ajaxDownload(filenameWithExtension, ((ByteArrayOutputStream)outputStream).toByteArray(), contentType, context);
            } else {
                context.responseComplete();
            }
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    protected Class<? extends UIComponent> guessTargetClass(List<UIComponent> targets) {
        Class targetClass = null;
        if (targets != null) {
            for (UIComponent current : targets) {
                if (current instanceof DataTable) {
                    targetClass = DataTable.class;
                    continue;
                }
                if (!(current instanceof TreeTable)) continue;
                targetClass = TreeTable.class;
            }
        }
        return targetClass;
    }

    protected Exporter getExporter(String exportAs, ExporterOptions exporterOptions, Object customExporterInstance, Class<? extends UIComponent> targetClass) {
        if (customExporterInstance != null) {
            if (customExporterInstance instanceof Exporter) {
                return (Exporter)customExporterInstance;
            }
            throw new FacesException("Component " + this.getClass().getName() + " customExporterInstance=" + customExporterInstance.getClass().getName() + " does not implement Exporter!");
        }
        if (targetClass != null && TreeTable.class.isAssignableFrom(targetClass)) {
            return TreeTableExporterFactory.getExporter(exportAs, exporterOptions);
        }
        return DataTableExporterFactory.getExporter(exportAs, exporterOptions);
    }

    private void ajaxDownload(String filenameWithExtension, byte[] content, String contentType, FacesContext context) {
        String base64 = Base64.getEncoder().withoutPadding().encodeToString(content);
        String data = "data:" + contentType + ";base64," + base64;
        String monitorKeyCookieName = ResourceUtils.getMonitorKeyCookieName(context, null);
        PrimeFaces.current().executeScript(String.format("PrimeFaces.download('%s', '%s', '%s', '%s')", data, contentType, filenameWithExtension, monitorKeyCookieName));
    }

    protected void setResponseHeader(ExternalContext externalContext, String contentDisposition) {
        ResourceUtils.addNoCacheControl(externalContext);
        externalContext.setResponseHeader("Content-disposition", contentDisposition);
    }

    protected void addResponseCookie(FacesContext context) {
        ResourceUtils.addResponseCookie(context, "primefaces.download", "true", null);
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean value) {
    }

    public ValueExpression getExporter() {
        return this.exporter;
    }

    public void setExporter(ValueExpression exporter) {
        this.exporter = exporter;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.target = (ValueExpression)values[0];
        this.type = (ValueExpression)values[1];
        this.fileName = (ValueExpression)values[2];
        this.pageOnly = (ValueExpression)values[3];
        this.selectionOnly = (ValueExpression)values[4];
        this.preProcessor = (MethodExpression)values[5];
        this.postProcessor = (MethodExpression)values[6];
        this.encoding = (ValueExpression)values[7];
        this.options = (ValueExpression)values[8];
        this.onTableRender = (MethodExpression)values[9];
        this.exporter = (ValueExpression)values[10];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[12];
        values[0] = this.target;
        values[1] = this.type;
        values[2] = this.fileName;
        values[3] = this.pageOnly;
        values[4] = this.selectionOnly;
        values[5] = this.preProcessor;
        values[6] = this.postProcessor;
        values[7] = this.encoding;
        values[8] = this.options;
        values[9] = this.onTableRender;
        values[10] = this.exporter;
        return values;
    }
}

