/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.inputnumber;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.inputnumber.InputNumber;
import org.primefaces.component.inputnumber.InputNumberBase;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class InputNumberRenderer
extends InputRenderer {
    private static final BigDecimal DEFAULT_MIN_VALUE = new BigDecimal("-10000000000000");
    private static final BigDecimal DEFAULT_MAX_VALUE = new BigDecimal("10000000000000");

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return ComponentUtils.getConvertedValue(context, component, submittedValue);
    }

    public void decode(FacesContext context, UIComponent component) {
        InputNumber inputNumber = (InputNumber)component;
        if (!this.shouldDecode((UIInput)inputNumber)) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)inputNumber);
        String inputId = inputNumber.getClientId(context) + "_hinput";
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(inputId);
        if (submittedValue == null) {
            return;
        }
        try {
            if (LangUtils.isBlank(submittedValue)) {
                ValueExpression valueExpression = inputNumber.getValueExpression("value");
                if (valueExpression != null) {
                    Class type = valueExpression.getType(context.getELContext());
                    if (type != null && type.isPrimitive() && LangUtils.isNotBlank(inputNumber.getMinValue())) {
                        submittedValue = String.valueOf(new BigDecimal(inputNumber.getMinValue()).doubleValue());
                    } else if (type != null && type.isPrimitive() && LangUtils.isNotBlank(inputNumber.getMaxValue())) {
                        submittedValue = String.valueOf(new BigDecimal(inputNumber.getMaxValue()).doubleValue());
                    }
                }
            } else {
                BigDecimal value = new BigDecimal(submittedValue);
                submittedValue = this.coerceValueInRange(value, inputNumber).toString();
            }
        }
        catch (NumberFormatException ex) {
            throw new FacesException("Invalid number", (Throwable)ex);
        }
        inputNumber.setSubmittedValue(submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        InputNumber inputNumber = (InputNumber)component;
        Object value = inputNumber.getValue();
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)inputNumber, value);
        if (this.isValueBlank(valueToRender)) {
            valueToRender = "";
        } else {
            BigDecimal decimalToRender;
            try {
                decimalToRender = new BigDecimal(valueToRender);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error converting  [" + valueToRender + "] to a decimal value;", e);
            }
            valueToRender = this.formatForPlugin(this.coerceValueInRange(decimalToRender, inputNumber));
        }
        this.encodeMarkup(context, inputNumber, value, valueToRender);
        this.encodeScript(context, inputNumber, value, valueToRender);
    }

    protected void encodeMarkup(FacesContext context, InputNumber inputNumber, Object value, String valueToRender) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputNumber.getClientId(context);
        String styleClass = inputNumber.getStyleClass();
        styleClass = styleClass == null ? "ui-inputnumber ui-widget" : "ui-inputnumber ui-widget " + styleClass;
        styleClass = inputNumber.isValid() ? styleClass : styleClass + " ui-state-error";
        writer.startElement("span", (UIComponent)inputNumber);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (inputNumber.getStyle() != null) {
            writer.writeAttribute("style", (Object)inputNumber.getStyle(), "style");
        }
        this.encodeInput(context, inputNumber, clientId, valueToRender);
        this.encodeHiddenInput(context, inputNumber, clientId, valueToRender);
        writer.endElement("span");
    }

    protected void encodeHiddenInput(FacesContext context, InputNumber inputNumber, String clientId, String valueToRender) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = clientId + "_hinput";
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        writer.writeAttribute("value", (Object)valueToRender, null);
        if (inputNumber.getOnchange() != null) {
            writer.writeAttribute("onchange", (Object)inputNumber.getOnchange(), null);
        }
        if (inputNumber.getOnkeydown() != null) {
            writer.writeAttribute("onkeydown", (Object)inputNumber.getOnkeydown(), null);
        }
        if (inputNumber.getOnkeyup() != null) {
            writer.writeAttribute("onkeyup", (Object)inputNumber.getOnkeyup(), null);
        }
        this.renderValidationMetadata(context, (EditableValueHolder)inputNumber);
        writer.endElement("input");
    }

    protected void encodeInput(FacesContext context, InputNumber inputNumber, String clientId, String valueToRender) throws IOException {
        String inputStyle;
        ResponseWriter writer = context.getResponseWriter();
        String inputId = clientId + "_input";
        String style = inputStyle = inputNumber.getInputStyle();
        String styleClass = this.createStyleClass((UIInput)inputNumber, InputNumberBase.PropertyKeys.inputStyleClass.name(), "ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all");
        String inputMode = inputNumber.getInputmode();
        if (inputMode == null) {
            String decimalPlaces = this.getDecimalPlaces(inputNumber, inputNumber.getValue());
            inputMode = "0".equals(decimalPlaces) ? "numeric" : "decimal";
            inputNumber.setInputmode(inputMode);
        }
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)inputNumber.getType(), null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        writer.writeAttribute("value", (Object)valueToRender, null);
        if (!this.isValueBlank(style)) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.writeAttribute("class", (Object)styleClass, null);
        this.renderAccessibilityAttributes(context, (UIInput)inputNumber);
        this.renderPassThruAttributes(context, (UIComponent)inputNumber, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)inputNumber, HTML.INPUT_TEXT_EVENTS);
        this.renderValidationMetadata(context, (EditableValueHolder)inputNumber);
        writer.endElement("input");
    }

    protected void encodeScript(FacesContext context, InputNumber inputNumber, Object value, String valueToRender) throws IOException {
        String emptyValue = this.isValueBlank(inputNumber.getEmptyValue()) || "empty".equalsIgnoreCase(inputNumber.getEmptyValue()) ? "null" : inputNumber.getEmptyValue();
        String digitGroupSeparator = this.isValueBlank(inputNumber.getThousandSeparator()) ? "" : inputNumber.getThousandSeparator();
        String decimalSeparator = this.isValueBlank(inputNumber.getDecimalSeparator()) ? "." : inputNumber.getDecimalSeparator();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init(InputNumber.class.getSimpleName(), inputNumber);
        wb.attr("disabled", inputNumber.isDisabled()).attr("valueToRender", valueToRender).attr("decimalCharacter", decimalSeparator, ".").attr("decimalCharacterAlternative", inputNumber.getDecimalSeparatorAlternative(), null).attr("digitGroupSeparator", digitGroupSeparator, ",").attr("currencySymbol", inputNumber.getSymbol()).attr("currencySymbolPlacement", inputNumber.getSymbolPosition(), "p").attr("negativePositiveSignPlacement", inputNumber.getSignPosition(), null).attr("minimumValue", this.getMinimum(inputNumber, value)).attr("maximumValue", this.getMaximum(inputNumber, value)).attr("decimalPlaces", this.getDecimalPlaces(inputNumber, value)).attr("emptyInputBehavior", emptyValue, "focus").attr("leadingZero", inputNumber.getLeadingZero(), "deny").attr("allowDecimalPadding", inputNumber.isPadControl(), true).attr("modifyValueOnWheel", inputNumber.isModifyValueOnWheel(), true).attr("roundingMethod", inputNumber.getRoundMethod(), "S").attr("selectOnFocus", false, true).attr("showWarnings", false, true);
        wb.finish();
    }

    @Override
    protected String getHighlighter() {
        return "inputnumber";
    }

    private BigDecimal getEffectiveMinValue(InputNumber inputNumber) {
        String minimumValue = inputNumber.getMinValue();
        if (minimumValue == null) {
            return DEFAULT_MIN_VALUE;
        }
        try {
            return new BigDecimal(minimumValue);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error converting  [" + minimumValue + "] to a decimal value for minValue", e);
        }
    }

    private BigDecimal getEffectiveMaxValue(InputNumber inputNumber) {
        String maximumValue = inputNumber.getMaxValue();
        if (maximumValue == null) {
            return DEFAULT_MAX_VALUE;
        }
        try {
            return new BigDecimal(maximumValue);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error converting  [" + maximumValue + "] to a decimal value for maxValue", e);
        }
    }

    private BigDecimal coerceValueInRange(BigDecimal value, InputNumber inputNumber) {
        return this.coerceValueInRange(value, this.getEffectiveMinValue(inputNumber), this.getEffectiveMaxValue(inputNumber));
    }

    private BigDecimal coerceValueInRange(BigDecimal value, BigDecimal effectiveMinValue, BigDecimal effectiveMaxValue) {
        if (value.compareTo(effectiveMinValue) < 0) {
            return effectiveMinValue;
        }
        if (value.compareTo(effectiveMaxValue) > 0) {
            return effectiveMaxValue;
        }
        return value;
    }

    private String formatForPlugin(String valueToRender) {
        if (valueToRender == null) {
            return null;
        }
        if (this.isValueBlank(valueToRender)) {
            return "";
        }
        try {
            BigDecimal objectToRender = new BigDecimal(valueToRender);
            return this.formatForPlugin(objectToRender);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error converting  [" + valueToRender + "] to a decimal value;", e);
        }
    }

    private String formatForPlugin(BigDecimal valueToRender) {
        return valueToRender.toPlainString();
    }

    private String getDecimalPlaces(InputNumber inputNumber, Object value) {
        String defaultDecimalPlaces = "2";
        if (this.isIntegral(value)) {
            defaultDecimalPlaces = "0";
        }
        String decimalPlaces = this.isValueBlank(inputNumber.getDecimalPlaces()) ? defaultDecimalPlaces : inputNumber.getDecimalPlaces();
        return decimalPlaces;
    }

    private String getMinimum(InputNumber inputNumber, Object value) {
        String minimum = inputNumber.getMinValue();
        if (this.isIntegral(value) && "0.0000001".equals(minimum)) {
            minimum = "0";
        }
        return this.formatForPlugin(minimum);
    }

    private String getMaximum(InputNumber inputNumber, Object value) {
        String maximum = inputNumber.getMaxValue();
        if (this.isIntegral(value) && "-0.0000001".equals(maximum)) {
            maximum = "0";
        }
        return this.formatForPlugin(maximum);
    }

    private boolean isIntegral(Object value) {
        return value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof BigInteger || value instanceof Byte;
    }
}

