/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.schedule;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.schedule.Schedule;
import org.primefaces.model.LazyScheduleModel;
import org.primefaces.model.ScheduleEvent;
import org.primefaces.model.ScheduleModel;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.shaded.json.JSONArray;
import org.primefaces.shaded.json.JSONObject;
import org.primefaces.util.CalendarUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.LocaleUtils;
import org.primefaces.util.WidgetBuilder;

public class ScheduleRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Schedule schedule = (Schedule)component;
        String clientId = schedule.getClientId(context);
        String viewId = clientId + "_view";
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey(viewId)) {
            schedule.setView((String)params.get(viewId));
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Schedule schedule = (Schedule)component;
        if (ComponentUtils.isRequestSource((UIComponent)schedule, context) && schedule.isEventRequest(context)) {
            this.encodeEvents(context, schedule);
        } else {
            this.encodeMarkup(context, schedule);
            this.encodeScript(context, schedule);
        }
    }

    protected void encodeEvents(FacesContext context, Schedule schedule) throws IOException {
        String clientId = schedule.getClientId(context);
        ScheduleModel model = schedule.getValue();
        Map params = context.getExternalContext().getRequestParameterMap();
        if (model instanceof LazyScheduleModel) {
            String startDateParam = (String)params.get(clientId + "_start");
            String endDateParam = (String)params.get(clientId + "_end");
            ZoneId zoneId = CalendarUtils.calculateZoneId(schedule.getTimeZone());
            LocalDateTime startDate = CalendarUtils.toLocalDateTime(zoneId, startDateParam);
            LocalDateTime endDate = CalendarUtils.toLocalDateTime(zoneId, endDateParam);
            LazyScheduleModel lazyModel = (LazyScheduleModel)model;
            lazyModel.clear();
            lazyModel.loadEvents(startDate, endDate);
        }
        this.encodeEventsAsJSON(context, schedule, model);
    }

    protected void encodeEventsAsJSON(FacesContext context, Schedule schedule, ScheduleModel model) throws IOException {
        ZoneId zoneId = CalendarUtils.calculateZoneId(schedule.getTimeZone());
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(zoneId);
        JSONArray jsonEvents = new JSONArray();
        if (model != null) {
            for (ScheduleEvent<?> event : model.getEvents()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", event.getId());
                if (LangUtils.isNotBlank(event.getGroupId())) {
                    jsonObject.put("groupId", event.getGroupId());
                }
                jsonObject.put("title", event.getTitle());
                jsonObject.put("start", dateTimeFormatter.format(event.getStartDate().atZone(zoneId)));
                jsonObject.put("end", dateTimeFormatter.format(event.getEndDate().atZone(zoneId)));
                jsonObject.put("allDay", event.isAllDay());
                if (event.isDraggable() != null) {
                    jsonObject.put("startEditable", event.isDraggable());
                }
                if (event.isResizable() != null) {
                    jsonObject.put("durationEditable", event.isResizable());
                }
                jsonObject.put("overlap", event.isOverlapAllowed());
                if (event.getStyleClass() != null) {
                    jsonObject.put("classNames", event.getStyleClass());
                }
                if (event.getDescription() != null) {
                    jsonObject.put("description", event.getDescription());
                }
                if (event.getUrl() != null) {
                    jsonObject.put("url", event.getUrl());
                }
                if (event.getDisplay() != null) {
                    jsonObject.put("display", Objects.toString((Object)event.getDisplay(), null));
                }
                if (event.getBackgroundColor() != null) {
                    jsonObject.put("backgroundColor", event.getBackgroundColor());
                }
                if (event.getBorderColor() != null) {
                    jsonObject.put("borderColor", event.getBorderColor());
                }
                if (event.getTextColor() != null) {
                    jsonObject.put("textColor", event.getTextColor());
                }
                if (event.getDynamicProperties() != null) {
                    for (Map.Entry<String, Object> dynaProperty : event.getDynamicProperties().entrySet()) {
                        String key = dynaProperty.getKey();
                        Object value = dynaProperty.getValue();
                        if (value instanceof LocalDateTime) {
                            value = ((LocalDateTime)value).format(dateTimeFormatter);
                        }
                        jsonObject.put(key, value);
                    }
                }
                jsonEvents.put(jsonObject);
            }
        }
        JSONObject jsonResponse = new JSONObject();
        jsonResponse.put("events", jsonEvents);
        ResponseWriter writer = context.getResponseWriter();
        writer.write(jsonResponse.toString());
    }

    protected void encodeScript(FacesContext context, Schedule schedule) throws IOException {
        String displayEventEnd;
        String extender;
        String columnFormat;
        Locale locale = schedule.calculateLocale(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Schedule", schedule).attr("urlTarget", schedule.getUrlTarget(), "_blank").attr("noOpener", schedule.isNoOpener(), true).attr("locale", locale.toString()).attr("tooltip", schedule.isTooltip(), false);
        String string = columnFormat = schedule.getColumnHeaderFormat() != null ? schedule.getColumnHeaderFormat() : schedule.getColumnFormat();
        if (columnFormat != null) {
            wb.append(",columnFormatOptions:{" + columnFormat + "}");
        }
        if ((extender = schedule.getExtender()) != null) {
            wb.nativeAttr("extender", extender);
        }
        wb.append(",options:{");
        wb.append("locale:\"").append(LocaleUtils.toJavascriptLocale(locale)).append("\",");
        wb.append("initialView:\"").append(EscapeUtils.forJavaScript(this.translateViewName(schedule.getView().trim()))).append("\"");
        wb.attr("dayMaxEventRows", schedule.getValue().isEventLimit(), false);
        wb.attr("lazyFetching", false);
        Object initialDate = schedule.getInitialDate();
        if (initialDate != null) {
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ISO_DATE;
            wb.attr("initialDate", ((LocalDate)initialDate).format(dateTimeFormatter), null);
        }
        if (schedule.isShowHeader()) {
            wb.append(",headerToolbar:{start:'").append(schedule.getLeftHeaderTemplate()).append("'").attr("center", schedule.getCenterHeaderTemplate()).attr("end", this.translateViewNames(schedule.getRightHeaderTemplate())).append("}");
        } else {
            wb.attr("headerToolbar", false);
        }
        if (ComponentUtils.isRTL(context, schedule)) {
            wb.attr("direction", "rtl");
        }
        boolean isShowWeekNumbers = schedule.isShowWeekNumbers();
        wb.attr("allDaySlot", schedule.isAllDaySlot(), true).attr("height", schedule.getHeight(), null).attr("slotDuration", schedule.getSlotDuration(), "00:30:00").attr("scrollTime", schedule.getScrollTime(), "06:00:00").attr("timeZone", schedule.getClientTimeZone(), "local").attr("slotMinTime", schedule.getMinTime(), null).attr("slotMaxTime", schedule.getMaxTime(), null).attr("aspectRatio", schedule.getAspectRatio(), Double.MIN_VALUE).attr("weekends", schedule.isShowWeekends(), true).attr("eventStartEditable", schedule.isDraggable()).attr("eventDurationEditable", schedule.isResizable()).attr("slotLabelInterval", schedule.getSlotLabelInterval(), null).attr("eventTimeFormat", schedule.getTimeFormat(), null).attr("weekNumbers", isShowWeekNumbers, false).attr("nextDayThreshold", schedule.getNextDayThreshold(), "09:00:00").attr("slotEventOverlap", schedule.isSlotEventOverlap(), true);
        if (LangUtils.isNotBlank(schedule.getSlotLabelFormat())) {
            wb.nativeAttr("slotLabelFormat", schedule.getSlotLabelFormat());
        }
        if ((displayEventEnd = schedule.getDisplayEventEnd()) != null) {
            if ("true".equals(displayEventEnd) || "false".equals(displayEventEnd)) {
                wb.nativeAttr("displayEventEnd", displayEventEnd);
            } else {
                wb.nativeAttr("displayEventEnd", "{" + displayEventEnd + "}");
            }
        }
        if (isShowWeekNumbers) {
            String weekNumCalculation = schedule.getWeekNumberCalculation();
            String weekNumCalculator = schedule.getWeekNumberCalculator();
            if ("custom".equals(weekNumCalculation)) {
                if (weekNumCalculator != null) {
                    wb.append(",weekNumberCalculation: function(date){ return ").append(schedule.getWeekNumberCalculator()).append("}");
                }
            } else {
                wb.attr("weekNumberCalculation", weekNumCalculation, "local");
            }
        }
        wb.append("}");
        this.encodeClientBehaviors(context, schedule);
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, Schedule schedule) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = schedule.getClientId(context);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        if (schedule.getStyle() != null) {
            writer.writeAttribute("style", (Object)schedule.getStyle(), "style");
        }
        if (schedule.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)schedule.getStyleClass(), "style");
        }
        this.encodeStateParam(context, schedule);
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeStateParam(FacesContext context, Schedule schedule) throws IOException {
        String id = schedule.getClientId(context) + "_view";
        String view = schedule.getView();
        this.renderHiddenInput(context, id, view, false);
    }

    private String translateViewName(String viewNameOld) {
        switch (viewNameOld) {
            case "month": {
                return "dayGridMonth";
            }
            case "basicWeek": {
                return "dayGridWeek";
            }
            case "basicDay": {
                return "dayGridDay";
            }
            case "agendaWeek": {
                return "timeGridWeek";
            }
            case "agendaDay": {
                return "timeGridDay";
            }
        }
        return viewNameOld;
    }

    private String translateViewNames(String viewNamesOld) {
        if (viewNamesOld != null) {
            return Stream.of(viewNamesOld.split(",")).map(v -> this.translateViewName(v.trim())).collect(Collectors.joining(","));
        }
        return null;
    }
}

