/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.skeleton;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.skeleton.Skeleton;
import org.primefaces.renderkit.CoreRenderer;

public class SkeletonRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Skeleton skeleton = (Skeleton)component;
        ResponseWriter writer = context.getResponseWriter();
        String size = skeleton.getSize();
        String borderRadius = skeleton.getBorderRadius();
        String styleClass = this.getStyleClassBuilder(context).add("ui-skeleton ui-widget").add(skeleton.getStyleClass()).add("circle".equals(skeleton.getShape()), "ui-skeleton-circle").add("none".equals(skeleton.getAnimation()), "ui-skeleton-animation-none").build();
        boolean hasSize = size != null;
        String style = this.getStyleBuilder(context).add(skeleton.getStyle()).add(hasSize, "width", size, skeleton.getWidth()).add(hasSize, "height", size, skeleton.getHeight()).add(borderRadius != null, "borderRadius", borderRadius).build();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)skeleton.getClientId(context), "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        writer.writeAttribute("style", (Object)style, "style");
        writer.endElement("div");
    }
}

