/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tagcloud;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.tagcloud.TagCloud;
import org.primefaces.model.tagcloud.TagCloudItem;
import org.primefaces.model.tagcloud.TagCloudModel;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class TagCloudRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        TagCloud tagCloud = (TagCloud)component;
        this.encodeMarkup(context, tagCloud);
        this.encodeScript(context, tagCloud);
    }

    protected void encodeMarkup(FacesContext context, TagCloud tagCloud) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        TagCloudModel model = tagCloud.getModel();
        String styleClass = tagCloud.getStyleClass();
        String style = tagCloud.getStyle();
        styleClass = styleClass == null ? "ui-tagcloud ui-widget ui-widget-content ui-corner-all" : "ui-tagcloud ui-widget ui-widget-content ui-corner-all " + styleClass;
        writer.startElement("div", (UIComponent)tagCloud);
        writer.writeAttribute("id", (Object)tagCloud.getClientId(context), "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.startElement("ul", null);
        for (TagCloudItem item : model.getTags()) {
            String url = item.getUrl();
            String href = url == null ? "#" : item.getUrl();
            writer.startElement("li", null);
            writer.writeAttribute("class", (Object)("ui-tagcloud-strength-" + item.getStrength()), null);
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)href, null);
            writer.writeText((Object)item.getLabel(), null);
            writer.endElement("a");
            writer.endElement("li");
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, TagCloud tagCloud) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("TagCloud", tagCloud);
        this.encodeClientBehaviors(context, tagCloud);
        wb.finish();
    }
}

