/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.MethodExpression;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import org.primefaces.PrimeFaces;
import org.primefaces.component.tree.TreeBase;
import org.primefaces.component.tree.TreeDragDropInfo;
import org.primefaces.component.tree.UITreeNode;
import org.primefaces.event.NodeCollapseEvent;
import org.primefaces.event.NodeExpandEvent;
import org.primefaces.event.NodeSelectEvent;
import org.primefaces.event.NodeUnselectEvent;
import org.primefaces.event.TreeDragDropEvent;
import org.primefaces.model.CheckboxTreeNode;
import org.primefaces.model.DefaultTreeNode;
import org.primefaces.model.MatchMode;
import org.primefaces.model.TreeNode;
import org.primefaces.model.filter.ContainsFilterConstraint;
import org.primefaces.model.filter.EndsWithFilterConstraint;
import org.primefaces.model.filter.EqualsFilterConstraint;
import org.primefaces.model.filter.ExactFilterConstraint;
import org.primefaces.model.filter.FilterConstraint;
import org.primefaces.model.filter.GlobalFilterConstraint;
import org.primefaces.model.filter.GreaterThanEqualsFilterConstraint;
import org.primefaces.model.filter.GreaterThanFilterConstraint;
import org.primefaces.model.filter.InFilterConstraint;
import org.primefaces.model.filter.LessThanEqualsFilterConstraint;
import org.primefaces.model.filter.LessThanFilterConstraint;
import org.primefaces.model.filter.NegationFilterConstraintWrapper;
import org.primefaces.model.filter.RangeFilterConstraint;
import org.primefaces.model.filter.StartsWithFilterConstraint;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.MapBuilder;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class Tree
extends TreeBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.Tree";
    public static final String FILTER_CLASS = "ui-tree-filter ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all";
    public static final String FILTER_CONTAINER = "ui-tree-filter-container";
    public static final String CONTAINER_CLASS = "ui-tree ui-widget ui-widget-content ui-corner-all";
    public static final String CONTAINER_RTL_CLASS = "ui-tree ui-tree-rtl ui-widget ui-widget-content ui-corner-all";
    public static final String HORIZONTAL_CONTAINER_CLASS = "ui-tree ui-tree-horizontal ui-widget ui-widget-content ui-corner-all";
    public static final String ROOT_NODES_CLASS = "ui-tree-container";
    public static final String PARENT_NODE_CLASS = "ui-treenode ui-treenode-parent";
    public static final String LEAF_NODE_CLASS = "ui-treenode ui-treenode-leaf";
    public static final String CHILDREN_NODES_CLASS = "ui-treenode-children";
    public static final String NODE_CONTENT_CLASS_V = "ui-treenode-content";
    public static final String SELECTABLE_NODE_CONTENT_CLASS_V = "ui-treenode-content ui-tree-selectable";
    public static final String NODE_CONTENT_CLASS_H = "ui-treenode-content ui-state-default ui-corner-all";
    public static final String SELECTABLE_NODE_CONTENT_CLASS_H = "ui-treenode-content ui-tree-selectable ui-state-default ui-corner-all";
    public static final String EXPANDED_ICON_CLASS_V = "ui-tree-toggler ui-icon ui-icon-triangle-1-s";
    public static final String COLLAPSED_ICON_CLASS_V = "ui-tree-toggler ui-icon ui-icon-triangle-1-e";
    public static final String COLLAPSED_ICON_RTL_CLASS_V = "ui-tree-toggler ui-icon ui-icon-triangle-1-w";
    public static final String EXPANDED_ICON_CLASS_H = "ui-tree-toggler ui-icon ui-icon-minus";
    public static final String COLLAPSED_ICON_CLASS_H = "ui-tree-toggler ui-icon ui-icon-plus";
    public static final String LEAF_ICON_CLASS = "ui-treenode-leaf-icon";
    public static final String NODE_ICON_CLASS = "ui-treenode-icon ui-icon";
    public static final String NODE_LABEL_CLASS = "ui-treenode-label ui-corner-all";
    static final Map<MatchMode, FilterConstraint> FILTER_CONSTRAINTS = MapBuilder.builder().put(MatchMode.STARTS_WITH, new StartsWithFilterConstraint()).put(MatchMode.NOT_STARTS_WITH, (StartsWithFilterConstraint)((Object)new NegationFilterConstraintWrapper(new StartsWithFilterConstraint()))).put(MatchMode.ENDS_WITH, (StartsWithFilterConstraint)((Object)new EndsWithFilterConstraint())).put(MatchMode.NOT_ENDS_WITH, (StartsWithFilterConstraint)((Object)new NegationFilterConstraintWrapper(new EndsWithFilterConstraint()))).put(MatchMode.CONTAINS, (StartsWithFilterConstraint)((Object)new ContainsFilterConstraint())).put(MatchMode.NOT_CONTAINS, (StartsWithFilterConstraint)((Object)new NegationFilterConstraintWrapper(new ContainsFilterConstraint()))).put(MatchMode.EXACT, (StartsWithFilterConstraint)((Object)new ExactFilterConstraint())).put(MatchMode.NOT_EXACT, (StartsWithFilterConstraint)((Object)new NegationFilterConstraintWrapper(new ExactFilterConstraint()))).put(MatchMode.LESS_THAN, (StartsWithFilterConstraint)((Object)new LessThanFilterConstraint())).put(MatchMode.LESS_THAN_EQUALS, (StartsWithFilterConstraint)((Object)new LessThanEqualsFilterConstraint())).put(MatchMode.GREATER_THAN, (StartsWithFilterConstraint)((Object)new GreaterThanFilterConstraint())).put(MatchMode.GREATER_THAN_EQUALS, (StartsWithFilterConstraint)((Object)new GreaterThanEqualsFilterConstraint())).put(MatchMode.EQUALS, (StartsWithFilterConstraint)((Object)new EqualsFilterConstraint())).put(MatchMode.NOT_EQUALS, (StartsWithFilterConstraint)((Object)new NegationFilterConstraintWrapper(new EqualsFilterConstraint()))).put(MatchMode.IN, (StartsWithFilterConstraint)((Object)new InFilterConstraint())).put(MatchMode.NOT_IN, (StartsWithFilterConstraint)((Object)new NegationFilterConstraintWrapper(new InFilterConstraint()))).put(MatchMode.GLOBAL, (StartsWithFilterConstraint)((Object)new GlobalFilterConstraint())).put(MatchMode.RANGE, (StartsWithFilterConstraint)((Object)new RangeFilterConstraint())).put(MatchMode.BETWEEN, (StartsWithFilterConstraint)((Object)new RangeFilterConstraint())).put(MatchMode.NOT_BETWEEN, (StartsWithFilterConstraint)((Object)new NegationFilterConstraintWrapper(new RangeFilterConstraint()))).build();
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("select", NodeSelectEvent.class).put("unselect", NodeUnselectEvent.class).put("expand", NodeExpandEvent.class).put("collapse", NodeCollapseEvent.class).put("dragdrop", TreeDragDropEvent.class).put("contextMenu", NodeSelectEvent.class).put("filter", null).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();
    private Map<String, UITreeNode> nodes;
    private TreeNode dragNode;
    private TreeNode[] dragNodes;
    private TreeNode dropNode;
    private boolean retValOnDrop = true;
    private List<String> filteredRowKeys = new ArrayList<String>();

    public UITreeNode getUITreeNodeByType(String type) {
        UITreeNode node = this.getTreeNodes().get(type);
        if (node == null) {
            throw new FacesException("Unsupported tree node type:" + type);
        }
        return node;
    }

    public boolean isNodeExpandRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_expandNode");
    }

    public boolean isSelectionRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_instantSelection");
    }

    public boolean isFilterRequest(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey(this.getClientId(context) + "_filtering");
    }

    public Map<String, UITreeNode> getTreeNodes() {
        if (this.nodes == null) {
            this.nodes = new HashMap<String, UITreeNode>();
            for (UIComponent child : this.getChildren()) {
                if (!(child instanceof UITreeNode)) continue;
                UITreeNode node = (UITreeNode)child;
                this.nodes.put(node.getType(), node);
            }
        }
        return this.nodes;
    }

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    @Override
    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (ComponentUtils.isRequestSource((UIComponent)this, context) && event instanceof AjaxBehaviorEvent) {
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent wrapperEvent = null;
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            TreeNode root = this.getValue();
            if ("expand".equals(eventName)) {
                this.setRowKey(root, (String)params.get(clientId + "_expandNode"));
                TreeNode expandedNode = this.getRowNode();
                expandedNode.setExpanded(true);
                wrapperEvent = new NodeExpandEvent((UIComponent)this, behaviorEvent.getBehavior(), expandedNode);
            } else if ("collapse".equals(eventName)) {
                this.setRowKey(root, (String)params.get(clientId + "_collapseNode"));
                TreeNode collapsedNode = this.getRowNode();
                collapsedNode.setExpanded(false);
                wrapperEvent = new NodeCollapseEvent((UIComponent)this, behaviorEvent.getBehavior(), collapsedNode);
            } else if ("select".equals(eventName)) {
                this.setRowKey(root, (String)params.get(clientId + "_instantSelection"));
                wrapperEvent = new NodeSelectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowNode());
            } else if ("unselect".equals(eventName)) {
                this.setRowKey(root, (String)params.get(clientId + "_instantUnselection"));
                wrapperEvent = new NodeUnselectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowNode());
            } else if ("dragdrop".equals(eventName)) {
                if (!this.retValOnDrop) {
                    return;
                }
                int dndIndex = Integer.parseInt((String)params.get(clientId + "_dndIndex"));
                boolean isDroppedNodeCopy = Boolean.parseBoolean((String)params.get(clientId + "_isDroppedNodeCopy"));
                wrapperEvent = this.isMultipleDrag() ? new TreeDragDropEvent((UIComponent)this, behaviorEvent.getBehavior(), this.dragNodes, this.dropNode, dndIndex, isDroppedNodeCopy) : new TreeDragDropEvent((UIComponent)this, behaviorEvent.getBehavior(), this.dragNode, this.dropNode, dndIndex, isDroppedNodeCopy);
            } else if ("contextMenu".equals(eventName)) {
                this.setRowKey(root, (String)params.get(clientId + "_contextMenuNode"));
                wrapperEvent = new NodeSelectEvent((UIComponent)this, behaviorEvent.getBehavior(), this.getRowNode(), true);
            } else if ("filter".equals(eventName)) {
                wrapperEvent = behaviorEvent;
            }
            if (wrapperEvent == null) {
                throw new FacesException("Component " + this.getClass().getName() + " does not support event " + eventName + "!");
            }
            wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
            super.queueEvent((FacesEvent)wrapperEvent);
            this.setRowKey(root, null);
        } else {
            super.queueEvent(event);
        }
    }

    private boolean isToggleRequest(FacesContext context) {
        String clientId;
        Map params = context.getExternalContext().getRequestParameterMap();
        return params.get((clientId = this.getClientId(context)) + "_expandNode") != null || params.get(clientId + "_collapseNode") != null;
    }

    public boolean isDragDropRequest(FacesContext context) {
        String source;
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = this.getClientId(context);
        return clientId.equals(source = (String)context.getExternalContext().getRequestParameterMap().get("javax.faces.source")) && params.get(clientId + "_dragdrop") != null;
    }

    private boolean shouldSkipNodes(FacesContext context) {
        return this.isToggleRequest(context) || this.isDragDropRequest(context);
    }

    @Override
    public void processDecodes(FacesContext context) {
        if (!this.isRendered() || this.isDisabled()) {
            return;
        }
        if (this.shouldSkipNodes(context)) {
            this.decode(context);
        } else {
            super.processDecodes(context);
        }
    }

    @Override
    public void processValidators(FacesContext context) {
        if (!this.shouldSkipNodes(context)) {
            super.processValidators(context);
        }
    }

    @Override
    public void processUpdates(FacesContext context) {
        if (this.shouldSkipNodes(context)) {
            if (this.isSelectionEnabled()) {
                this.updateSelection(context);
            }
        } else {
            super.processUpdates(context);
        }
    }

    TreeNode getDragNode() {
        return this.dragNode;
    }

    void setDragNode(TreeNode dragNode) {
        this.dragNode = dragNode;
    }

    TreeNode[] getDragNodes() {
        return this.dragNodes;
    }

    void setDragNodes(TreeNode[] dragNodes) {
        this.dragNodes = dragNodes;
    }

    TreeNode getDropNode() {
        return this.dropNode;
    }

    void setDropNode(TreeNode dropNode) {
        this.dropNode = dropNode;
    }

    @Override
    protected boolean shouldVisitNode(TreeNode node) {
        return !this.isDynamic() || node.isExpanded() || node.getParent() == null;
    }

    @Override
    protected void processColumnChildren(FacesContext context, PhaseId phaseId, TreeNode root, String nodeKey) {
        this.setRowKey(root, nodeKey);
        TreeNode treeNode = this.getRowNode();
        if (treeNode == null) {
            return;
        }
        String treeNodeType = treeNode.getType();
        for (UIComponent child : this.getChildren()) {
            UITreeNode uiTreeNode;
            if (!(child instanceof UITreeNode) || !child.isRendered() || !treeNodeType.equals((uiTreeNode = (UITreeNode)child).getType())) continue;
            for (UIComponent grandkid : child.getChildren()) {
                if (!grandkid.isRendered()) continue;
                if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
                    grandkid.processDecodes(context);
                    continue;
                }
                if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
                    grandkid.processValidators(context);
                    continue;
                }
                if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
                    grandkid.processUpdates(context);
                    continue;
                }
                throw new IllegalArgumentException();
            }
        }
    }

    public TreeNode createCopyOfTreeNode(TreeNode<?> node) {
        TreeNode<?> newNode = node instanceof CheckboxTreeNode ? new CheckboxTreeNode(node.getData()) : new DefaultTreeNode(node.getData());
        newNode.setType(node.getType());
        newNode.setSelectable(node.isSelectable());
        newNode.setExpanded(node.isExpanded());
        for (TreeNode<?> childNode : node.getChildren()) {
            newNode.getChildren().add(this.createCopyOfTreeNode(childNode));
        }
        return newNode;
    }

    public boolean isTreeNodeDropped() {
        MethodExpression me = this.getOnDrop();
        if (me != null) {
            FacesContext context = this.getFacesContext();
            Map params = context.getExternalContext().getRequestParameterMap();
            String clientId = this.getClientId(context);
            int dndIndex = Integer.parseInt((String)params.get(clientId + "_dndIndex"));
            boolean isDroppedNodeCopy = Boolean.parseBoolean((String)params.get(clientId + "_isDroppedNodeCopy"));
            TreeDragDropInfo info = this.isMultipleDrag() ? new TreeDragDropInfo((UIComponent)this, this.getDragNodes(), this.getDropNode(), dndIndex, isDroppedNodeCopy) : new TreeDragDropInfo((UIComponent)this, this.getDragNode(), this.getDropNode(), dndIndex, isDroppedNodeCopy);
            this.retValOnDrop = (Boolean)me.invoke(context.getELContext(), new Object[]{info});
            PrimeFaces.current().ajax().addCallbackParam("access", this.retValOnDrop);
        }
        return this.retValOnDrop;
    }

    public String getScrollState() {
        String name;
        Map params = this.getFacesContext().getExternalContext().getRequestParameterMap();
        String value = (String)params.get(name = this.getClientId() + "_scrollState");
        return value == null ? "0,0" : value;
    }

    public List<String> getFilteredRowKeys() {
        return this.filteredRowKeys;
    }

    public void setFilteredRowKeys(List<String> filteredRowKeys) {
        this.filteredRowKeys = filteredRowKeys;
    }

    public Object saveState(FacesContext context) {
        this.nodes = null;
        this.dragNode = null;
        this.dragNodes = null;
        this.dropNode = null;
        this.retValOnDrop = true;
        this.filteredRowKeys = new ArrayList<String>();
        return super.saveState(context);
    }
}

