/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.treetable.export;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.Objects;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.export.CSVOptions;
import org.primefaces.component.export.ExportConfiguration;
import org.primefaces.component.export.ExporterOptions;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.component.treetable.export.TreeTableExporter;
import org.primefaces.util.ComponentUtils;

public class TreeTableCSVExporter
extends TreeTableExporter {
    private CSVOptions csvOptions;

    @Override
    protected void preExport(FacesContext context, ExportConfiguration exportConfiguration) throws IOException {
        this.csvOptions = CSVOptions.EXCEL;
        ExporterOptions options = exportConfiguration.getOptions();
        if (options != null) {
            if (options instanceof CSVOptions) {
                this.csvOptions = (CSVOptions)options;
            } else {
                throw new IllegalArgumentException("Options must be an instance of CSVOptions.");
            }
        }
    }

    @Override
    public void doExport(FacesContext context, TreeTable table, ExportConfiguration exportConfiguration, int index) throws IOException {
        try (OutputStreamWriter osw = new OutputStreamWriter(this.getOutputStream(), exportConfiguration.getEncodingType());
             PrintWriter writer = new PrintWriter(osw);){
            if (exportConfiguration.getPreProcessor() != null) {
                exportConfiguration.getPreProcessor().invoke(context.getELContext(), new Object[]{writer});
            }
            this.addColumnFacets(writer, table, TreeTableExporter.ColumnType.HEADER);
            if (exportConfiguration.isPageOnly()) {
                this.exportPageOnly(context, table, writer);
            } else if (exportConfiguration.isSelectionOnly()) {
                this.exportSelectionOnly(context, table, writer);
            } else {
                this.exportAll(context, table, writer);
            }
            if (table.hasFooterColumn()) {
                this.addColumnFacets(writer, table, TreeTableExporter.ColumnType.FOOTER);
            }
            if (exportConfiguration.getPostProcessor() != null) {
                exportConfiguration.getPostProcessor().invoke(context.getELContext(), new Object[]{writer});
            }
            writer.flush();
        }
    }

    @Override
    public String getContentType() {
        return "text/csv";
    }

    @Override
    public String getFileExtension() {
        return ".csv";
    }

    protected void addColumnFacets(PrintWriter writer, TreeTable table, TreeTableExporter.ColumnType columnType) throws IOException {
        boolean firstCellWritten = false;
        for (UIColumn col : this.getExportableColumns(table)) {
            String textValue;
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (firstCellWritten) {
                writer.append(this.csvOptions.getDelimiterChar());
            }
            UIComponent facet = col.getFacet(columnType.facet());
            switch (columnType) {
                case HEADER: {
                    textValue = col.getExportHeaderValue() != null ? col.getExportHeaderValue() : col.getHeaderText();
                    break;
                }
                case FOOTER: {
                    textValue = col.getExportFooterValue() != null ? col.getExportFooterValue() : col.getFooterText();
                    break;
                }
                default: {
                    textValue = null;
                }
            }
            if (textValue != null) {
                this.addColumnValue(writer, textValue);
            } else if (ComponentUtils.shouldRenderFacet(facet)) {
                this.addColumnValue(writer, facet);
            } else {
                this.addColumnValue(writer, "");
            }
            firstCellWritten = true;
        }
        writer.append(this.csvOptions.getEndOfLineSymbols());
    }

    @Override
    protected void exportCells(TreeTable table, Object document) {
        PrintWriter writer = (PrintWriter)document;
        boolean firstCellWritten = false;
        for (UIColumn col : this.getExportableColumns(table)) {
            if (col instanceof DynamicColumn) {
                ((DynamicColumn)col).applyStatelessModel();
            }
            if (firstCellWritten) {
                writer.append(this.csvOptions.getDelimiterChar());
            }
            try {
                this.addColumnValue(writer, table, col.getChildren(), col);
            }
            catch (IOException ex) {
                throw new FacesException((Throwable)ex);
            }
            firstCellWritten = true;
        }
    }

    protected void addColumnValue(PrintWriter writer, UIComponent component) throws IOException {
        String value = component == null ? "" : this.exportValue(FacesContext.getCurrentInstance(), component);
        this.addColumnValue(writer, value);
    }

    protected void addColumnValue(PrintWriter writer, String value) throws IOException {
        value = value == null ? "" : value.replace(this.csvOptions.getQuoteString(), this.csvOptions.getDoubleQuoteString());
        writer.append(this.csvOptions.getQuoteChar()).append(value).append(this.csvOptions.getQuoteChar());
    }

    protected void addColumnValue(PrintWriter writer, TreeTable table, List<UIComponent> components, UIColumn column) throws IOException {
        FacesContext context = FacesContext.getCurrentInstance();
        writer.append(this.csvOptions.getQuoteChar());
        this.exportColumn(context, table, column, components, false, s -> writer.append(this.escapeQuotes(Objects.toString(s, ""))));
        writer.append(this.csvOptions.getQuoteChar());
    }

    protected String escapeQuotes(String value) {
        return value == null ? "" : value.replace(this.csvOptions.getQuoteString(), this.csvOptions.getDoubleQuoteString());
    }

    @Override
    protected void postRowExport(TreeTable table, Object document) {
        ((PrintWriter)document).append(this.csvOptions.getEndOfLineSymbols());
    }
}

