/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.treetable.feature;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.primefaces.PrimeFaces;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.component.treetable.TreeTableRenderer;
import org.primefaces.component.treetable.feature.TreeTableFeature;
import org.primefaces.model.TreeNode;
import org.primefaces.util.LangUtils;
import org.primefaces.util.SharedStringBuilder;

public class SelectionFeature
implements TreeTableFeature {
    private static final String SB_DECODE_SELECTION = TreeTableRenderer.class.getName() + "#decodeSelection";
    private static final SelectionFeature INSTANCE = new SelectionFeature();

    private SelectionFeature() {
    }

    public static SelectionFeature getInstance() {
        return INSTANCE;
    }

    @Override
    public void decode(FacesContext context, TreeTable table) {
        boolean multiple = table.isMultipleSelectionMode();
        Class<?> selectionType = table.getSelectionType();
        TreeNode root = table.getValue();
        if (multiple && !selectionType.isArray() && !List.class.isAssignableFrom(selectionType)) {
            throw new FacesException("Multiple selection reference must be an Array or a List for TreeTable " + table.getClientId());
        }
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = table.getClientId(context);
        String selectionValue = (String)params.get(table.getClientId(context) + "_selection");
        if (LangUtils.isBlank(selectionValue)) {
            if (multiple) {
                table.setSelection(selectionType.isArray() ? new TreeNode[]{} : Collections.emptyList());
            } else {
                table.setSelection(null);
            }
        } else {
            String[] selectedRowKeys = selectionValue.split(",");
            if (multiple) {
                TreeNode[] selectedNodes = new ArrayList();
                for (int i = 0; i < selectedRowKeys.length; ++i) {
                    table.setRowKey(root, selectedRowKeys[i]);
                    TreeNode rowNode = table.getRowNode();
                    if (rowNode == null) continue;
                    selectedNodes.add(rowNode);
                }
                table.setSelection(selectionType.isArray() ? selectedNodes.toArray(new TreeNode[selectedNodes.size()]) : selectedNodes);
            } else {
                table.setRowKey(root, selectedRowKeys[0]);
                table.setSelection(table.getRowNode());
            }
            table.setRowKey(root, null);
        }
        if (table.isCheckboxSelectionMode() && table.isSelectionRequest(context)) {
            String selectedNodeRowKey = (String)params.get(clientId + "_instantSelection");
            table.setRowKey(root, selectedNodeRowKey);
            TreeNode selectedNode = table.getRowNode();
            ArrayList<String> descendantRowKeys = new ArrayList<String>();
            table.populateRowKeys(selectedNode, descendantRowKeys);
            StringBuilder builder = SharedStringBuilder.get(context, SB_DECODE_SELECTION);
            for (int i = 0; i < descendantRowKeys.size(); ++i) {
                if (i > 0) {
                    builder.append(",");
                }
                builder.append((String)descendantRowKeys.get(i));
            }
            PrimeFaces.current().ajax().addCallbackParam("descendantRowKeys", builder.toString());
        }
    }

    @Override
    public void encode(FacesContext context, TreeTableRenderer renderer, TreeTable table) throws IOException {
        throw new FacesException("SelectFeature should not encode.");
    }

    @Override
    public boolean shouldDecode(FacesContext context, TreeTable table) {
        return table.isSelectionEnabled();
    }

    @Override
    public boolean shouldEncode(FacesContext context, TreeTable table) {
        return false;
    }
}

