/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import javax.faces.model.ListDataModel;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.LazyDataModelIterator;
import org.primefaces.model.SelectableDataModel;
import org.primefaces.model.SortMeta;

public abstract class LazyDataModel<T>
extends ListDataModel<T>
implements SelectableDataModel<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Converter converter;
    private int rowCount;
    private int pageSize;
    private int rowIndex = -1;
    private List<T> data;

    public LazyDataModel() {
    }

    public LazyDataModel(Converter converter) {
        this.converter = converter;
    }

    public abstract int count(Map<String, FilterMeta> var1);

    public abstract List<T> load(int var1, int var2, Map<String, SortMeta> var3, Map<String, FilterMeta> var4);

    @Override
    public T getRowData(String rowKey) {
        if (this.converter != null) {
            FacesContext context = FacesContext.getCurrentInstance();
            return (T)this.converter.getAsObject(context, UIComponent.getCurrentComponent((FacesContext)context), rowKey);
        }
        throw new UnsupportedOperationException(this.getMessage("Provide a Converter via constructor or implement getRowData(String rowKey) in %s, when basic rowKey algorithm is not used [component=%s,view=%s]."));
    }

    @Override
    public String getRowKey(T object) {
        if (this.converter != null) {
            FacesContext context = FacesContext.getCurrentInstance();
            return this.converter.getAsString(context, UIComponent.getCurrentComponent((FacesContext)context), object);
        }
        throw new UnsupportedOperationException(this.getMessage("Provide a Converter via constructor or implement getRowKey(T object) in %s, when basic rowKey algorithm is not used [component=%s,view=%s]."));
    }

    protected String getMessage(String msg) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String viewId = facesContext.getViewRoot().getViewId();
        UIComponent component = UIComponent.getCurrentComponent((FacesContext)facesContext);
        String clientId = component == null ? "<unknown>" : component.getClientId(facesContext);
        return String.format(msg, this.getClass().getName(), clientId, viewId);
    }

    public boolean isRowAvailable() {
        if (this.data == null) {
            return false;
        }
        return this.rowIndex >= 0 && this.rowIndex < this.data.size();
    }

    public T getRowData() {
        return this.data.get(this.rowIndex);
    }

    public List<T> getWrappedData() {
        return this.data;
    }

    public void setWrappedData(Object list) {
        this.data = (List)list;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        int oldIndex = this.rowIndex;
        this.rowIndex = rowIndex == -1 || this.pageSize == 0 ? -1 : rowIndex % this.pageSize;
        if (this.data == null) {
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (listeners != null && oldIndex != this.rowIndex) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent dataModelEvent = new DataModelEvent((DataModel)this, rowIndex, rowData);
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].rowSelected(dataModelEvent);
            }
        }
    }

    public Iterator<T> iterator() {
        return new LazyDataModelIterator(this);
    }

    public Iterator<T> iterator(Map<String, SortMeta> sortBy, Map<String, FilterMeta> filterBy) {
        return new LazyDataModelIterator(this, sortBy, filterBy);
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }
}

