/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.io.Serializable;
import java.util.function.Supplier;
import org.primefaces.util.SerializableSupplier;

public class Lazy<T>
implements Serializable,
Supplier<T> {
    private static final Object NOT_INITIALIZED = new Object();
    private volatile T value = NOT_INITIALIZED;
    private volatile SerializableSupplier<T> init;

    public Lazy(SerializableSupplier<T> init) {
        this.init = init;
    }

    public synchronized void reset(SerializableSupplier<T> init) {
        this.init = init;
        this.value = NOT_INITIALIZED;
    }

    public synchronized void reset(T value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        T result = this.value;
        if (result == NOT_INITIALIZED) {
            Lazy lazy = this;
            synchronized (lazy) {
                result = this.value;
                if (result == NOT_INITIALIZED) {
                    result = this.value = this.init.get();
                }
            }
        }
        return result;
    }

    public boolean isInitialized() {
        return this.value != NOT_INITIALIZED;
    }
}

