/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.application;

import jakarta.faces.application.ConfigurableNavigationHandler;
import jakarta.faces.application.NavigationCase;
import jakarta.faces.context.FacesContext;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.primefaces.PrimeFaces;
import org.primefaces.util.EscapeUtils;

public class DialogNavigationHandler
extends ConfigurableNavigationHandler {
    private final ConfigurableNavigationHandler base;

    public DialogNavigationHandler(ConfigurableNavigationHandler base) {
        this.base = base;
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        Map attrs = context.getAttributes();
        String dialogOutcome = (String)attrs.get("dialog.outcome");
        if (dialogOutcome != null) {
            Map requestParams = context.getExternalContext().getRequestParameterMap();
            NavigationCase navCase = this.getNavigationCase(context, fromAction, dialogOutcome);
            String toViewId = navCase.getToViewId(context);
            Map options = (Map)attrs.get("dialog.options");
            Map params = (Map)attrs.get("dialog.params");
            if (params == null) {
                params = Collections.emptyMap();
            }
            boolean includeViewParams = false;
            if (options != null && options.containsKey("includeViewParams")) {
                includeViewParams = (Boolean)options.get("includeViewParams");
            }
            String url = context.getApplication().getViewHandler().getBookmarkableURL(context, toViewId, params, includeViewParams);
            url = EscapeUtils.forJavaScript(url);
            StringBuilder sb = new StringBuilder();
            String sourceComponentId = (String)attrs.get("dialog.source.component");
            String sourceWidget = (String)attrs.get("dialog.source.widget");
            String pfdlgcid = (String)requestParams.get("pfdlgcid");
            if (pfdlgcid == null) {
                pfdlgcid = UUID.randomUUID().toString();
            }
            pfdlgcid = EscapeUtils.forJavaScript(pfdlgcid);
            sb.append("PrimeFaces.openDialog({url:'").append(url).append("',pfdlgcid:'").append(pfdlgcid).append("',sourceComponentId:'").append(sourceComponentId).append("'");
            if (sourceWidget != null) {
                sb.append(",sourceWidgetVar:'").append(sourceWidget).append("'");
            }
            sb.append(",options:{");
            if (options != null && !options.isEmpty()) {
                Iterator it = options.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    String optionName = (String)entry.getKey();
                    Object optionValue = entry.getValue();
                    sb.append(optionName).append(":");
                    if (optionValue instanceof String) {
                        sb.append("'").append(EscapeUtils.forJavaScript((String)optionValue)).append("'");
                    } else {
                        sb.append(optionValue);
                    }
                    if (!it.hasNext()) continue;
                    sb.append(",");
                }
            }
            sb.append("}});");
            PrimeFaces.current().executeScript(sb.toString());
            sb.setLength(0);
        } else {
            this.base.handleNavigation(context, fromAction, outcome);
        }
    }

    public NavigationCase getNavigationCase(FacesContext context, String fromAction, String outcome) {
        return this.base.getNavigationCase(context, fromAction, outcome);
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        return this.base.getNavigationCases();
    }
}

