/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.application.resource;

import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.primefaces.application.resource.BaseDynamicContentHandler;
import org.primefaces.model.StreamedContent;

public class StreamedContentHandler
extends BaseDynamicContentHandler {
    private static final Logger LOGGER = Logger.getLogger(StreamedContentHandler.class.getName());

    @Override
    public void handle(FacesContext context) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        String library = (String)params.get("ln");
        String resourceKey = (String)params.get("pfdrid");
        if (resourceKey != null && library != null && library.equals("primefaces")) {
            boolean cache = Boolean.parseBoolean((String)params.get("pfdrid_c"));
            try {
                String dynamicContentEL;
                ExternalContext externalContext = context.getExternalContext();
                Map session = externalContext.getSessionMap();
                Map dynamicResourcesMapping = (Map)session.get("primefaces.dynamicResourcesMapping");
                if (dynamicResourcesMapping != null && (dynamicContentEL = (String)dynamicResourcesMapping.get(resourceKey)) != null) {
                    ELContext eLContext = context.getELContext();
                    ValueExpression ve = context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), dynamicContentEL, Object.class);
                    Object value = ve.getValue(eLContext);
                    if (value == null) {
                        if (context.isProjectStage(ProjectStage.Development)) {
                            LOGGER.log(Level.WARNING, "Dynamic content resolved to null - skip streaming resource for ValueExpression: {0}", dynamicContentEL);
                        }
                        this.sendNotFound(externalContext);
                        return;
                    }
                    if (value instanceof StreamedContent) {
                        StreamedContent streamedContent = (StreamedContent)value;
                        if (streamedContent.getWriter() != null) {
                            this.setResponseHeaders(streamedContent, externalContext);
                            this.stream(externalContext, streamedContent.getWriter(), cache);
                        } else {
                            if (streamedContent.getStream() == null) {
                                if (context.isProjectStage(ProjectStage.Development)) {
                                    LOGGER.log(Level.WARNING, "Stream of StreamedContent resolved to null - skip streaming resource for ValueExpression: {0}", dynamicContentEL);
                                }
                                this.sendNotFound(externalContext);
                                return;
                            }
                            try (InputStream inputStream = streamedContent.getStream().get();){
                                if (inputStream == null) {
                                    if (context.isProjectStage(ProjectStage.Development)) {
                                        LOGGER.log(Level.WARNING, "Stream of StreamedContent resolved to null - skip streaming resource for ValueExpression: {0}", dynamicContentEL);
                                    }
                                    this.sendNotFound(externalContext);
                                    return;
                                }
                                this.setResponseHeaders(streamedContent, externalContext);
                                this.stream(externalContext, inputStream, cache);
                            }
                        }
                    } else {
                        if (value instanceof InputStream) {
                            try (InputStream inputStream = (InputStream)value;){
                                this.stream(externalContext, inputStream, cache);
                            }
                        }
                        if (value instanceof byte[]) {
                            try (ByteArrayInputStream inputStream = new ByteArrayInputStream((byte[])value);){
                                this.stream(externalContext, inputStream, cache);
                            }
                        }
                    }
                }
                externalContext.responseFlushBuffer();
                context.responseComplete();
            }
            catch (Exception e) {
                throw new IOException("Error in streaming dynamic resource", e);
            }
        }
    }

    protected void setResponseHeaders(StreamedContent streamedContent, ExternalContext externalContext) {
        if (streamedContent.getContentType() != null) {
            externalContext.setResponseContentType(streamedContent.getContentType());
        }
        if (streamedContent.getContentLength() != null) {
            externalContext.setResponseContentLength(streamedContent.getContentLength().intValue());
        }
        if (streamedContent.getContentEncoding() != null) {
            externalContext.setResponseHeader("Content-Encoding", streamedContent.getContentEncoding());
        }
        if (streamedContent.getName() != null) {
            externalContext.setResponseHeader("Content-Disposition", "inline;filename=\"" + streamedContent.getName() + "\"");
        }
    }

    protected void stream(ExternalContext externalContext, InputStream inputStream, boolean cache) throws IOException {
        int length;
        externalContext.setResponseStatus(200);
        this.handleCache(externalContext, cache);
        byte[] buffer = new byte[2048];
        while ((length = inputStream.read(buffer)) >= 0) {
            externalContext.getResponseOutputStream().write(buffer, 0, length);
        }
    }

    protected void stream(ExternalContext externalContext, Consumer<OutputStream> writer, boolean cache) throws IOException {
        externalContext.setResponseStatus(200);
        this.handleCache(externalContext, cache);
        writer.accept(externalContext.getResponseOutputStream());
    }

    protected void sendNotFound(ExternalContext externalContext) throws IOException {
        if (externalContext.getRequest() instanceof HttpServletRequest) {
            externalContext.responseSendError(404, ((HttpServletRequest)externalContext.getRequest()).getRequestURI());
        } else {
            externalContext.responseSendError(404, null);
        }
    }
}

