/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.behavior.base;

import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.application.Application;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.AttachedObjectHandler;
import jakarta.faces.view.AttachedObjectTarget;
import jakarta.faces.view.BehaviorHolderAttachedObjectHandler;
import jakarta.faces.view.BehaviorHolderAttachedObjectTarget;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagException;
import jakarta.faces.view.facelets.TagHandler;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.primefaces.behavior.ajax.AjaxBehaviorHandler;
import org.primefaces.behavior.base.AbstractBehavior;
import org.primefaces.behavior.base.BehaviorAttribute;
import org.primefaces.config.PrimeEnvironment;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.util.LangUtils;

public abstract class AbstractBehaviorHandler<E extends AbstractBehavior>
extends TagHandler
implements BehaviorHolderAttachedObjectHandler {
    protected static final String MOJARRA_ATTACHED_OBJECT_HANDLERS_KEY = "jakarta.faces.RetargetableHandlers";
    protected static final String MOJARRA_22_ATTACHED_OBJECT_HANDLERS_KEY = "jakarta.faces.view.AttachedObjectHandlers";
    protected static Method myfacesGetCompositionContextInstance;
    protected static Method myfacesAddAttachedObjectHandler;
    private final TagAttribute event = this.getAttribute("event");

    public AbstractBehaviorHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext faceletContext, UIComponent parent) throws IOException {
        if (!ComponentHandler.isNew((UIComponent)parent)) {
            return;
        }
        String eventName = this.getEventName();
        if (UIComponent.isCompositeComponent((UIComponent)parent)) {
            BeanInfo componentBeanInfo;
            boolean tagApplied = false;
            if (parent instanceof ClientBehaviorHolder) {
                this.applyAttachedObject(faceletContext, parent);
                tagApplied = true;
            }
            if (null == (componentBeanInfo = (BeanInfo)parent.getAttributes().get("jakarta.faces.component.BEANINFO_KEY"))) {
                throw new TagException(this.tag, "Composite component does not have BeanInfo attribute");
            }
            BeanDescriptor componentDescriptor = componentBeanInfo.getBeanDescriptor();
            if (null == componentDescriptor) {
                throw new TagException(this.tag, "Composite component BeanInfo does not have BeanDescriptor");
            }
            List targetList = (List)componentDescriptor.getValue("jakarta.faces.view.AttachedObjectTargets");
            if (null == targetList && !tagApplied) {
                throw new TagException(this.tag, "Composite component does not support behavior events");
            }
            boolean supportedEvent = false;
            if (targetList != null) {
                for (int i = 0; i < targetList.size(); ++i) {
                    AttachedObjectTarget target = (AttachedObjectTarget)targetList.get(i);
                    if (!(target instanceof BehaviorHolderAttachedObjectTarget)) continue;
                    BehaviorHolderAttachedObjectTarget behaviorTarget = (BehaviorHolderAttachedObjectTarget)target;
                    if ((null == eventName || !eventName.equals(behaviorTarget.getName())) && (null != eventName || !behaviorTarget.isDefaultEvent())) continue;
                    supportedEvent = true;
                    break;
                }
            }
            if (supportedEvent) {
                FacesContext context = FacesContext.getCurrentInstance();
                PrimeEnvironment environment = PrimeApplicationContext.getCurrentInstance(context).getEnvironment();
                if (environment.isMojarra()) {
                    this.addAttachedObjectHandlerToMojarra(environment, parent);
                } else {
                    this.addAttachedObjectHandlerToMyFaces(parent, faceletContext);
                }
            } else if (!tagApplied) {
                throw new TagException(this.tag, "Composite component does not support event " + eventName);
            }
        } else if (parent instanceof ClientBehaviorHolder) {
            this.applyAttachedObject(faceletContext, parent);
        } else {
            throw new TagException(this.tag, "Unable to attach behavior to non-ClientBehaviorHolder parent");
        }
    }

    public String getEventName() {
        if (this.event == null) {
            return null;
        }
        if (this.event.isLiteral()) {
            return this.event.getValue();
        }
        FaceletContext faceletContext = this.getFaceletContext(FacesContext.getCurrentInstance());
        ValueExpression expression = this.event.getValueExpression(faceletContext, String.class);
        return (String)expression.getValue((ELContext)faceletContext);
    }

    protected void setBehaviorAttribute(FaceletContext ctx, E behavior, TagAttribute attr, Class<?> type) {
        if (attr != null) {
            String attributeName = attr.getLocalName();
            if (attr.isLiteral()) {
                ((AbstractBehavior)((Object)behavior)).setLiteral(attributeName, attr.getObject(ctx, type));
            } else {
                ((AbstractBehavior)((Object)behavior)).setValueExpression(attributeName, attr.getValueExpression(ctx, type));
            }
        }
    }

    protected FaceletContext getFaceletContext(FacesContext context) {
        FaceletContext faceletContext = (FaceletContext)context.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY);
        if (faceletContext == null) {
            faceletContext = (FaceletContext)context.getAttributes().get("com.sun.faces.facelets.FACELET_CONTEXT");
        }
        return faceletContext;
    }

    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext faceletContext = this.getFaceletContext(context);
        this.applyAttachedObject(faceletContext, parent);
    }

    public void applyAttachedObject(FaceletContext faceletContext, UIComponent parent) {
        ClientBehaviorHolder holder = (ClientBehaviorHolder)parent;
        String eventName = this.getEventName();
        if (null == eventName) {
            eventName = holder.getDefaultEventName();
            if (null == eventName) {
                throw new TagException(this.tag, "Event attribute could not be determined: " + eventName);
            }
        } else {
            Collection eventNames = holder.getEventNames();
            if (!eventNames.contains(eventName)) {
                throw new TagException(this.tag, "Event:" + eventName + " is not supported.");
            }
        }
        Application application = faceletContext.getFacesContext().getApplication();
        AbstractBehavior behavior = (AbstractBehavior)application.createBehavior(this.getBehaviorId());
        this.init(faceletContext, behavior, eventName, parent);
        holder.addClientBehavior(eventName, (ClientBehavior)behavior);
    }

    public abstract String getBehaviorId();

    public String getFor() {
        return null;
    }

    protected void addAttachedObjectHandlerToMojarra(PrimeEnvironment environment, UIComponent component) {
        String key = MOJARRA_ATTACHED_OBJECT_HANDLERS_KEY;
        if (environment.isAtLeastJsf22()) {
            key = MOJARRA_22_ATTACHED_OBJECT_HANDLERS_KEY;
        }
        Map attrs = component.getAttributes();
        List result = (List)attrs.computeIfAbsent(key, k -> new ArrayList(5));
        result.add(this);
    }

    protected void addAttachedObjectHandlerToMyFaces(UIComponent component, FaceletContext ctx) {
        try {
            if (myfacesGetCompositionContextInstance == null || myfacesAddAttachedObjectHandler == null) {
                Class clazz = LangUtils.tryToLoadClassForName("org.apache.myfaces.view.facelets.FaceletCompositionContext");
                myfacesGetCompositionContextInstance = clazz.getDeclaredMethod("getCurrentInstance", FaceletContext.class);
                myfacesAddAttachedObjectHandler = clazz.getDeclaredMethod("addAttachedObjectHandler", UIComponent.class, AttachedObjectHandler.class);
            }
            Object faceletCompositionContextInstance = myfacesGetCompositionContextInstance.invoke(null, ctx);
            myfacesAddAttachedObjectHandler.invoke(faceletCompositionContextInstance, new Object[]{component, this});
        }
        catch (Exception ex) {
            Logger.getLogger(AjaxBehaviorHandler.class.getName()).log(Level.SEVERE, "Could not add AttachedObjectHandler to MyFaces!", ex);
        }
    }

    protected void init(FaceletContext ctx, E behavior, String eventName, UIComponent parent) {
        for (BehaviorAttribute attr : ((AbstractBehavior)((Object)behavior)).getAllAttributes()) {
            TagAttribute tag = this.getAttribute(attr.getName());
            this.setBehaviorAttribute(ctx, behavior, tag, attr.getExpectedType());
        }
    }
}

