/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.api;

import jakarta.el.ELContext;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.primefaces.component.celleditor.CellEditor;
import org.primefaces.util.LangUtils;

public interface UIColumn {
    public static final Pattern DYNAMIC_FIELD_VE_LEGACY_PATTERN = Pattern.compile("^#\\{\\w+\\[([\\w.]+)]}$");
    public static final Pattern STATIC_FIELD_VE_LEGACY_PATTERN = Pattern.compile("^#\\{\\w+\\.([\\w.]+)}$");

    default public String resolveField(FacesContext context, ValueExpression expression) {
        String exprStr = expression.getExpressionString();
        if (this.isDynamic()) {
            ELContext elContext = context.getELContext();
            Matcher matcher = DYNAMIC_FIELD_VE_LEGACY_PATTERN.matcher(exprStr);
            if (matcher.find()) {
                exprStr = matcher.group(1);
                expression = context.getApplication().getExpressionFactory().createValueExpression(elContext, "#{" + exprStr + "}", String.class);
                return (String)expression.getValue(elContext);
            }
        } else {
            Matcher matcher = STATIC_FIELD_VE_LEGACY_PATTERN.matcher(exprStr);
            if (matcher.find()) {
                return matcher.group(1);
            }
        }
        return null;
    }

    public static ValueExpression createValueExpressionFromField(FacesContext context, String var, String field) {
        if (LangUtils.isBlank(var) || LangUtils.isBlank(field)) {
            throw new FacesException("Table 'var' and Column 'field' attributes must be non null.");
        }
        return context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), "#{" + var + "." + field + "}", Object.class);
    }

    public ValueExpression getValueExpression(String var1);

    public String getContainerClientId(FacesContext var1);

    public String getColumnKey();

    default public String getColumnKey(UIComponent parent, int rowIndex) {
        return this.getColumnKey(parent, String.valueOf(rowIndex));
    }

    public String getColumnKey(UIComponent var1, String var2);

    public String getClientId();

    public String getClientId(FacesContext var1);

    public String getSelectionMode();

    public boolean isResizable();

    public String getStyle();

    public String getStyleClass();

    public int getRowspan();

    public int getColspan();

    public String getFilterPosition();

    public UIComponent getFacet(String var1);

    public Object getFilterBy();

    public Object getFilterValue();

    public String getHeaderText();

    public String getFooterText();

    public String getFilterStyleClass();

    public String getFilterStyle();

    public String getFilterMatchMode();

    public int getFilterMaxLength();

    public Object getFilterOptions();

    public CellEditor getCellEditor();

    public boolean isDynamic();

    public MethodExpression getSortFunction();

    public Object getSortBy();

    public List<UIComponent> getChildren();

    public boolean isExportable();

    public boolean isRendered();

    public void encodeAll(FacesContext var1) throws IOException;

    public void renderChildren(FacesContext var1) throws IOException;

    public String getWidth();

    public boolean isToggleable();

    public boolean isDraggable();

    public MethodExpression getFilterFunction();

    public String getField();

    public int getResponsivePriority();

    public boolean isSortable();

    public boolean isFilterable();

    public boolean isVisible();

    public boolean isSelectRow();

    public String getAriaHeaderText();

    public MethodExpression getExportFunction();

    public String getExportValue();

    public boolean isGroupRow();

    public String getExportHeaderValue();

    public String getExportFooterValue();

    public String getSortOrder();

    public int getSortPriority();

    public int getNullSortOrder();

    public boolean isCaseSensitiveSort();

    public int getDisplayPriority();
}

