/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.api;

import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.context.FacesContext;
import java.lang.reflect.Array;
import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.primefaces.component.api.ColumnAware;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.MultiViewStateAware;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.api.UITableState;
import org.primefaces.component.headerrow.HeaderRow;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.expression.SearchExpressionHint;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.model.ColumnMeta;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.SortMeta;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;

public interface UITable<T extends UITableState>
extends ColumnAware,
MultiViewStateAware<T> {
    public static final String GLOBAL_FILTER_COMPONENT_ID = "globalFilter";

    public String getVar();

    public String getClientId(FacesContext var1);

    default public Map<String, FilterMeta> initFilterBy(FacesContext context) {
        HashMap<String, FilterMeta> filterBy = new HashMap<String, FilterMeta>();
        AtomicBoolean filtered = new AtomicBoolean();
        this.forEachColumn(c -> {
            FilterMeta meta = FilterMeta.of(context, this.getVar(), c);
            if (meta != null) {
                filterBy.put(meta.getColumnKey(), meta);
                filtered.set(filtered.get() || meta.isActive());
            }
            return true;
        });
        Object userFilterBy = this.getFilterBy();
        if (userFilterBy != null) {
            this.updateFilterByWithUserFilterBy(context, filterBy, userFilterBy, filtered);
        }
        this.updateFilterByWithGlobalFilter(context, filterBy, filtered);
        this.setDefaultFilter(filtered.get());
        this.setFilterByAsMap(filterBy);
        return filterBy;
    }

    default public void updateFilterByWithMVS(FacesContext context, Map<String, FilterMeta> tsFilterBy) {
        boolean defaultFilter = this.isDefaultFilter();
        for (Map.Entry<String, FilterMeta> entry : tsFilterBy.entrySet()) {
            UIComponent globalFilterComponent;
            FilterMeta intlFilterBy = this.getFilterByAsMap().get(entry.getKey());
            if (intlFilterBy != null) {
                FilterMeta tsFilterMeta = entry.getValue();
                intlFilterBy.setFilterValue(tsFilterMeta.getFilterValue());
                defaultFilter |= intlFilterBy.isActive();
            }
            if (!GLOBAL_FILTER_COMPONENT_ID.equals(entry.getKey()) || (globalFilterComponent = SearchExpressionFacade.resolveComponent(context, (UIComponent)this, GLOBAL_FILTER_COMPONENT_ID, SearchExpressionUtils.SET_NONE)) == null || !(globalFilterComponent instanceof ValueHolder)) continue;
            ((ValueHolder)globalFilterComponent).setValue(entry.getValue().getFilterValue());
        }
        this.setDefaultFilter(defaultFilter);
    }

    default public void updateFilterByWithUserFilterBy(FacesContext context, Map<String, FilterMeta> intlFilterBy, Object usrFilterBy, AtomicBoolean filtered) {
        Collection<FilterMeta> filterByTmp;
        if (usrFilterBy instanceof FilterMeta) {
            filterByTmp = Collections.singletonList((FilterMeta)usrFilterBy);
        } else {
            if (!(usrFilterBy instanceof Collection)) {
                throw new FacesException("filterBy expects a single or a collection of FilterMeta");
            }
            filterByTmp = (Collection)usrFilterBy;
        }
        for (FilterMeta userFM : filterByTmp) {
            FilterMeta intlFM = intlFilterBy.values().stream().filter(o -> Objects.equals(o.getField(), userFM.getField()) || Objects.equals(o.getColumnKey(), userFM.getColumnKey())).findAny().orElseThrow(() -> new FacesException("No column with field '" + userFM.getField() + "' or columnKey '" + userFM.getColumnKey() + "' has been found"));
            ValueExpression filterByVE = userFM.getFilterBy();
            if (filterByVE == null) {
                filterByVE = UIColumn.createValueExpressionFromField(context, this.getVar(), userFM.getField());
            }
            intlFM.setFilterValue(userFM.getFilterValue());
            intlFM.setFilterBy(filterByVE);
            intlFM.setConstraint(userFM.getConstraint());
            intlFM.setMatchMode(userFM.getMatchMode());
            filtered.set(filtered.get() || userFM.isActive());
        }
    }

    default public void updateFilterByWithGlobalFilter(FacesContext context, Map<String, FilterMeta> filterBy, AtomicBoolean filtered) {
        String globalFilterDefaultValue = this.getGlobalFilter();
        Set<SearchExpressionHint> hint = LangUtils.isBlank(globalFilterDefaultValue) ? SearchExpressionUtils.SET_IGNORE_NO_RESULT : SearchExpressionUtils.SET_NONE;
        UIComponent globalFilterComponent = SearchExpressionFacade.resolveComponent(context, (UIComponent)this, GLOBAL_FILTER_COMPONENT_ID, hint);
        if (globalFilterComponent != null) {
            if (globalFilterComponent instanceof ValueHolder) {
                ((ValueHolder)globalFilterComponent).setValue((Object)globalFilterDefaultValue);
            }
            FilterMeta globalFilterBy = FilterMeta.of(globalFilterDefaultValue, this.getGlobalFilterFunction());
            filterBy.put(globalFilterBy.getColumnKey(), globalFilterBy);
            filtered.set(filtered.get() || globalFilterBy.isActive());
        }
    }

    default public boolean isColumnFilterable(FacesContext context, UIColumn column) {
        Map<String, FilterMeta> filterBy = this.getFilterByAsMap();
        if (filterBy.containsKey(column.getColumnKey())) {
            return true;
        }
        FilterMeta f = FilterMeta.of(context, this.getVar(), column);
        if (f != null) {
            filterBy.put(f.getColumnKey(), f);
        }
        return f != null;
    }

    default public void updateFilterByValuesWithFilterRequest(FacesContext context, Map<String, FilterMeta> filterBy) {
        Map params = context.getExternalContext().getRequestParameterMap();
        char separator = UINamingContainer.getSeparatorChar((FacesContext)context);
        FilterMeta globalFilter = filterBy.get(GLOBAL_FILTER_COMPONENT_ID);
        if (globalFilter != null) {
            globalFilter.setFilterValue(params.get(((UIComponent)this).getClientId(context) + separator + GLOBAL_FILTER_COMPONENT_ID));
        }
        this.forEachColumn(column -> {
            Object filterValue;
            Object filterFacet;
            boolean hasCustomFilter;
            FilterMeta filterMeta = (FilterMeta)filterBy.get(column.getColumnKey());
            if (filterMeta == null || filterMeta.isGlobalFilter()) {
                return true;
            }
            if (column instanceof DynamicColumn) {
                ((DynamicColumn)column).applyModel();
            }
            if (hasCustomFilter = ComponentUtils.shouldRenderFacet(filterFacet = this.getFilterComponent((UIColumn)column))) {
                filterValue = ((ValueHolder)filterFacet).getLocalValue();
            } else {
                String valueHolderClientId = column instanceof DynamicColumn ? column.getContainerClientId(context) + separator + "filter" : column.getClientId(context) + separator + "filter";
                filterValue = params.get(valueHolderClientId);
            }
            if (filterValue != null && (filterValue instanceof String && LangUtils.isBlank((String)filterValue) || filterValue instanceof Collection && ((Collection)filterValue).isEmpty() || filterValue instanceof Iterable && !((Iterable)filterValue).iterator().hasNext() || filterValue.getClass().isArray() && Array.getLength(filterValue) == 0)) {
                filterValue = null;
            }
            filterMeta.setFilterValue(filterValue);
            return true;
        });
    }

    default public Object getFilterValue(UIColumn column) {
        return this.getFilterByAsMap().get(column.getColumnKey()).getFilterValue();
    }

    public boolean isDefaultFilter();

    public void setDefaultFilter(boolean var1);

    public Object getFilterBy();

    public void setFilterBy(Object var1);

    public boolean isFilterByAsMapDefined();

    public Map<String, FilterMeta> getFilterByAsMap();

    public void setFilterByAsMap(Map<String, FilterMeta> var1);

    default public Map<String, FilterMeta> getActiveFilterMeta() {
        return this.getFilterByAsMap().values().stream().filter(FilterMeta::isActive).collect(Collectors.toMap(FilterMeta::getField, Function.identity()));
    }

    public String getGlobalFilter();

    public void setGlobalFilter(String var1);

    public MethodExpression getGlobalFilterFunction();

    public void setGlobalFilterFunction(MethodExpression var1);

    public boolean isGlobalFilterOnly();

    public void setGlobalFilterOnly(boolean var1);

    default public Map<String, SortMeta> initSortBy(FacesContext context) {
        HashMap<String, SortMeta> sortBy = new HashMap<String, SortMeta>();
        AtomicBoolean sorted = new AtomicBoolean();
        HeaderRow headerRow = this.getHeaderRow();
        if (headerRow != null) {
            SortMeta meta = SortMeta.of(context, this.getVar(), headerRow);
            sortBy.put(meta.getColumnKey(), meta);
            sorted.set(true);
        }
        this.forEachColumn(c -> {
            SortMeta meta = SortMeta.of(context, this.getVar(), c);
            if (meta != null) {
                sorted.set(sorted.get() || meta.isActive());
                sortBy.put(meta.getColumnKey(), meta);
            }
            return true;
        });
        Object userSortBy = this.getSortBy();
        if (userSortBy != null) {
            this.updateSortByWithUserSortBy(context, sortBy, userSortBy, sorted);
        }
        this.setDefaultSort(sorted.get());
        this.setSortByAsMap(sortBy);
        return sortBy;
    }

    default public void updateSortByWithMVS(Map<String, SortMeta> tsSortBy) {
        boolean defaultSort = this.isDefaultSort();
        for (Map.Entry<String, SortMeta> entry : tsSortBy.entrySet()) {
            SortMeta intlSortBy = this.getSortByAsMap().get(entry.getKey());
            if (intlSortBy == null) continue;
            SortMeta tsSortMeta = entry.getValue();
            intlSortBy.setPriority(tsSortMeta.getPriority());
            intlSortBy.setOrder(tsSortMeta.getOrder());
            defaultSort |= intlSortBy.isActive();
        }
        this.setDefaultSort(defaultSort);
    }

    default public void updateSortByWithUserSortBy(FacesContext context, Map<String, SortMeta> intlSortBy, Object usrSortBy, AtomicBoolean sorted) {
        Collection<SortMeta> sortBy;
        if (usrSortBy instanceof SortMeta) {
            sortBy = Collections.singletonList((SortMeta)usrSortBy);
        } else {
            if (!(usrSortBy instanceof Collection)) {
                throw new FacesException("sortBy expects a single or a collection of SortMeta");
            }
            sortBy = (Collection)usrSortBy;
        }
        for (SortMeta userSM : sortBy) {
            SortMeta intlSM = intlSortBy.values().stream().filter(o -> Objects.equals(o.getField(), userSM.getField()) || Objects.equals(o.getColumnKey(), userSM.getColumnKey())).findAny().orElseThrow(() -> new FacesException("No column with field '" + userSM.getField() + "' or columnKey '" + userSM.getColumnKey() + "' has been found"));
            ValueExpression sortByVE = userSM.getSortBy();
            if (sortByVE == null) {
                sortByVE = UIColumn.createValueExpressionFromField(context, this.getVar(), userSM.getField());
            }
            intlSM.setPriority(userSM.getPriority());
            intlSM.setOrder(userSM.getOrder());
            intlSM.setSortBy(sortByVE);
            intlSM.setFunction(userSM.getFunction());
            sorted.set(sorted.get() || userSM.isActive());
        }
    }

    default public SortMeta getHighestPriorityActiveSortMeta() {
        return this.getSortByAsMap().values().stream().filter(SortMeta::isActive).min(Comparator.comparingInt(SortMeta::getPriority)).orElse(null);
    }

    default public Map<String, SortMeta> getActiveSortMeta() {
        return this.getSortByAsMap().values().stream().filter(SortMeta::isActive).sorted().collect(Collectors.toMap(SortMeta::getField, Function.identity(), (o1, o2) -> o1, LinkedHashMap::new));
    }

    default public boolean isSortingCurrentlyActive() {
        return this.getSortByAsMap().values().stream().anyMatch(SortMeta::isActive);
    }

    default public boolean isColumnSortable(FacesContext context, UIColumn column) {
        Map<String, SortMeta> sortBy = this.getSortByAsMap();
        if (sortBy.containsKey(column.getColumnKey())) {
            return true;
        }
        SortMeta s = SortMeta.of(context, this.getVar(), column);
        if (s != null) {
            sortBy.put(s.getColumnKey(), s);
        }
        return s != null;
    }

    default public String getSortMetaAsString() {
        return this.getActiveSortMeta().values().stream().map(SortMeta::getColumnKey).collect(Collectors.joining("','", "['", "']"));
    }

    default public boolean isSortingEnabled() {
        return !this.getSortByAsMap().isEmpty();
    }

    default public HeaderRow getHeaderRow() {
        return null;
    }

    public Map<String, SortMeta> getSortByAsMap();

    public void setSortByAsMap(Map<String, SortMeta> var1);

    default public boolean isFilteringEnabled() {
        return this.isFilterByAsMapDefined() && !this.getFilterByAsMap().isEmpty();
    }

    public Object getSortBy();

    public void setSortBy(Object var1);

    public boolean isDefaultSort();

    public void setDefaultSort(boolean var1);

    default public void decodeColumnTogglerState(FacesContext context) {
        String columnTogglerStateParam = (String)context.getExternalContext().getRequestParameterMap().get(this.getClientId(context) + "_columnTogglerState");
        if (columnTogglerStateParam == null) {
            return;
        }
        Map<String, ColumnMeta> columMeta = this.getColumnMeta();
        columMeta.values().stream().forEach(s -> s.setVisible(null));
        if (LangUtils.isNotBlank(columnTogglerStateParam)) {
            String[] columnStates;
            for (String columnState : columnStates = columnTogglerStateParam.split(",")) {
                if (LangUtils.isBlank(columnState)) continue;
                int seperatorIndex = columnState.lastIndexOf(95);
                String columnKey = columnState.substring(0, seperatorIndex);
                boolean visible = Boolean.parseBoolean(columnState.substring(seperatorIndex + 1));
                ColumnMeta meta = columMeta.computeIfAbsent(columnKey, k -> new ColumnMeta((String)k));
                meta.setVisible(visible);
            }
        }
        if (this.isMultiViewState()) {
            UITableState state = (UITableState)this.getMultiViewState(true);
            state.setColumnMeta(columMeta);
        }
    }

    default public void decodeColumnResizeState(FacesContext context) {
        String columnResizeStateParam = (String)context.getExternalContext().getRequestParameterMap().get(this.getClientId(context) + "_resizableColumnState");
        if (columnResizeStateParam == null) {
            return;
        }
        Map<String, ColumnMeta> columMeta = this.getColumnMeta();
        columMeta.values().stream().forEach(s -> s.setWidth(null));
        String tableWidth = null;
        if (LangUtils.isNotBlank(columnResizeStateParam)) {
            String[] columnStates;
            for (String columnState : columnStates = columnResizeStateParam.split(",")) {
                if (LangUtils.isBlank(columnState)) continue;
                if ((this.getClientId(context) + "_tableWidthState").equals(columnState)) {
                    tableWidth = columnState;
                    this.setWidth(tableWidth);
                    continue;
                }
                int seperatorIndex = columnState.lastIndexOf(95);
                String columnKey = columnState.substring(0, seperatorIndex);
                String width = columnState.substring(seperatorIndex + 1);
                ColumnMeta meta = columMeta.computeIfAbsent(columnKey, k -> new ColumnMeta((String)k));
                meta.setWidth(width);
            }
        }
        if (this.isMultiViewState()) {
            UITableState state = (UITableState)this.getMultiViewState(true);
            state.setWidth(tableWidth);
            state.setColumnMeta(columMeta);
        }
    }

    public String getWidth();

    public void setWidth(String var1);

    default public void decodeColumnDisplayOrderState(FacesContext context) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String columnOrderParam = (String)params.get(this.getClientId(context) + "_columnOrder");
        if (LangUtils.isBlank(columnOrderParam)) {
            return;
        }
        Map<String, ColumnMeta> columMeta = this.getColumnMeta();
        columMeta.values().stream().forEach(s -> s.setDisplayPriority(0));
        String[] columnKeys = columnOrderParam.split(",");
        for (int i = 0; i < columnKeys.length; ++i) {
            String columnKey = columnKeys[i];
            if (LangUtils.isBlank(columnKey)) continue;
            ColumnMeta meta = columMeta.computeIfAbsent(columnKey, k -> new ColumnMeta((String)k));
            meta.setDisplayPriority(i);
        }
        if (this.isMultiViewState()) {
            UITableState ts = (UITableState)this.getMultiViewState(true);
            ts.setColumnMeta(columMeta);
        }
    }

    default public String getColumnsWidthForClientSide() {
        return this.getColumnMeta().entrySet().stream().filter(e -> LangUtils.isNotBlank(((ColumnMeta)e.getValue()).getWidth())).map(e -> (String)e.getKey() + '_' + ((ColumnMeta)e.getValue()).getWidth()).collect(Collectors.joining(","));
    }

    default public String getConvertedFieldValue(FacesContext context, UIColumn column) {
        Object value = UIColumn.createValueExpressionFromField(context, this.getVar(), column.getField()).getValue(context.getELContext());
        Object component = column instanceof DynamicColumn ? ((DynamicColumn)column).getColumns() : (UIComponent)column;
        return ComponentUtils.getConvertedAsString(context, component, value);
    }

    default public boolean isFilteringCurrentlyActive() {
        return this.getFilterByAsMap().values().stream().anyMatch(FilterMeta::isActive);
    }

    default public <C extends UIComponent> C getFilterComponent(UIColumn column) {
        UIComponent filterFacet = column.getFacet("filter");
        if (filterFacet != null) {
            if (filterFacet instanceof ValueHolder) {
                return (C)filterFacet;
            }
            for (UIComponent child : filterFacet.getChildren()) {
                if (!child.isRendered() || !(child instanceof ValueHolder)) continue;
                return (C)child;
            }
        }
        return null;
    }

    default public int compare(FacesContext context, String var, SortMeta sortMeta, Object o1, Object o2, Collator collator, Locale locale) {
        try {
            int result;
            ValueExpression ve = sortMeta.getSortBy();
            context.getExternalContext().getRequestMap().put(var, o1);
            Object value1 = ve.getValue(context.getELContext());
            context.getExternalContext().getRequestMap().put(var, o2);
            Object value2 = ve.getValue(context.getELContext());
            if (sortMeta.getFunction() == null) {
                if (value1 == null && value2 == null) {
                    result = 0;
                } else if (value1 == null) {
                    result = sortMeta.getNullSortOrder();
                } else if (value2 == null) {
                    result = -1 * sortMeta.getNullSortOrder();
                } else if (value1 instanceof String && value2 instanceof String) {
                    if (sortMeta.isCaseSensitiveSort()) {
                        result = collator.compare(value1, value2);
                    } else {
                        String str1 = ((String)value1).toLowerCase(locale);
                        String str2 = ((String)value2).toLowerCase(locale);
                        result = collator.compare(str1, str2);
                    }
                } else {
                    result = ((Comparable)value1).compareTo(value2);
                }
            } else {
                result = (Integer)sortMeta.getFunction().invoke(context.getELContext(), new Object[]{value1, value2});
            }
            return sortMeta.getOrder().isAscending() ? result : -1 * result;
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }
}

