/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.autoupdate;

import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PhaseListener;
import java.util.Map;
import org.primefaces.component.autoupdate.AutoUpdateListener;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.util.LangUtils;

public class AutoUpdatePhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;

    public void afterPhase(PhaseEvent event) {
    }

    public void beforePhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        if (!context.isPostback() || PrimeRequestContext.getCurrentInstance(context).isIgnoreAutoUpdate()) {
            return;
        }
        Map<String, String> infos = AutoUpdateListener.getAutoUpdateComponentInfos(context);
        if (infos != null && !infos.isEmpty()) {
            for (Map.Entry<String, String> entries : infos.entrySet()) {
                String update;
                String clientId = entries.getKey();
                String on = entries.getValue();
                if (on != null && (LangUtils.isBlank(update = (String)context.getExternalContext().getRequestParameterMap().get("jakarta.faces.partial.render")) || !update.contains("@obs(" + on + ")")) || context.getPartialViewContext().getRenderIds().contains(clientId)) continue;
                context.getPartialViewContext().getRenderIds().add(clientId);
            }
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }
}

