/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.badge;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.badge.Badge;
import org.primefaces.functional.IOBiConsumer;
import org.primefaces.model.badge.BadgeModel;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.LangUtils;

public class BadgeRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Badge badge = (Badge)component;
        boolean hasChildren = badge.getChildCount() > 0;
        this.encode(context, badge, null, hasChildren);
    }

    public static <T extends UIComponent> void encode(FacesContext context, Object badge, IOBiConsumer<FacesContext, T> contentRenderer, T component) throws IOException {
        BadgeModel badgeModel = Badge.getBadgeModel(badge);
        if (badgeModel != null) {
            BadgeRenderer badgeRenderer = new BadgeRenderer();
            badgeRenderer.encodeOverlayBegin(context, null);
            contentRenderer.accept(context, (FacesContext)component);
            badgeRenderer.encode(context, null, badgeModel, false);
            badgeRenderer.encodeOverlayEnd(context);
        } else {
            contentRenderer.accept(context, (FacesContext)component);
        }
    }

    protected void encodeOverlayBegin(FacesContext context, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", null);
        if (clientId != null) {
            writer.writeAttribute("id", (Object)clientId, "id");
        }
        writer.writeAttribute("class", (Object)"ui-overlay-badge", "styleClass");
    }

    protected void encodeOverlayEnd(FacesContext context) throws IOException {
        context.getResponseWriter().endElement("div");
    }

    protected void encode(FacesContext context, Badge badge, BadgeModel badgeModel, boolean renderChildren) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        BadgeModel model = badgeModel;
        if (model == null) {
            model = badge.toBadgeModel();
        }
        String clientId = badge == null ? null : badge.getClientId(context);
        String value = model.getValue();
        boolean valueEmpty = LangUtils.isEmpty(value);
        String severity = model.getSeverity();
        String size = model.getSize();
        String styleClass = this.getStyleClassBuilder(context).add("ui-badge ui-widget").add(model.getStyleClass()).add(!valueEmpty && value.length() == 1, "ui-badge-no-gutter").add(valueEmpty, "ui-badge-dot").add(!model.isVisible(), "ui-state-hidden").add("large".equals(size), "ui-badge-lg").add("xlarge".equals(size), "ui-badge-xl").add("info".equals(severity), "ui-badge-info").add("success".equals(severity), "ui-badge-success").add("warning".equals(severity), "ui-badge-warning").add("danger".equals(severity), "ui-badge-danger").build();
        if (renderChildren) {
            this.encodeOverlayBegin(context, clientId);
        }
        writer.startElement("span", null);
        if (!renderChildren && clientId != null) {
            writer.writeAttribute("id", (Object)clientId, "id");
        }
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (model.getStyle() != null) {
            writer.writeAttribute("style", (Object)model.getStyle(), "style");
        }
        if (!valueEmpty && model.isVisible()) {
            writer.write(value);
        }
        writer.endElement("span");
        if (renderChildren) {
            this.renderChildren(context, (UIComponent)badge);
            this.encodeOverlayEnd(context);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

