/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.captcha;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Map;
import org.primefaces.component.captcha.Captcha;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class CaptchaRenderer
extends CoreRenderer {
    private static final String RESPONSE_FIELD = "g-recaptcha-response";

    public void decode(FacesContext context, UIComponent component) {
        Captcha captcha = (Captcha)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        String answer = (String)params.get(RESPONSE_FIELD);
        if (answer != null) {
            captcha.setSubmittedValue(answer);
        } else {
            captcha.setSubmittedValue("");
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Captcha captcha = (Captcha)component;
        String publicKey = this.getPublicKey(context, captcha);
        if (publicKey == null) {
            throw new FacesException("Cannot find public key for catpcha, use primefaces.PUBLIC_CAPTCHA_KEY context-param to define one");
        }
        this.encodeMarkup(context, captcha, publicKey);
        this.encodeScript(context, captcha, publicKey);
    }

    protected void encodeMarkup(FacesContext context, Captcha captcha, String publicKey) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = captcha.getClientId(context);
        captcha.setRequired(true);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, "id");
        if (captcha.getSize() != null && "invisible".equals(captcha.getSize())) {
            writer.writeAttribute("class", (Object)"g-recaptcha", null);
            writer.writeAttribute("data-sitekey", (Object)publicKey, null);
            writer.writeAttribute("data-size", (Object)"invisible", null);
        }
        this.renderDynamicPassThruAttributes(context, (UIComponent)captcha);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Captcha captcha, String publicKey) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Captcha", captcha);
        wb.attr("sitekey", publicKey).attr("theme", captcha.getTheme(), "light").attr("language", captcha.getLanguage(), "en").attr("tabindex", captcha.getTabindex(), 0).attr("callback", captcha.getCallback(), null).attr("expired", captcha.getExpired(), null).attr("size", captcha.getSize(), null);
        wb.finish();
    }

    protected String getPublicKey(FacesContext context, Captcha captcha) {
        return (String)context.getApplication().evaluateExpressionGet(context, context.getExternalContext().getInitParameter("primefaces.PUBLIC_CAPTCHA_KEY"), String.class);
    }
}

