/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import jakarta.el.MethodExpression;
import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.feature.DataTableFeature;

public class DraggableRowsFeature
implements DataTableFeature {
    private static final Logger LOGGER = Logger.getLogger(DraggableRowsFeature.class.getName());
    private static final DraggableRowsFeature INSTANCE = new DraggableRowsFeature();

    private DraggableRowsFeature() {
    }

    public static DraggableRowsFeature getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean shouldDecode(FacesContext context, DataTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_rowreorder");
    }

    @Override
    public boolean shouldEncode(FacesContext context, DataTable table) {
        return false;
    }

    @Override
    public void decode(FacesContext context, DataTable table) {
        MethodExpression me = table.getDraggableRowsFunction();
        if (me != null) {
            me.invoke(context.getELContext(), new Object[]{table});
        } else {
            Map params = context.getExternalContext().getRequestParameterMap();
            String clientId = table.getClientId(context);
            int fromIndex = Integer.parseInt((String)params.get(clientId + "_fromIndex"));
            int toIndex = Integer.parseInt((String)params.get(clientId + "_toIndex"));
            table.setRowIndex(fromIndex);
            Object value = table.getValue();
            if (value instanceof List) {
                List list = (List)value;
                if (toIndex >= fromIndex) {
                    Collections.rotate(list.subList(fromIndex, toIndex + 1), -1);
                } else {
                    Collections.rotate(list.subList(toIndex, fromIndex + 1), 1);
                }
            } else {
                LOGGER.info("Row reordering is only available for list backed datatables. Use rowReorder AJAX behavior with listener and manually handle the model update.");
            }
        }
    }

    @Override
    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        throw new FacesException("DraggableRows Feature should not encode.");
    }
}

