/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.DataTableState;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.component.rowexpansion.RowExpansion;
import org.primefaces.util.LangUtils;

public class RowExpandFeature
implements DataTableFeature {
    private static final RowExpandFeature INSTANCE = new RowExpandFeature();

    private RowExpandFeature() {
    }

    public static RowExpandFeature getInstance() {
        return INSTANCE;
    }

    @Override
    public void decode(FacesContext context, DataTable table) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String rowExpansionState = (String)params.get(table.getClientId(context) + "_rowExpansionState");
        Set<String> rowKeys = Collections.emptySet();
        if (LangUtils.isNotBlank(rowExpansionState)) {
            rowKeys = LangUtils.newLinkedHashSet(rowExpansionState.split(","));
        }
        table.setExpandedRowKeys(rowKeys);
        if (table.isMultiViewState()) {
            DataTableState ts = table.getMultiViewState(true);
            ts.setExpandedRowKeys(rowKeys);
        }
    }

    @Override
    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        int expandedRowIndex = Integer.parseInt((String)params.get(table.getClientId(context) + "_expandedRowIndex"));
        table.loadLazyDataIfRequired();
        this.encodeExpansion(context, renderer, table, expandedRowIndex);
        table.setRowIndex(-1);
    }

    public void encodeExpansion(FacesContext context, DataTableRenderer renderer, DataTable table, int rowIndex) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String rowIndexVar = table.getRowIndexVar();
        RowExpansion rowExpansion = table.getRowExpansion();
        String styleClass = "ui-expanded-row-content ui-widget-content";
        if (rowExpansion.getStyleClass() != null) {
            styleClass = styleClass + " " + rowExpansion.getStyleClass();
        }
        table.setRowIndex(rowIndex);
        if (rowExpansion.isRendered()) {
            if (rowIndexVar != null) {
                context.getExternalContext().getRequestMap().put(rowIndexVar, rowIndex);
            }
            writer.startElement("tr", null);
            writer.writeAttribute("class", (Object)styleClass, null);
            writer.startElement("td", null);
            writer.writeAttribute("colspan", (Object)table.getColumnsCount(), null);
            table.getRowExpansion().encodeAll(context);
            writer.endElement("td");
            writer.endElement("tr");
        }
    }

    @Override
    public boolean shouldDecode(FacesContext context, DataTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_rowExpansionState");
    }

    @Override
    public boolean shouldEncode(FacesContext context, DataTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_rowExpansion");
    }
}

