/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import jakarta.faces.model.ListDataModel;
import java.io.IOException;
import java.text.Collator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.primefaces.PrimeFaces;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.DataTableState;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.component.datatable.feature.FilterFeature;
import org.primefaces.event.data.PostSortEvent;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;

public class SortFeature
implements DataTableFeature {
    private static final SortFeature INSTANCE = new SortFeature();

    private SortFeature() {
    }

    public static SortFeature getInstance() {
        return INSTANCE;
    }

    private boolean isSortRequest(FacesContext context, DataTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_sorting");
    }

    @Override
    public void decode(FacesContext context, DataTable table) {
        String[] sortOrders;
        String clientId = table.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        String sortKey = (String)params.get(clientId + "_sortKey");
        String sortDir = (String)params.get(clientId + "_sortDir");
        String[] sortKeys = sortKey.split(",");
        if (sortKeys.length != (sortOrders = sortDir.split(",")).length) {
            throw new FacesException("sortKeys != sortDirs");
        }
        Map<String, SortMeta> sortByMap = table.getSortByAsMap();
        Map<String, Integer> sortKeysIndexes = IntStream.range(0, sortKeys.length).boxed().collect(Collectors.toMap(i -> sortKeys[i], i -> i));
        for (Map.Entry<String, SortMeta> entry : sortByMap.entrySet()) {
            SortMeta sortMeta = entry.getValue();
            if (sortMeta.isHeaderRow()) continue;
            Integer index = sortKeysIndexes.get(entry.getKey());
            if (index != null) {
                sortMeta.setOrder(SortOrder.of(sortOrders[index]));
                sortMeta.setPriority(index);
                continue;
            }
            sortMeta.setOrder(SortOrder.UNSORTED);
            sortMeta.setPriority(SortMeta.MIN_PRIORITY);
        }
    }

    @Override
    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        Map<String, SortMeta> sortMeta;
        table.setFirst(0);
        if (table.isLazy()) {
            if (table.isLiveScroll()) {
                table.loadLazyScrollData(0, table.getScrollRows());
            } else if (table.isVirtualScroll()) {
                int rows = table.getRows();
                int scrollRows = table.getScrollRows();
                int virtualScrollRows = scrollRows * 2;
                scrollRows = rows == 0 ? virtualScrollRows : Math.min(virtualScrollRows, rows);
                table.loadLazyScrollData(0, scrollRows);
            } else {
                table.loadLazyData();
            }
        } else {
            if (table.isFullUpdateRequest(context)) {
                table.setValue(null);
            }
            this.sort(context, table);
            if (table.isPaginator()) {
                PrimeFaces.current().ajax().addCallbackParam("totalRecords", table.getRowCount());
            }
            if (table.isFilteringCurrentlyActive()) {
                if (table.isFullUpdateRequest(context)) {
                    FilterFeature.getInstance().filter(context, table);
                } else {
                    table.setFilteredValue(this.resolveList(table.getValue()));
                }
            }
        }
        context.getApplication().publishEvent(context, PostSortEvent.class, (Object)table);
        if (!table.isFullUpdateRequest(context)) {
            renderer.encodeTbody(context, table, true);
        }
        if (table.isMultiViewState() && !(sortMeta = table.getSortByAsMap()).isEmpty()) {
            DataTableState ts = table.getMultiViewState(true);
            ts.setSortBy(sortMeta);
            if (table.isPaginator()) {
                ts.setFirst(table.getFirst());
                ts.setRows(table.getRows());
            }
        }
    }

    public void sort(FacesContext context, DataTable table) {
        Object value = table.getValue();
        if (value == null) {
            return;
        }
        List list = this.resolveList(value);
        Locale locale = table.resolveDataLocale();
        String var = table.getVar();
        Collator collator = Collator.getInstance(locale);
        AtomicInteger comparisonResult = new AtomicInteger();
        Map sortBy = table.getActiveSortMeta();
        Object varBackup = context.getExternalContext().getRequestMap().get(var);
        list.sort((o1, o2) -> {
            for (SortMeta sortMeta : sortBy.values()) {
                comparisonResult.set(0);
                if (sortMeta.isHeaderRow()) {
                    int result = SortFeature.compare(context, var, sortMeta, o1, o2, collator, locale);
                    comparisonResult.set(result);
                } else {
                    table.invokeOnColumn(sortMeta.getColumnKey(), column -> {
                        int result = SortFeature.compare(context, var, sortMeta, o1, o2, collator, locale);
                        comparisonResult.set(result);
                    });
                }
                if (comparisonResult.get() == 0) continue;
                return comparisonResult.get();
            }
            return 0;
        });
        if (varBackup == null) {
            context.getExternalContext().getRequestMap().remove(var);
        } else {
            context.getExternalContext().getRequestMap().put(var, varBackup);
        }
    }

    public static int compare(FacesContext context, String var, SortMeta sortMeta, Object o1, Object o2, Collator collator, Locale locale) {
        try {
            int result;
            ValueExpression ve = sortMeta.getSortBy();
            context.getExternalContext().getRequestMap().put(var, o1);
            Object value1 = ve.getValue(context.getELContext());
            context.getExternalContext().getRequestMap().put(var, o2);
            Object value2 = ve.getValue(context.getELContext());
            if (sortMeta.getFunction() == null) {
                if (value1 == null && value2 == null) {
                    result = 0;
                } else if (value1 == null) {
                    result = sortMeta.getNullSortOrder();
                } else if (value2 == null) {
                    result = -1 * sortMeta.getNullSortOrder();
                } else if (value1 instanceof String && value2 instanceof String) {
                    if (sortMeta.isCaseSensitiveSort()) {
                        result = collator.compare(value1, value2);
                    } else {
                        String str1 = ((String)value1).toLowerCase(locale);
                        String str2 = ((String)value2).toLowerCase(locale);
                        result = collator.compare(str1, str2);
                    }
                } else {
                    result = ((Comparable)value1).compareTo(value2);
                }
            } else {
                result = (Integer)sortMeta.getFunction().invoke(context.getELContext(), new Object[]{value1, value2});
            }
            return sortMeta.getOrder().isAscending() ? result : -1 * result;
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
    }

    @Override
    public boolean shouldDecode(FacesContext context, DataTable table) {
        return this.isSortRequest(context, table);
    }

    @Override
    public boolean shouldEncode(FacesContext context, DataTable table) {
        return this.isSortRequest(context, table);
    }

    protected <T> List<T> resolveList(Object value) {
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof ListDataModel) {
            return (List)((ListDataModel)value).getWrappedData();
        }
        throw new FacesException("Data type should be java.util.List or javax.faces.model.ListDataModel instance to be sortable.");
    }
}

