/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dnd;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import org.primefaces.component.dashboard.Dashboard;
import org.primefaces.component.dnd.Draggable;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class DraggableRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String dashboard;
        Draggable draggable = (Draggable)component;
        String clientId = draggable.getClientId(context);
        this.renderDummyMarkup(context, component, clientId);
        UIComponent target = SearchExpressionFacade.resolveComponent(context, (UIComponent)draggable, draggable.getFor(), SearchExpressionUtils.SET_PARENT_FALLBACK);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Draggable", draggable).attr("target", target.getClientId(context)).attr("cursor", draggable.getCursor()).attr("disabled", draggable.isDisabled(), false).attr("axis", draggable.getAxis(), null).attr("containment", draggable.getContainment(), null).attr("appendTo", SearchExpressionFacade.resolveClientId(context, (UIComponent)draggable, draggable.getAppendTo(), SearchExpressionUtils.SET_RESOLVE_CLIENT_SIDE), null).attr("helper", draggable.getHelper(), null).attr("zIndex", draggable.getZindex(), -1).attr("handle", draggable.getHandle(), null).attr("opacity", draggable.getOpacity(), 1.0).attr("stack", draggable.getStack(), null).attr("scope", draggable.getScope(), null).attr("cancel", draggable.getCancel(), null);
        wb.callback("onStart", "function(event,ui)", draggable.getOnStart()).callback("onStop", "function(event,ui)", draggable.getOnStop()).callback("onDrag", "function(event,ui)", draggable.getOnDrag());
        if (draggable.isRevert()) {
            wb.attr("revert", "invalid");
        }
        if (draggable.getGrid() != null) {
            wb.append(",grid:[").append(draggable.getGrid()).append("]");
        }
        if (draggable.isSnap()) {
            wb.attr("snap", true).attr("snapTolerance", draggable.getSnapTolerance()).attr("snapMode", draggable.getSnapMode(), null);
        }
        if ((dashboard = draggable.getDashboard()) != null) {
            Dashboard db = (Dashboard)SearchExpressionFacade.resolveComponent(context, (UIComponent)draggable, dashboard);
            wb.selectorAttr("connectToSortable", "#" + db.getClientId(context) + " .ui-dashboard-column");
        }
        wb.finish();
    }
}

