/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.filedownload;

import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.component.StateHolder;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.primefaces.PrimeFaces;
import org.primefaces.model.StreamedContent;
import org.primefaces.shaded.commons.io.IOUtils;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.DynamicContentSrcBuilder;
import org.primefaces.util.LangUtils;
import org.primefaces.util.ResourceUtils;

public class FileDownloadActionListener
implements ActionListener,
StateHolder {
    private ValueExpression value;
    private ValueExpression contentDisposition;
    private ValueExpression monitorKey;

    public FileDownloadActionListener() {
        ResourceUtils.addComponentResource(FacesContext.getCurrentInstance(), "filedownload/filedownload.js");
    }

    public FileDownloadActionListener(ValueExpression value, ValueExpression contentDisposition, ValueExpression monitorKey) {
        this();
        this.value = value;
        this.contentDisposition = contentDisposition;
        this.monitorKey = monitorKey;
    }

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        ELContext elContext = context.getELContext();
        StreamedContent content = (StreamedContent)this.value.getValue(elContext);
        if (content == null) {
            return;
        }
        if (PrimeFaces.current().isAjaxRequest()) {
            this.ajaxDownload(context, content);
        } else {
            this.regularDownload(context, content);
        }
    }

    protected void ajaxDownload(FacesContext context, StreamedContent content) {
        String uri = DynamicContentSrcBuilder.buildStreaming(context, this.value, false);
        String monitorKeyCookieName = ResourceUtils.getMonitorKeyCookieName(context, this.monitorKey);
        PrimeFaces.current().executeScript(String.format("PrimeFaces.download('%s', '%s', '%s', '%s')", uri, content.getContentType(), content.getName(), monitorKeyCookieName));
    }

    protected void regularDownload(FacesContext context, StreamedContent content) {
        ExternalContext externalContext = context.getExternalContext();
        externalContext.setResponseContentType(content.getContentType());
        String contentDispositionValue = this.contentDisposition != null ? (String)this.contentDisposition.getValue(context.getELContext()) : "attachment";
        externalContext.setResponseHeader("Content-Disposition", ComponentUtils.createContentDisposition(contentDispositionValue, content.getName()));
        String monitorKeyCookieName = ResourceUtils.getMonitorKeyCookieName(context, this.monitorKey);
        HashMap<String, Object> cookieOptions = new HashMap<String, Object>(4);
        cookieOptions.put("path", LangUtils.isBlank(externalContext.getRequestContextPath()) ? "/" : externalContext.getRequestContextPath());
        ResourceUtils.addResponseCookie(context, monitorKeyCookieName, "true", cookieOptions);
        ResourceUtils.addNoCacheControl(externalContext);
        if (content.getContentLength() != null) {
            externalContext.setResponseContentLength(content.getContentLength().intValue());
        }
        try {
            if (content.getWriter() != null) {
                content.getWriter().accept(externalContext.getResponseOutputStream());
            } else {
                try (InputStream is = content.getStream().get();){
                    IOUtils.copyLarge(is, externalContext.getResponseOutputStream());
                }
            }
            if (!externalContext.isResponseCommitted()) {
                externalContext.setResponseStatus(200);
            }
            externalContext.responseFlushBuffer();
            context.responseComplete();
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public boolean isTransient() {
        return false;
    }

    public void setTransient(boolean value) {
    }

    public void restoreState(FacesContext facesContext, Object state) {
        Object[] values = (Object[])state;
        this.value = (ValueExpression)values[0];
        this.contentDisposition = (ValueExpression)values[1];
        this.monitorKey = (ValueExpression)values[2];
    }

    public Object saveState(FacesContext facesContext) {
        Object[] values = new Object[]{this.value, this.contentDisposition, this.monitorKey};
        return values;
    }
}

