/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.inputtext;

import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.inputtext.InputText;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class InputTextRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        InputText inputText = (InputText)component;
        if (!this.shouldDecode((UIInput)inputText)) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)inputText);
        String clientId = inputText.getClientId(context);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(clientId);
        if (submittedValue != null) {
            int maxlength = inputText.getMaxlength();
            if (maxlength > 0 && submittedValue.length() > maxlength) {
                submittedValue = LangUtils.substring(submittedValue, 0, maxlength);
            }
            inputText.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        InputText inputText = (InputText)component;
        this.encodeMarkup(context, inputText);
        this.encodeScript(context, inputText);
    }

    protected void encodeScript(FacesContext context, InputText inputText) throws IOException {
        String counter = inputText.getCounter();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("InputText", inputText).attr("maxlength", inputText.getMaxlength(), Integer.MIN_VALUE);
        if (counter != null) {
            UIComponent counterComponent = SearchExpressionFacade.resolveComponent(context, (UIComponent)inputText, counter);
            wb.attr("counter", counterComponent.getClientId(context)).attr("counterTemplate", inputText.getCounterTemplate(), null).attr("countBytesAsChars", inputText.getCountBytesAsChars());
        }
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, InputText inputText) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputText.getClientId(context);
        writer.startElement("input", (UIComponent)inputText);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("type", (Object)inputText.getType(), null);
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)inputText);
        if (valueToRender != null) {
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        if (inputText.getStyle() != null) {
            writer.writeAttribute("style", (Object)inputText.getStyle(), null);
        }
        writer.writeAttribute("class", (Object)this.createStyleClass((UIInput)inputText, "ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all"), "styleClass");
        this.renderAccessibilityAttributes(context, (UIInput)inputText);
        this.renderRTLDirection(context, inputText);
        this.renderPassThruAttributes(context, (UIComponent)inputText, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)inputText, HTML.INPUT_TEXT_EVENTS);
        this.renderValidationMetadata(context, (EditableValueHolder)inputText);
        writer.endElement("input");
    }
}

