/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.lightbox;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import org.primefaces.component.lightbox.LightBox;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.WidgetBuilder;

public class LightBoxRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        LightBox lb = (LightBox)component;
        this.encodeMarkup(context, (UIComponent)lb);
        this.encodeScript(context, (UIComponent)lb);
    }

    public void encodeMarkup(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        LightBox lb = (LightBox)component;
        String clientId = lb.getClientId(context);
        UIComponent inline = lb.getFacet("inline");
        writer.startElement("div", (UIComponent)lb);
        writer.writeAttribute("id", (Object)clientId, "id");
        if (lb.getStyle() != null) {
            writer.writeAttribute("style", (Object)lb.getStyle(), null);
        }
        if (lb.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)lb.getStyleClass(), null);
        }
        this.renderChildren(context, (UIComponent)lb);
        if (ComponentUtils.shouldRenderFacet(inline)) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-lightbox-inline ui-helper-hidden", null);
            inline.encodeAll(context);
            writer.endElement("div");
        }
        writer.endElement("div");
    }

    public void encodeScript(FacesContext context, UIComponent component) throws IOException {
        LightBox lb = (LightBox)component;
        String mode = "image";
        if (lb.getFacet("inline") != null) {
            mode = "inline";
        } else if (lb.isIframe()) {
            mode = "iframe";
        }
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("LightBox", lb).attr("mode", mode).attr("width", lb.getWidth(), null).attr("height", lb.getHeight(), null).attr("visible", lb.isVisible(), false).attr("blockScroll", lb.isBlockScroll(), false).attr("iframeTitle", lb.getIframeTitle(), null).callback("onShow", "function()", lb.getOnShow()).callback("onHide", "function()", lb.getOnHide());
        wb.finish();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

