/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.photocam;

import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.event.PhaseId;
import jakarta.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.util.Map;
import org.primefaces.component.photocam.PhotoCam;
import org.primefaces.event.CaptureEvent;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class PhotoCamRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        PhotoCam cam = (PhotoCam)component;
        String dataParam = cam.getClientId(context) + "_data";
        Map params = context.getExternalContext().getRequestParameterMap();
        if (params.containsKey(dataParam)) {
            String image = (String)params.get(dataParam);
            image = image.substring(22);
            CaptureEvent event = new CaptureEvent((UIComponent)cam, DatatypeConverter.parseBase64Binary((String)image), image);
            event.setPhaseId(PhaseId.INVOKE_APPLICATION);
            cam.queueEvent(event);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        PhotoCam cam = (PhotoCam)component;
        this.encodeMarkup(context, cam);
        this.encodeScript(context, cam);
    }

    protected void encodeMarkup(FacesContext context, PhotoCam cam) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = cam.getClientId(context);
        String style = cam.getStyle();
        String styleClass = cam.getStyleClass();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, PhotoCam cam) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("PhotoCam", cam).attr("width", cam.getWidth(), 320).attr("height", cam.getHeight(), 240).attr("photoWidth", cam.getPhotoWidth(), 320).attr("photoHeight", cam.getPhotoHeight(), 240).attr("format", cam.getFormat(), null).attr("jpegQuality", cam.getJpegQuality(), 90).attr("autoStart", cam.isAutoStart(), true).attr("device", cam.getDevice(), null).callback("onCameraError", "function(errorObj)", cam.getOnCameraError());
        if (cam.getUpdate() != null) {
            wb.attr("update", SearchExpressionFacade.resolveClientIds(context, (UIComponent)cam, cam.getUpdate(), SearchExpressionUtils.SET_RESOLVE_CLIENT_SIDE));
        }
        if (cam.getProcess() != null) {
            wb.attr("process", SearchExpressionFacade.resolveClientIds(context, (UIComponent)cam, cam.getProcess(), SearchExpressionUtils.SET_RESOLVE_CLIENT_SIDE));
        }
        wb.finish();
    }
}

