/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.spinner;

import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.math.BigInteger;
import org.primefaces.component.spinner.Spinner;
import org.primefaces.component.spinner.SpinnerBase;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class SpinnerRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Spinner spinner = (Spinner)component;
        if (!this.shouldDecode((UIInput)spinner)) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)spinner);
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(spinner.getClientId(context) + "_input");
        if (submittedValue != null) {
            String prefix = spinner.getPrefix();
            String suffix = spinner.getSuffix();
            if (prefix != null && submittedValue.startsWith(prefix)) {
                submittedValue = submittedValue.substring(prefix.length());
            }
            if (suffix != null && submittedValue.endsWith(suffix)) {
                submittedValue = submittedValue.substring(0, submittedValue.length() - suffix.length());
            }
            if (LangUtils.isNotEmpty(spinner.getThousandSeparator())) {
                submittedValue = submittedValue.replace(spinner.getThousandSeparator(), "");
            }
            if (LangUtils.isNotEmpty(spinner.getDecimalSeparator())) {
                submittedValue = submittedValue.replace(spinner.getDecimalSeparator(), ".");
            }
        }
        spinner.setSubmittedValue(submittedValue);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Spinner spinner = (Spinner)component;
        this.encodeMarkup(context, spinner);
        this.encodeScript(context, spinner);
    }

    protected void encodeScript(FacesContext context, Spinner spinner) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        Object value = spinner.getValue();
        String defaultDecimalPlaces = null;
        if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof BigInteger) {
            defaultDecimalPlaces = "0";
        }
        String decimalPlaces = this.isValueBlank(spinner.getDecimalPlaces()) ? defaultDecimalPlaces : spinner.getDecimalPlaces();
        wb.init("Spinner", spinner).attr("step", spinner.getStepFactor(), 1.0).attr("round", spinner.isRound(), false).attr("min", spinner.getMin(), Double.MIN_VALUE).attr("max", spinner.getMax(), Double.MAX_VALUE).attr("prefix", spinner.getPrefix(), null).attr("suffix", spinner.getSuffix(), null).attr("required", spinner.isRequired(), false).attr("rotate", spinner.isRotate(), false).attr("decimalPlaces", decimalPlaces, null).attr(SpinnerBase.PropertyKeys.thousandSeparator.name(), spinner.getThousandSeparator()).attr(SpinnerBase.PropertyKeys.decimalSeparator.name(), spinner.getDecimalSeparator());
        wb.finish();
    }

    protected void encodeMarkup(FacesContext context, Spinner spinner) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = spinner.getClientId(context);
        String styleClass = this.getStyleClassBuilder(context).add(this.createStyleClass((UIInput)spinner, "ui-spinner ui-widget ui-corner-all")).add("ui-spinner-" + this.getButtonsClassSuffix(spinner)).build();
        writer.startElement("span", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (spinner.getStyle() != null) {
            writer.writeAttribute("style", (Object)spinner.getStyle(), null);
        }
        this.encodeInput(context, spinner);
        boolean valid = spinner.isValid();
        String upButtonClass = this.getButtonClass(context, "ui-spinner-button ui-spinner-up ui-corner-tr ui-button ui-widget ui-state-default ui-button-text-only", spinner.getUpButtonStyleClass(), valid);
        String downButtonClass = this.getButtonClass(context, "ui-spinner-button ui-spinner-down ui-corner-br ui-button ui-widget ui-state-default ui-button-text-only", spinner.getDownButtonStyleClass(), valid);
        boolean stacked = "stacked".equals(spinner.getButtons());
        String upIconClass = this.getIconClass(context, spinner.getUpIcon(), stacked ? "ui-icon-triangle-1-n" : "pi pi-plus");
        String downIconClass = this.getIconClass(context, spinner.getDownIcon(), stacked ? "ui-icon-triangle-1-s" : "pi pi-minus");
        this.encodeButton(context, upButtonClass, upIconClass);
        this.encodeButton(context, downButtonClass, downIconClass);
        writer.endElement("span");
    }

    protected String getButtonsClassSuffix(Spinner spinner) {
        switch (spinner.getButtons()) {
            case "horizontal": {
                return "horizontal";
            }
            case "horizontal-after": {
                return "horizontal-after";
            }
            case "vertical": {
                return "vertical";
            }
        }
        return "stacked";
    }

    protected String getButtonClass(FacesContext context, String fixedStyleClass, String styleClass, boolean valid) {
        return this.getStyleClassBuilder(context).add(fixedStyleClass).add(styleClass).add(!valid, "ui-state-error").build();
    }

    protected String getIconClass(FacesContext context, String custom, String fallback) {
        return this.getStyleClassBuilder(context).add("ui-icon ui-c").addOrElse(custom, fallback).build();
    }

    protected void encodeInput(FacesContext context, Spinner spinner) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = spinner.getClientId(context) + "_input";
        String inputClass = this.createStyleClass((UIInput)spinner, null, "ui-spinner-input ui-inputfield ui-state-default ui-corner-all");
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("class", (Object)inputClass, null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        String valueToRender = ComponentUtils.getValueToRender(context, (UIComponent)spinner);
        if (valueToRender != null) {
            valueToRender = spinner.getPrefix() != null ? spinner.getPrefix() + valueToRender : valueToRender;
            valueToRender = spinner.getSuffix() != null ? valueToRender + spinner.getSuffix() : valueToRender;
            writer.writeAttribute("value", (Object)valueToRender, null);
        }
        this.renderAccessibilityAttributes(context, (UIInput)spinner);
        this.renderPassThruAttributes(context, (UIComponent)spinner, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)spinner, HTML.INPUT_TEXT_EVENTS);
        this.renderValidationMetadata(context, (EditableValueHolder)spinner);
        writer.endElement("input");
    }

    protected void encodeButton(FacesContext context, String styleClass, String iconClass) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", null);
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconClass, null);
        writer.endElement("span");
        writer.endElement("span");
        writer.endElement("a");
    }

    @Override
    public String getHighlighter() {
        return "spinner";
    }
}

