/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.texteditor;

import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.ConverterException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.primefaces.component.texteditor.TextEditor;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.HtmlSanitizer;
import org.primefaces.util.WidgetBuilder;

public class TextEditorRenderer
extends InputRenderer {
    private static final Logger LOGGER = Logger.getLogger(TextEditorRenderer.class.getName());

    public void decode(FacesContext context, UIComponent component) {
        TextEditor editor = (TextEditor)component;
        if (!this.shouldDecode(editor)) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)editor);
        String inputParam = editor.getClientId(context) + "_input";
        Map params = context.getExternalContext().getRequestParameterMap();
        String value = this.sanitizeHtml(context, editor, (String)params.get(inputParam));
        if ("<br/>".equals(value)) {
            value = "";
        }
        editor.setSubmittedValue(value);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        TextEditor editor = (TextEditor)component;
        this.checkSecurity(facesContext, editor);
        this.encodeMarkup(facesContext, editor);
        this.encodeScript(facesContext, editor);
    }

    protected void encodeMarkup(FacesContext context, TextEditor editor) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = editor.getClientId(context);
        String valueToRender = this.sanitizeHtml(context, editor, ComponentUtils.getValueToRender(context, (UIComponent)editor));
        String inputId = clientId + "_input";
        String editorId = clientId + "_editor";
        UIComponent toolbar = editor.getFacet("toolbar");
        String style = editor.getStyle();
        String styleClass = editor.getStyleClass();
        styleClass = styleClass != null ? "ui-texteditor " + styleClass : "ui-texteditor";
        styleClass = !editor.isDisabled() ? styleClass : styleClass + " ui-state-disabled";
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (editor.isToolbarVisible() && ComponentUtils.shouldRenderFacet(toolbar)) {
            writer.startElement("div", (UIComponent)editor);
            writer.writeAttribute("id", (Object)(clientId + "_toolbar"), null);
            writer.writeAttribute("class", (Object)"ui-editor-toolbar", null);
            toolbar.encodeAll(context);
            writer.endElement("div");
        }
        writer.startElement("div", (UIComponent)editor);
        writer.writeAttribute("id", (Object)editorId, null);
        if (valueToRender != null) {
            writer.write(valueToRender);
        }
        writer.endElement("div");
        this.renderHiddenInput(context, inputId, valueToRender, editor.isDisabled());
        writer.endElement("div");
    }

    private void encodeScript(FacesContext context, TextEditor editor) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("TextEditor", editor).attr("toolbarVisible", editor.isToolbarVisible()).attr("readOnly", editor.isReadonly(), false).attr("disabled", editor.isDisabled(), false).attr("placeholder", editor.getPlaceholder(), null).attr("height", editor.getHeight(), Integer.MIN_VALUE);
        List formats = editor.getFormats();
        if (formats != null) {
            wb.append(",formats:[");
            for (int i = 0; i < formats.size(); ++i) {
                if (i != 0) {
                    wb.append(",");
                }
                wb.append("\"" + EscapeUtils.forJavaScript((String)formats.get(i)) + "\"");
            }
            wb.append("]");
        }
        this.encodeClientBehaviors(context, editor);
        wb.finish();
    }

    @Override
    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return ComponentUtils.getConvertedValue(context, component, submittedValue);
    }

    private void checkSecurity(FacesContext context, TextEditor editor) {
        boolean sanitizerAvailable = PrimeApplicationContext.getCurrentInstance(context).getEnvironment().isHtmlSanitizerAvailable();
        if (editor.isSecure() && !sanitizerAvailable) {
            throw new FacesException("TextEditor component is marked secure='true' but the HTML Sanitizer was not found on the classpath. Either add the HTML sanitizer to the classpath per the documentation or mark secure='false' if you would like to use the component without the sanitizer.");
        }
    }

    private String sanitizeHtml(FacesContext context, TextEditor editor, String value) {
        String result = value;
        if (editor.isSecure() && PrimeApplicationContext.getCurrentInstance(context).getEnvironment().isHtmlSanitizerAvailable()) {
            result = HtmlSanitizer.sanitizeHtml(value, editor.isAllowBlocks(), editor.isAllowFormatting(), editor.isAllowLinks(), editor.isAllowStyles(), editor.isAllowImages());
        } else if (!(editor.isAllowBlocks() && editor.isAllowFormatting() && editor.isAllowLinks() && editor.isAllowStyles() && editor.isAllowImages())) {
            LOGGER.warning("HTML sanitizer not available - skip sanitizing....");
        }
        return result;
    }
}

