/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.treetable.feature;

import jakarta.el.ELContext;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.PhaseId;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.primefaces.PrimeFaces;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.component.treetable.TreeTableRenderer;
import org.primefaces.component.treetable.TreeTableState;
import org.primefaces.component.treetable.feature.SortFeature;
import org.primefaces.component.treetable.feature.TreeTableFeature;
import org.primefaces.event.data.PostFilterEvent;
import org.primefaces.model.CheckboxTreeNode;
import org.primefaces.model.DefaultTreeNode;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.TreeNode;
import org.primefaces.model.filter.FilterConstraint;
import org.primefaces.model.filter.FunctionFilterConstraint;
import org.primefaces.util.LocaleUtils;

public class FilterFeature
implements TreeTableFeature {
    private static final Logger LOGGER = Logger.getLogger(FilterFeature.class.getName());
    private static final FilterFeature INSTANCE = new FilterFeature();

    private FilterFeature() {
    }

    public static FilterFeature getInstance() {
        return INSTANCE;
    }

    private boolean isFilterRequest(FacesContext context, TreeTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_filtering");
    }

    @Override
    public boolean shouldDecode(FacesContext context, TreeTable table) {
        return context.getCurrentPhaseId() == PhaseId.PROCESS_VALIDATIONS && this.isFilterRequest(context, table);
    }

    @Override
    public boolean shouldEncode(FacesContext context, TreeTable table) {
        return this.isFilterRequest(context, table);
    }

    @Override
    public void decode(FacesContext context, TreeTable table) {
        Map<String, FilterMeta> filterBy = table.getFilterByAsMap();
        table.updateFilterByValuesWithFilterRequest(context, filterBy);
        table.updateFilteredValue(context, null);
        table.setValue(null);
        table.setFirst(0);
        Map params = context.getExternalContext().getRequestParameterMap();
        String clientId = table.getClientId(context);
        String rppValue = (String)params.get(clientId + "_rppDD");
        if (rppValue != null && !"*".equals(rppValue)) {
            table.setRows(Integer.parseInt(rppValue));
        }
        if (table.isMultiViewState()) {
            TreeTableState ts = table.getMultiViewState(true);
            ts.setFilterBy(filterBy);
            if (table.isPaginator()) {
                ts.setFirst(table.getFirst());
                ts.setRows(table.getRows());
            }
        }
    }

    @Override
    public void encode(FacesContext context, TreeTableRenderer renderer, TreeTable table) throws IOException {
        this.filter(context, table, table.getValue());
        if (table.isSortingCurrentlyActive()) {
            SortFeature.getInstance().sort(context, table);
        }
        context.getApplication().publishEvent(context, PostFilterEvent.class, (Object)table);
        renderer.encodeTbody(context, table, table.getValue(), true);
    }

    public void filter(FacesContext context, TreeTable tt, TreeNode root) {
        Map<String, FilterMeta> filterBy = tt.getFilterByAsMap();
        if (filterBy.isEmpty()) {
            return;
        }
        Locale filterLocale = LocaleUtils.getCurrentLocale(context);
        List<String> filteredRowKeys = tt.getFilteredRowKeys();
        filteredRowKeys.clear();
        this.collectFilteredRowKeys(context, tt, root, root, filterBy, filterLocale, filteredRowKeys);
        TreeNode filteredValue = this.cloneTreeNode(tt, root, root.getParent());
        this.createFilteredValueFromRowKeys(tt, root, filteredValue, filteredRowKeys);
        tt.updateFilteredValue(context, filteredValue);
        tt.setValue(filteredValue);
        tt.setRowKey(root, null);
        if (tt.isPaginator()) {
            PrimeFaces.current().ajax().addCallbackParam("totalRecords", filteredValue.getChildCount());
        }
        if (tt.getSelectedRowKeysAsString() != null) {
            PrimeFaces.current().ajax().addCallbackParam("selection", tt.getSelectedRowKeysAsString());
        }
    }

    protected void collectFilteredRowKeys(FacesContext context, TreeTable tt, TreeNode<?> root, TreeNode<?> node, Map<String, FilterMeta> filterBy, Locale filterLocale, List<String> filteredRowKeys) {
        ELContext elContext = context.getELContext();
        FilterMeta globalFilter = filterBy.get("globalFilter");
        boolean hasGlobalFilterFunction = globalFilter != null && globalFilter.getConstraint() instanceof FunctionFilterConstraint;
        int childCount = node.getChildCount();
        AtomicBoolean localMatch = new AtomicBoolean();
        AtomicBoolean globalMatch = new AtomicBoolean();
        for (int i = 0; i < childCount; ++i) {
            TreeNode<?> childNode = node.getChildren().get(i);
            String rowKey = childNode.getRowKey();
            tt.setRowKey(root, rowKey);
            localMatch.set(true);
            globalMatch.set(false);
            if (hasGlobalFilterFunction) {
                globalMatch.set(globalFilter.getConstraint().isMatching(context, childNode, globalFilter.getFilterValue(), filterLocale));
            }
            tt.forEachColumn(column -> {
                Object filterValue;
                FilterConstraint constraint;
                FilterMeta filter = (FilterMeta)filterBy.get(column.getColumnKey((UIComponent)tt, rowKey));
                if (filter == null || filter.isGlobalFilter()) {
                    return true;
                }
                Object columnValue = filter.getLocalValue(elContext, (UIColumn)column);
                if (globalFilter != null && globalFilter.isActive() && !globalMatch.get() && !hasGlobalFilterFunction) {
                    constraint = globalFilter.getConstraint();
                    filterValue = globalFilter.getFilterValue();
                    globalMatch.set(constraint.isMatching(context, columnValue, filterValue, filterLocale));
                }
                if (!filter.isActive()) {
                    return true;
                }
                constraint = filter.getConstraint();
                filterValue = filter.getFilterValue();
                localMatch.set(constraint.isMatching(context, columnValue, filterValue, filterLocale));
                return localMatch.get();
            });
            boolean matches = localMatch.get();
            if (globalFilter != null && globalFilter.isActive()) {
                boolean bl = matches = matches && globalMatch.get();
            }
            if (matches) {
                filteredRowKeys.add(rowKey);
            }
            this.collectFilteredRowKeys(context, tt, root, childNode, filterBy, filterLocale, filteredRowKeys);
        }
    }

    private void createFilteredValueFromRowKeys(TreeTable tt, TreeNode<?> node, TreeNode<?> filteredNode, List<String> filteredRowKeys) {
        int childCount = node.getChildCount();
        block0: for (int i = 0; i < childCount; ++i) {
            TreeNode<?> childNode = node.getChildren().get(i);
            String rowKeyOfChildNode = childNode.getRowKey();
            for (String rk : filteredRowKeys) {
                if (!rk.equals(rowKeyOfChildNode) && !rk.startsWith(rowKeyOfChildNode + "_") && !rowKeyOfChildNode.startsWith(rk + "_")) continue;
                TreeNode newNode = this.cloneTreeNode(tt, childNode, filteredNode);
                if (rk.startsWith(rowKeyOfChildNode + "_")) {
                    newNode.setExpanded(true);
                }
                this.createFilteredValueFromRowKeys(tt, childNode, newNode, filteredRowKeys);
                continue block0;
            }
        }
    }

    protected TreeNode cloneTreeNode(TreeTable tt, TreeNode<?> node, TreeNode<?> parent) {
        TreeNode<?> clone = null;
        if (CheckboxTreeNode.class.equals(node.getClass())) {
            clone = new CheckboxTreeNode(node.getType(), node.getData(), parent);
        } else if (DefaultTreeNode.class.equals(node.getClass())) {
            clone = new DefaultTreeNode(node.getType(), node.getData(), parent);
        }
        if (clone == null && tt.isCloneOnFilter()) {
            if (node instanceof Cloneable) {
                try {
                    Method cloneMethod = node.getClass().getMethod("clone", new Class[0]);
                    if (cloneMethod != null) {
                        cloneMethod.setAccessible(true);
                        clone = (TreeNode)cloneMethod.invoke(node, new Object[0]);
                    }
                }
                catch (NoSuchMethodException e) {
                    LOGGER.warning(node.getClass().getName() + " declares Cloneable but no clone() method found!");
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LOGGER.warning(node.getClass().getName() + "#clone() not accessible!");
                }
            } else {
                Constructor<?> ctor2;
                try {
                    ctor2 = node.getClass().getConstructor(node.getClass());
                    clone = (TreeNode)ctor2.newInstance(node);
                }
                catch (NoSuchMethodException ctor2) {
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    LOGGER.warning("Could not clone " + node.getClass().getName() + " via public " + node.getClass().getSimpleName() + "() constructor!");
                }
                if (clone == null) {
                    try {
                        ctor2 = node.getClass().getConstructor(String.class, Object.class, TreeNode.class);
                        clone = (TreeNode)ctor2.newInstance(node.getType(), node.getData(), parent);
                    }
                    catch (NoSuchMethodException ctor3) {
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        LOGGER.warning("Could not clone " + node.getClass().getName() + " via public " + node.getClass().getSimpleName() + "(String type, Object data, TreeNode parent) constructor!");
                    }
                }
            }
        }
        if (clone == null) {
            clone = node instanceof CheckboxTreeNode ? new CheckboxTreeNode(node.getType(), node.getData(), parent) : new DefaultTreeNode(node.getType(), node.getData(), parent);
        }
        clone.setSelectable(node.isSelectable());
        clone.setSelected(node.isSelected());
        clone.setExpanded(node.isExpanded());
        return clone;
    }
}

