/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.treetable.feature;

import jakarta.faces.FacesException;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import org.primefaces.component.treetable.TreeTable;
import org.primefaces.component.treetable.TreeTableRenderer;
import org.primefaces.component.treetable.feature.TreeTableFeature;

public class ResizableColumnsFeature
implements TreeTableFeature {
    private static final ResizableColumnsFeature INSTANCE = new ResizableColumnsFeature();

    private ResizableColumnsFeature() {
    }

    public static ResizableColumnsFeature getInstance() {
        return INSTANCE;
    }

    @Override
    public void decode(FacesContext context, TreeTable table) {
        table.decodeColumnResizeState(context);
    }

    @Override
    public void encode(FacesContext context, TreeTableRenderer renderer, TreeTable table) throws IOException {
        throw new FacesException("ResizableColumnsFeature should not encode.");
    }

    @Override
    public boolean shouldDecode(FacesContext context, TreeTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_resizableColumnState");
    }

    @Override
    public boolean shouldEncode(FacesContext context, TreeTable table) {
        return false;
    }
}

