/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.primefaces.model.TreeNode;
import org.primefaces.model.TreeNodeList;

public class TreeNodeChildren<T>
extends TreeNodeList<T> {
    private static final long serialVersionUID = 1L;
    private TreeNode<T> parent;

    public TreeNodeChildren(TreeNode<T> parent) {
        this.parent = parent;
    }

    private void eraseParent(TreeNode<T> node) {
        TreeNode<T> parentNode = node.getParent();
        if (parentNode != null) {
            parentNode.getChildren().remove(node);
            node.setParent(null);
        }
    }

    @Override
    public boolean add(TreeNode<T> node) {
        if (node == null) {
            throw new NullPointerException();
        }
        this.eraseParent(node);
        boolean result = super.add(node);
        node.setParent(this.parent);
        this.updateRowKeys(this.parent.getChildCount() - 1, this.parent);
        return result;
    }

    @Override
    public void add(int index, TreeNode<T> node) {
        if (node == null) {
            throw new NullPointerException();
        }
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.eraseParent(node);
        super.add(index, node);
        node.setParent(this.parent);
        this.updateRowKeys(index, this.parent);
    }

    @Override
    public boolean addAll(Collection<? extends TreeNode<T>> collection) {
        Iterator<TreeNode<T>> elements = new ArrayList<TreeNode<T>>(collection).iterator();
        int size = this.size();
        boolean changed = false;
        while (elements.hasNext()) {
            TreeNode<T> node = elements.next();
            if (node == null) {
                throw new NullPointerException();
            }
            this.eraseParent(node);
            super.add(node);
            node.setParent(this.parent);
            changed = true;
        }
        if (changed) {
            this.updateRowKeys(size, this.parent);
        }
        return changed;
    }

    @Override
    public boolean addAll(int index, Collection<? extends TreeNode<T>> collection) {
        Iterator<TreeNode<T>> elements = new ArrayList<TreeNode<T>>(collection).iterator();
        boolean changed = false;
        while (elements.hasNext()) {
            TreeNode<T> node = elements.next();
            if (node == null) {
                throw new NullPointerException();
            }
            this.eraseParent(node);
            super.add(index++, node);
            node.setParent(this.parent);
            changed = true;
        }
        if (changed) {
            this.updateRowKeys(index, this.parent);
        }
        return changed;
    }

    @Override
    public TreeNode set(int index, TreeNode node) {
        if (node == null) {
            throw new NullPointerException();
        }
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.parent.equals(node.getParent())) {
            this.eraseParent(node);
        }
        TreeNode previous = (TreeNode)this.get(index);
        super.set(index, node);
        previous.setParent(null);
        node.setParent(this.parent);
        this.updateRowKeys(this.parent, node, index);
        return previous;
    }

    @Override
    public TreeNode setSibling(int index, TreeNode node) {
        if (node == null) {
            throw new NullPointerException();
        }
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.parent.equals(node.getParent())) {
            this.eraseParent(node);
        }
        TreeNode previous = (TreeNode)this.get(index);
        super.set(index, node);
        node.setParent(this.parent);
        this.updateRowKeys(this.parent, node, index);
        return previous;
    }

    @Override
    public TreeNode remove(int index) {
        TreeNode node = (TreeNode)this.get(index);
        node.setParent(null);
        super.remove(index);
        this.updateRowKeys(index, this.parent);
        return node;
    }

    @Override
    public boolean remove(Object object) {
        TreeNode node = (TreeNode)object;
        if (node == null) {
            throw new NullPointerException();
        }
        if (super.indexOf(node) != -1) {
            node.clearParent();
        }
        int index = super.indexOf(node);
        if (super.remove(node)) {
            this.updateRowKeys(index, this.parent);
            return true;
        }
        return false;
    }

    private void updateRowKeys(TreeNode<?> node) {
        int childCount = node.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                TreeNode<?> childNode = node.getChildren().get(i);
                this.updateRowKeys(node, childNode, i);
            }
        }
    }

    private void updateRowKeys(int index, TreeNode<?> node) {
        int childCount = node.getChildCount();
        if (childCount > 0) {
            for (int i = index; i < childCount; ++i) {
                TreeNode<?> childNode = node.getChildren().get(i);
                this.updateRowKeys(node, childNode, i);
            }
        }
    }

    private void updateRowKeys(TreeNode<?> node, TreeNode<?> childNode, int i) {
        String childRowKey = node.getParent() == null ? String.valueOf(i) : node.getRowKey() + "_" + i;
        childNode.setRowKey(childRowKey);
        this.updateRowKeys(childNode);
    }
}

