/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import jakarta.faces.context.FacesContext;

public class AgentUtils {
    private AgentUtils() {
    }

    private static String getUserAgent(FacesContext context) {
        return (String)context.getExternalContext().getRequestHeaderMap().get("User-Agent");
    }

    private static boolean userAgentContains(FacesContext context, String fragment) {
        String userAgent = AgentUtils.getUserAgent(context);
        if (userAgent == null) {
            return false;
        }
        return userAgent.contains(fragment);
    }

    public static boolean isFirefox(FacesContext context) {
        return AgentUtils.userAgentContains(context, "Firefox");
    }

    public static boolean isEdge(FacesContext context) {
        return AgentUtils.userAgentContains(context, "Edge");
    }

    public static boolean isIE(FacesContext context) {
        return AgentUtils.userAgentContains(context, "MSIE");
    }

    @Deprecated
    public static boolean isIE(FacesContext context, int value) {
        String userAgent = AgentUtils.getUserAgent(context);
        if (userAgent == null) {
            return false;
        }
        int index = userAgent.indexOf("MSIE");
        if (index == -1) {
            return false;
        }
        int version = Double.valueOf(userAgent.substring(index + 5, userAgent.indexOf(59, index))).intValue();
        return version == value;
    }

    @Deprecated
    public static boolean isLessThanIE(FacesContext context, int value) {
        String userAgent = AgentUtils.getUserAgent(context);
        if (userAgent == null) {
            return false;
        }
        int index = userAgent.indexOf("MSIE");
        if (index == -1) {
            return false;
        }
        int version = Double.valueOf(userAgent.substring(index + 5, userAgent.indexOf(59, index))).intValue();
        return version > value;
    }

    public static boolean isMac(FacesContext context) {
        return AgentUtils.userAgentContains(context, "Mac");
    }
}

