/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import jakarta.el.ValueExpression;
import jakarta.faces.FacesException;
import jakarta.faces.application.Application;
import jakarta.faces.application.Resource;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIOutput;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.primefaces.context.PrimeRequestContext;
import org.primefaces.util.LangUtils;

public class ResourceUtils {
    public static final String RENDERER_SCRIPT = "jakarta.faces.resource.Script";
    public static final String RENDERER_STYLESHEET = "jakarta.faces.resource.Stylesheet";

    private ResourceUtils() {
    }

    public static String getResourceURL(FacesContext context, String value) {
        if (LangUtils.isBlank(value)) {
            return "";
        }
        if (value.contains("/javax.faces.resource")) {
            return value;
        }
        String url = context.getApplication().getViewHandler().getResourceURL(context, value);
        return context.getExternalContext().encodeResourceURL(url);
    }

    public static void addNoCacheControl(ExternalContext externalContext) {
        externalContext.setResponseHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        externalContext.setResponseHeader("Pragma", "no-cache");
        externalContext.setResponseHeader("Expires", "0");
    }

    public static void addResponseCookie(FacesContext context, String name, String value, Map<String, Object> properties) {
        PrimeRequestContext requestContext;
        if (properties == null) {
            properties = new HashMap<String, Object>(2);
        }
        if ((requestContext = PrimeRequestContext.getCurrentInstance(context)).isSecure() && requestContext.getApplicationContext().getConfig().isCookiesSecure()) {
            properties.put("secure", true);
        }
        context.getExternalContext().addResponseCookie(name, value, properties);
    }

    public static String appendCacheBuster(String url, boolean cache) {
        if (url == null) {
            return url;
        }
        url = url + (url.contains("?") ? "&" : "?");
        url = url + "pfdrid_c=" + cache;
        if (!cache) {
            url = url + "&uid=" + UUID.randomUUID().toString();
        }
        return url;
    }

    public static String getResourceRequestPath(FacesContext context, String resourceName) {
        Resource resource = context.getApplication().getResourceHandler().createResource(resourceName, "primefaces");
        return resource.getRequestPath();
    }

    public static void addComponentResource(FacesContext context, String name, String library, String target) {
        Application application = context.getApplication();
        UIComponent componentResource = application.createComponent("jakarta.faces.Output");
        componentResource.setRendererType(application.getResourceHandler().getRendererTypeForResourceName(name));
        componentResource.getAttributes().put("name", name);
        componentResource.getAttributes().put("library", library);
        componentResource.getAttributes().put("target", target);
        context.getViewRoot().addComponentResource(context, componentResource, target);
    }

    public static void addComponentResource(FacesContext context, String name, String library) {
        ResourceUtils.addComponentResource(context, name, library, "head");
    }

    public static void addComponentResource(FacesContext context, String name) {
        ResourceUtils.addComponentResource(context, name, "primefaces", "head");
    }

    public static boolean isScript(UIComponent component) {
        return RENDERER_SCRIPT.equals(component.getRendererType());
    }

    public static boolean isStylesheet(UIComponent component) {
        return RENDERER_STYLESHEET.equals(component.getRendererType());
    }

    public static List<ResourceInfo> getComponentResources(FacesContext context) {
        ArrayList<ResourceInfo> resourceInfos = new ArrayList<ResourceInfo>();
        List resources = context.getViewRoot().getComponentResources(context, "head");
        if (resources != null) {
            for (int i = 0; i < resources.size(); ++i) {
                UIComponent resource = (UIComponent)resources.get(i);
                ResourceInfo resourceInfo = ResourceUtils.newResourceInfo(resource);
                if (resourceInfo == null || resourceInfos.contains(resourceInfo)) continue;
                resourceInfos.add(resourceInfo);
            }
        }
        return resourceInfos;
    }

    public static boolean isInline(ResourceInfo resourceInfo) {
        if (resourceInfo != null) {
            return LangUtils.isBlank(resourceInfo.getLibrary()) && LangUtils.isBlank(resourceInfo.getName());
        }
        return false;
    }

    public static ResourceInfo newResourceInfo(UIComponent component) {
        if (!(component instanceof UIOutput)) {
            return null;
        }
        String library = (String)component.getAttributes().get("library");
        String name = (String)component.getAttributes().get("name");
        return new ResourceInfo(library, name, component);
    }

    public static Resource newResource(ResourceInfo resourceInfo, FacesContext context) {
        Resource resource = context.getApplication().getResourceHandler().createResource(resourceInfo.getName(), resourceInfo.getLibrary());
        if (resource == null) {
            throw new FacesException("Resource '" + resourceInfo.getName() + "' in library '" + resourceInfo.getLibrary() + "' not found!");
        }
        return resource;
    }

    public static String getMonitorKeyCookieName(FacesContext context, ValueExpression monitorKey) {
        String evaluated;
        String monitorKeyCookieName = "primefaces.download" + context.getViewRoot().getViewId().replace('/', '_');
        if (monitorKey != null && LangUtils.isNotBlank(evaluated = (String)monitorKey.getValue(context.getELContext()))) {
            monitorKeyCookieName = monitorKeyCookieName + "_" + evaluated;
        }
        return monitorKeyCookieName;
    }

    public static class ResourceInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String library;
        private String name;
        private UIComponent resource;

        public ResourceInfo(String library, String name, UIComponent resource) {
            this.library = library;
            this.name = name;
            this.resource = resource;
        }

        public String getLibrary() {
            return this.library;
        }

        public void setLibrary(String library) {
            this.library = library;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public UIComponent getResource() {
            return this.resource;
        }

        public void setResource(UIComponent resource) {
            this.resource = resource;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceInfo that = (ResourceInfo)o;
            return Objects.equals(this.library, that.library) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.library, this.name);
        }
    }
}

