/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.validate.bean;

import jakarta.el.PropertyNotFoundException;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.metadata.ConstraintDescriptor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.metadata.BeanValidationMetadataExtractor;
import org.primefaces.util.MapBuilder;
import org.primefaces.validate.bean.AssertFalseClientValidationConstraint;
import org.primefaces.validate.bean.AssertTrueClientValidationConstraint;
import org.primefaces.validate.bean.BeanValidationMetadata;
import org.primefaces.validate.bean.ClientConstraint;
import org.primefaces.validate.bean.ClientValidationConstraint;
import org.primefaces.validate.bean.DecimalMaxClientValidationConstraint;
import org.primefaces.validate.bean.DecimalMinClientValidationConstraint;
import org.primefaces.validate.bean.DigitsClientValidationConstraint;
import org.primefaces.validate.bean.EmailClientValidationConstraint;
import org.primefaces.validate.bean.FutureClientValidationConstraint;
import org.primefaces.validate.bean.FutureOrPresentClientValidationConstraint;
import org.primefaces.validate.bean.MaxClientValidationConstraint;
import org.primefaces.validate.bean.MessageInterpolatingConstraintWrapper;
import org.primefaces.validate.bean.MinClientValidationConstraint;
import org.primefaces.validate.bean.NegativeClientValidationConstraint;
import org.primefaces.validate.bean.NegativeOrZeroClientValidationConstraint;
import org.primefaces.validate.bean.NotBlankClientValidationConstraint;
import org.primefaces.validate.bean.NotEmptyClientValidationConstraint;
import org.primefaces.validate.bean.NotNullClientValidationConstraint;
import org.primefaces.validate.bean.NullClientValidationConstraint;
import org.primefaces.validate.bean.PastClientValidationConstraint;
import org.primefaces.validate.bean.PastOrPresentClientValidationConstraint;
import org.primefaces.validate.bean.PatternClientValidationConstraint;
import org.primefaces.validate.bean.PositiveClientValidationConstraint;
import org.primefaces.validate.bean.PositiveOrZeroClientValidationConstraint;
import org.primefaces.validate.bean.SizeClientValidationConstraint;

public class BeanValidationMetadataMapper {
    private static final Logger LOGGER = Logger.getLogger(BeanValidationMetadataMapper.class.getName());
    private static final Map<String, ClientValidationConstraint> CONSTRAINT_MAPPING = MapBuilder.builder().put("jakarta.validation.constraints.AssertFalse", new AssertFalseClientValidationConstraint()).put("jakarta.validation.constraints.AssertTrue", (AssertFalseClientValidationConstraint)((Object)new AssertTrueClientValidationConstraint())).put("jakarta.validation.constraints.DecimalMax", (AssertFalseClientValidationConstraint)((Object)new DecimalMaxClientValidationConstraint())).put("jakarta.validation.constraints.DecimalMin", (AssertFalseClientValidationConstraint)((Object)new DecimalMinClientValidationConstraint())).put("jakarta.validation.constraints.Digits", (AssertFalseClientValidationConstraint)((Object)new DigitsClientValidationConstraint())).put("jakarta.validation.constraints.Email", (AssertFalseClientValidationConstraint)((Object)new EmailClientValidationConstraint())).put("jakarta.validation.constraints.Future", (AssertFalseClientValidationConstraint)((Object)new FutureClientValidationConstraint())).put("jakarta.validation.constraints.FutureOrPresent", (AssertFalseClientValidationConstraint)((Object)new FutureOrPresentClientValidationConstraint())).put("jakarta.validation.constraints.Max", (AssertFalseClientValidationConstraint)((Object)new MaxClientValidationConstraint())).put("jakarta.validation.constraints.Min", (AssertFalseClientValidationConstraint)((Object)new MinClientValidationConstraint())).put("jakarta.validation.constraints.Negative", (AssertFalseClientValidationConstraint)((Object)new NegativeClientValidationConstraint())).put("jakarta.validation.constraints.NegativeOrZero", (AssertFalseClientValidationConstraint)((Object)new NegativeOrZeroClientValidationConstraint())).put("jakarta.validation.constraints.NotBlank", (AssertFalseClientValidationConstraint)((Object)new NotBlankClientValidationConstraint())).put("jakarta.validation.constraints.NotEmpty", (AssertFalseClientValidationConstraint)((Object)new NotEmptyClientValidationConstraint())).put("jakarta.validation.constraints.NotNull", (AssertFalseClientValidationConstraint)((Object)new NotNullClientValidationConstraint())).put("jakarta.validation.constraints.Null", (AssertFalseClientValidationConstraint)((Object)new NullClientValidationConstraint())).put("jakarta.validation.constraints.Past", (AssertFalseClientValidationConstraint)((Object)new PastClientValidationConstraint())).put("jakarta.validation.constraints.PastOrPresent", (AssertFalseClientValidationConstraint)((Object)new PastOrPresentClientValidationConstraint())).put("jakarta.validation.constraints.Pattern", (AssertFalseClientValidationConstraint)((Object)new PatternClientValidationConstraint())).put("jakarta.validation.constraints.Positive", (AssertFalseClientValidationConstraint)((Object)new PositiveClientValidationConstraint())).put("jakarta.validation.constraints.PositiveOrZero", (AssertFalseClientValidationConstraint)((Object)new PositiveOrZeroClientValidationConstraint())).put("jakarta.validation.constraints.Size", (AssertFalseClientValidationConstraint)((Object)new SizeClientValidationConstraint())).build();

    private BeanValidationMetadataMapper() {
    }

    public static BeanValidationMetadata resolveValidationMetadata(FacesContext context, UIComponent component, PrimeApplicationContext applicationContext) throws IOException {
        ArrayList<String> validatorIds;
        HashMap<String, Object> metadata;
        block13: {
            metadata = null;
            validatorIds = null;
            try {
                Set<ConstraintDescriptor<?>> constraints = BeanValidationMetadataExtractor.extractAllConstraintDescriptors(context, applicationContext, component.getValueExpression("value"));
                if (constraints == null || constraints.isEmpty()) break block13;
                boolean interpolateClientSideValidationMessages = applicationContext.getConfig().isInterpolateClientSideValidationMessages();
                MessageInterpolator messageInterpolator = null;
                if (interpolateClientSideValidationMessages) {
                    messageInterpolator = applicationContext.getValidatorFactory().getMessageInterpolator();
                }
                for (ConstraintDescriptor<?> constraintDescriptor : constraints) {
                    Map<String, Object> constraintMetadata;
                    Class<?> resolvedBy;
                    ClientConstraint clientConstraint;
                    Class<? extends Annotation> annotationType = constraintDescriptor.getAnnotation().annotationType();
                    ClientValidationConstraint clientValidationConstraint = CONSTRAINT_MAPPING.get(annotationType.getName());
                    if (clientValidationConstraint == null && (clientConstraint = annotationType.getAnnotation(ClientConstraint.class)) != null && (resolvedBy = clientConstraint.resolvedBy()) != null) {
                        try {
                            clientValidationConstraint = (ClientValidationConstraint)resolvedBy.getConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (Exception e) {
                            throw new FacesException("Could not instantiate ClientValidationConstraint!", (Throwable)e);
                        }
                    }
                    if (clientValidationConstraint == null) continue;
                    String validatorId = clientValidationConstraint.getValidatorId();
                    if (interpolateClientSideValidationMessages) {
                        MessageInterpolatingConstraintWrapper interpolatingConstraint = new MessageInterpolatingConstraintWrapper(messageInterpolator, constraintDescriptor);
                        constraintMetadata = clientValidationConstraint.getMetadata(interpolatingConstraint);
                    } else {
                        constraintMetadata = clientValidationConstraint.getMetadata(constraintDescriptor);
                    }
                    if (constraintMetadata != null) {
                        if (metadata == null) {
                            metadata = new HashMap<String, Object>();
                        }
                        metadata.putAll(constraintMetadata);
                    }
                    if (validatorId == null) continue;
                    if (validatorIds == null) {
                        validatorIds = new ArrayList<String>();
                    }
                    validatorIds.add(validatorId);
                }
            }
            catch (PropertyNotFoundException e) {
                String message = "Skip resolving of CSV BV metadata for component \"" + component.getClientId(context) + "\" because the ValueExpression of the \"value\" attribute isn't resolvable completely (e.g. a sub-expression returns null)";
                LOGGER.log(Level.FINE, message);
            }
        }
        if (metadata == null && validatorIds == null) {
            return null;
        }
        return new BeanValidationMetadata(metadata, validatorIds);
    }

    public static void registerConstraintMapping(Class<? extends Annotation> constraint, ClientValidationConstraint clientValidationConstraint) {
        CONSTRAINT_MAPPING.put(constraint.getName(), clientValidationConstraint);
    }

    public static ClientValidationConstraint removeConstraintMapping(Class<? extends Annotation> constraint) {
        return CONSTRAINT_MAPPING.remove(constraint.getName());
    }
}

