/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.application.resource;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;
import org.primefaces.application.resource.MoveScriptsToBottomState;
import org.primefaces.util.AgentUtils;
import org.primefaces.util.LangUtils;

public class MoveScriptsToBottomResponseWriter
extends ResponseWriterWrapper {
    private static final String SCRIPT_TAG = "script";
    private static final String BODY_TAG = "body";
    private static final String HTML_TAG = "html";
    private static final String SCRIPT_TYPE = "text/javascript";
    private static final String TYPE_ATTRIBUTE = "type";
    private final ResponseWriter wrapped;
    private final MoveScriptsToBottomState state;
    private boolean inScript;
    private String scriptType;
    private Map<String, String> includeAttributes;
    private StringBuilder inline;
    private boolean scriptsRendered;
    private boolean writeFouc;

    public MoveScriptsToBottomResponseWriter(ResponseWriter wrapped, MoveScriptsToBottomState state) {
        this.wrapped = wrapped;
        this.state = state;
        this.inScript = false;
        this.scriptsRendered = false;
        this.writeFouc = false;
        this.includeAttributes = new LinkedHashMap<String, String>(6);
        this.inline = new StringBuilder(75);
    }

    public ResponseWriter getWrapped() {
        return this.wrapped;
    }

    public void write(int c) throws IOException {
        if (this.inScript) {
            this.inline.append((char)c);
        } else {
            this.getWrapped().write(c);
        }
    }

    public void write(char[] cbuf) throws IOException {
        if (this.inScript) {
            this.inline.append(cbuf);
        } else {
            this.getWrapped().write(cbuf);
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.inScript) {
            this.inline.append(cbuf, off, len);
        } else {
            this.getWrapped().write(cbuf, off, len);
        }
    }

    public void write(String str) throws IOException {
        if (this.inScript) {
            this.inline.append(str);
        } else {
            this.getWrapped().write(str);
        }
    }

    public void writeText(char[] cbuf, int off, int len) throws IOException {
        if (this.inScript) {
            this.inline.append(cbuf, off, len);
        } else {
            this.getWrapped().writeText(cbuf, off, len);
        }
    }

    public void writeText(Object text, String property) throws IOException {
        if (this.inScript) {
            this.inline.append(text);
        } else {
            this.getWrapped().writeText(text, property);
        }
    }

    public void writeText(Object text, UIComponent component, String property) throws IOException {
        if (this.inScript) {
            this.inline.append(text);
        } else {
            this.getWrapped().writeText(text, property);
        }
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        if (this.inScript) {
            this.updateAttributes(name, (String)value);
        } else {
            this.getWrapped().writeAttribute(name, value, property);
        }
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        if (this.inScript) {
            this.updateAttributes(name, (String)value);
        } else {
            this.getWrapped().writeURIAttribute(name, value, property);
        }
    }

    public void startElement(String name, UIComponent component) throws IOException {
        if (SCRIPT_TAG.equalsIgnoreCase(name)) {
            this.inScript = true;
            this.scriptType = SCRIPT_TYPE;
        } else {
            this.writeFouc();
            this.getWrapped().startElement(name, component);
            if (BODY_TAG.equalsIgnoreCase(name) && this.isFirefox()) {
                this.writeFouc = true;
            }
        }
    }

    public void endElement(String name) throws IOException {
        if (SCRIPT_TAG.equalsIgnoreCase(name)) {
            this.inScript = false;
            this.state.addInline(this.scriptType, this.inline);
            if (LangUtils.isNotBlank(this.includeAttributes.get("src"))) {
                this.state.addInclude(this.scriptType, this.includeAttributes);
            }
            this.scriptType = null;
            this.includeAttributes.clear();
            this.inline.setLength(0);
        } else if (BODY_TAG.equalsIgnoreCase(name) || HTML_TAG.equalsIgnoreCase(name) && !this.scriptsRendered) {
            for (Map.Entry<String, List<Map<String, String>>> entry : this.state.getIncludes().entrySet()) {
                List<Map<String, String>> includes = entry.getValue();
                for (int i = 0; i < includes.size(); ++i) {
                    Map<String, String> attributes = includes.get(i);
                    attributes.put(TYPE_ATTRIBUTE, entry.getKey());
                    this.getWrapped().startElement(SCRIPT_TAG, null);
                    for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                        String attributeName = attribute.getKey();
                        String attributeValue = attribute.getValue();
                        if (!LangUtils.isNotBlank(attributeValue)) continue;
                        this.getWrapped().writeAttribute(attributeName, (Object)attributeValue, null);
                    }
                    this.getWrapped().endElement(SCRIPT_TAG);
                }
            }
            for (Map.Entry<String, List<Object>> entry : this.state.getInlines().entrySet()) {
                String type = entry.getKey();
                List<Object> inlines = entry.getValue();
                String id = UUID.randomUUID().toString();
                String merged = this.mergeAndMinimizeInlineScripts(id, type, inlines);
                if (!LangUtils.isNotBlank(merged)) continue;
                this.getWrapped().startElement(SCRIPT_TAG, null);
                this.getWrapped().writeAttribute("id", (Object)id, null);
                this.getWrapped().writeAttribute(TYPE_ATTRIBUTE, (Object)type, null);
                this.getWrapped().write(merged);
                this.getWrapped().endElement(SCRIPT_TAG);
            }
            this.getWrapped().endElement(name);
            this.scriptsRendered = true;
        } else {
            this.getWrapped().endElement(name);
        }
    }

    protected void writeFouc() throws IOException {
        if (this.writeFouc) {
            this.writeFouc = false;
            this.getWrapped().startElement(SCRIPT_TAG, null);
            this.getWrapped().writeText((Object)"/*FIREFOX_FOUC_FIX*/", null);
            this.getWrapped().endElement(SCRIPT_TAG);
        }
    }

    protected String mergeAndMinimizeInlineScripts(String id, String type, List<String> inlines) {
        StringBuilder script = new StringBuilder(inlines.size() * 100);
        for (int i = 0; i < inlines.size(); ++i) {
            if (i > 0) {
                script.append("\n");
            }
            script.append(inlines.get(i));
            script.append(";");
        }
        String minimized = script.toString();
        if (LangUtils.isNotBlank(minimized) && SCRIPT_TYPE.equalsIgnoreCase(type)) {
            if ((minimized = minimized.replace(";;", ";")).contains("PrimeFaces")) {
                minimized = minimized.replace("PrimeFaces.settings", "pf.settings").replace("PrimeFaces.cw", "pf.cw").replace("PrimeFaces.ab", "pf.ab").replace("window.PrimeFaces", "pf");
                minimized = "var pf=window.PrimeFaces;" + minimized;
            }
            if (!minimized.endsWith(";")) {
                minimized = minimized + ";";
            }
            minimized = minimized + "document.getElementById('" + id + "').remove();";
        }
        return minimized;
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        return this.getWrapped().cloneWithWriter(writer);
    }

    protected void updateAttributes(String name, String value) {
        this.includeAttributes.put(name, value);
        if (TYPE_ATTRIBUTE.equalsIgnoreCase(name) && LangUtils.isNotBlank(value)) {
            this.scriptType = value;
        }
    }

    protected boolean isFirefox() {
        return AgentUtils.isFirefox(FacesContext.getCurrentInstance());
    }
}

