/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.accordionpanel;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.accordionpanel.AccordionPanel;
import org.primefaces.component.menu.Menu;
import org.primefaces.component.tabview.Tab;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.MessageFactory;
import org.primefaces.util.WidgetBuilder;

public class AccordionPanelRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        AccordionPanel acco = (AccordionPanel)component;
        Map params = context.getExternalContext().getRequestParameterMap();
        String active = (String)params.get(acco.getClientId(context) + "_active");
        if (active != null) {
            if (this.isValueBlank(active)) {
                acco.setActiveIndex("");
            } else {
                acco.setActiveIndex(active);
            }
        }
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Map params = context.getExternalContext().getRequestParameterMap();
        AccordionPanel acco = (AccordionPanel)component;
        if (acco.isContentLoadRequest(context)) {
            String clientId = acco.getClientId(context);
            if (acco.isRepeating()) {
                int index = Integer.parseInt((String)params.get(clientId + "_tabindex"));
                acco.setIndex(index);
                Tab tabToLoad = acco.getDynamicTab();
                tabToLoad.encodeAll(context);
                if (acco.isDynamic()) {
                    tabToLoad.setLoaded(index, true);
                }
                acco.setIndex(-1);
            } else {
                String tabClientId = (String)params.get(clientId + "_newTab");
                Tab tabToLoad = acco.findTab(tabClientId);
                tabToLoad.encodeAll(context);
                tabToLoad.setLoaded(true);
            }
        } else {
            acco.resetLoadedTabsState();
            this.encodeMarkup(context, acco);
            this.encodeScript(context, acco);
        }
    }

    protected void encodeMarkup(FacesContext context, AccordionPanel acco) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = acco.getClientId(context);
        String widgetVar = acco.resolveWidgetVar(context);
        String styleClass = acco.getStyleClass();
        String string = styleClass = styleClass == null ? "ui-accordion ui-widget ui-helper-reset ui-hidden-container" : "ui-accordion ui-widget ui-helper-reset ui-hidden-container " + styleClass;
        if (ComponentUtils.isRTL(context, acco)) {
            styleClass = styleClass + " ui-accordion-rtl";
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (acco.getStyle() != null) {
            writer.writeAttribute("style", (Object)acco.getStyle(), null);
        }
        writer.writeAttribute("role", (Object)"tablist", null);
        writer.writeAttribute("data-widget", (Object)widgetVar, null);
        this.renderDynamicPassThruAttributes(context, (UIComponent)acco);
        this.encodeTabs(context, acco);
        this.encodeStateHolder(context, acco);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, AccordionPanel acco) throws IOException {
        boolean multiple = acco.isMultiple();
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("AccordionPanel", acco);
        if (acco.isDynamic()) {
            wb.attr("dynamic", true).attr("cache", acco.isCache());
        }
        wb.attr("multiple", multiple, false).callback("onTabChange", "function(panel)", acco.getOnTabChange()).callback("onTabShow", "function(panel)", acco.getOnTabShow()).callback("onTabClose", "function(panel)", acco.getOnTabClose());
        if (acco.getTabController() != null) {
            wb.attr("controlled", true);
        }
        this.encodeClientBehaviors(context, acco);
        wb.finish();
    }

    protected void encodeStateHolder(FacesContext context, AccordionPanel accordionPanel) throws IOException {
        String clientId = accordionPanel.getClientId(context);
        String stateHolderId = clientId + "_active";
        this.renderHiddenInput(context, stateHolderId, accordionPanel.getActiveIndex(), false);
    }

    protected void encodeTabs(FacesContext context, AccordionPanel acco) throws IOException {
        List<String> activeIndexes;
        boolean dynamic = acco.isDynamic();
        boolean repeating = acco.isRepeating();
        boolean rtl = acco.getDir().equalsIgnoreCase("rtl");
        String activeIndex = acco.getActiveIndex();
        List<String> list = activeIndexes = activeIndex == null ? Collections.emptyList() : Arrays.asList(activeIndex.split(","));
        if (repeating) {
            int dataCount = acco.getRowCount();
            Tab tab = acco.getDynamicTab();
            for (int i = 0; i < dataCount; ++i) {
                acco.setIndex(i);
                boolean active = this.isActive(tab, activeIndexes, i);
                this.encodeTab(context, acco, tab, i, active, dynamic, repeating, rtl);
            }
            acco.setIndex(-1);
        } else {
            int j = 0;
            for (int i = 0; i < acco.getChildCount(); ++i) {
                UIComponent child = (UIComponent)acco.getChildren().get(i);
                if (!child.isRendered() || !(child instanceof Tab)) continue;
                Tab tab = (Tab)child;
                boolean active = this.isActive(tab, activeIndexes, j);
                this.encodeTab(context, acco, tab, j, active, dynamic, repeating, rtl);
                ++j;
            }
        }
    }

    protected boolean isActive(Tab tab, List<String> activeIndexes, int index) {
        boolean active = activeIndexes.indexOf(Integer.toString(index)) != -1;
        return active && !tab.isDisabled();
    }

    protected void encodeTab(FacesContext context, AccordionPanel accordionPanel, Tab tab, int index, boolean active, boolean dynamic, boolean repeating, boolean rtl) throws IOException {
        UIComponent actionsFacet;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = tab.getClientId(context);
        Menu optionsMenu = tab.getOptionsMenu();
        String headerStyleClass = this.getStyleClassBuilder(context).add(active, "ui-accordion-header ui-helper-reset ui-state-default ui-state-active ui-corner-top", "ui-accordion-header ui-helper-reset ui-state-default ui-corner-all").add(tab.isDisabled(), "ui-state-disabled").add(tab.getTitleStyleClass()).build();
        String iconStyleClass = this.getStyleClassBuilder(context).add(active, "ui-icon ui-icon-triangle-1-s").add(!active && rtl, "ui-icon ui-icon-triangle-1-w").add(!active && !rtl, "ui-icon ui-icon-triangle-1-e").build();
        String contentStyleClass = this.getStyleClassBuilder(context).add(active, "ui-accordion-content ui-helper-reset ui-widget-content", "ui-accordion-content ui-helper-reset ui-widget-content ui-helper-hidden").build();
        UIComponent titleFacet = tab.getFacet("title");
        String title = tab.getTitle();
        String tabindex = tab.isDisabled() ? "-1" : accordionPanel.getTabindex();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_header"), null);
        writer.writeAttribute("class", (Object)headerStyleClass, null);
        writer.writeAttribute("role", (Object)"tab", null);
        writer.writeAttribute("aria-expanded", (Object)String.valueOf(active), null);
        writer.writeAttribute("aria-selected", (Object)String.valueOf(active), null);
        writer.writeAttribute("aria-label", (Object)tab.getAriaLabel(), null);
        writer.writeAttribute("tabindex", (Object)tabindex, null);
        if (tab.getTitleStyle() != null) {
            writer.writeAttribute("style", (Object)tab.getTitleStyle(), null);
        }
        if (tab.getTitletip() != null) {
            writer.writeAttribute("title", (Object)tab.getTitletip(), null);
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)iconStyleClass, null);
        writer.endElement("span");
        if (ComponentUtils.shouldRenderFacet(titleFacet)) {
            titleFacet.encodeAll(context);
        } else if (title != null) {
            writer.writeText((Object)title, null);
        } else {
            writer.write("&nbsp;");
        }
        if (optionsMenu != null) {
            this.encodeIcon(context, tab, "ui-icon-gear", clientId + "_menu", tab.getMenuTitle(), MessageFactory.getMessage("primefaces.panel.aria.OPTIONS_MENU", new Object[0]));
        }
        if (ComponentUtils.shouldRenderFacet(actionsFacet = tab.getFacet("actions"))) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"ui-panel-actions", null);
            writer.writeAttribute("onclick", (Object)"event.stopPropagation()", null);
            actionsFacet.encodeAll(context);
            writer.endElement("div");
        }
        writer.endElement("div");
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)contentStyleClass, null);
        writer.writeAttribute("role", (Object)"tabpanel", null);
        writer.writeAttribute("aria-hidden", (Object)String.valueOf(!active), null);
        if (dynamic) {
            if (active) {
                tab.encodeAll(context);
                if (repeating) {
                    tab.setLoaded(index, true);
                } else {
                    tab.setLoaded(true);
                }
            }
        } else {
            tab.encodeAll(context);
        }
        if (optionsMenu != null) {
            optionsMenu.setOverlay(true);
            optionsMenu.setTrigger("@(#" + ComponentUtils.escapeSelector(clientId) + "_menu)");
            optionsMenu.setMy("left top");
            optionsMenu.setAt("left bottom");
            optionsMenu.encodeAll(context);
        }
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeIcon(FacesContext context, Tab tab, String iconClass, String id, String title, String ariaLabel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", null);
        if (id != null) {
            writer.writeAttribute("id", (Object)id, null);
        }
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("class", (Object)"ui-panel-titlebar-icon ui-corner-all ui-state-default", null);
        if (title != null) {
            writer.writeAttribute("title", (Object)title, null);
        }
        if (ariaLabel != null) {
            writer.writeAttribute("aria-label", (Object)ariaLabel, null);
        }
        writer.writeAttribute("onclick", (Object)"event.stopPropagation()", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)("ui-icon " + iconClass), null);
        writer.endElement("span");
        writer.endElement("a");
    }
}

